/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class JsonUtils {
    private static final Log logger = LogFactory.getLog(JsonUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String toString(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            logger.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", "obj to json string err"), new Object[0]);
        }
    }

    public static <T> T toObject(String jsonStr, TypeReference<T> typeReference) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, typeReference);
        }
        catch (JsonProcessingException e) {
            logger.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", "json parse error"), new Object[0]);
        }
    }
}

