/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.application;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.domain.calibrate.CalibrateSessionService;
import kd.tdc.oatr.bussiness.domain.calibrate.OnlineCalibrationDomainService;
import kd.tdc.oatr.bussiness.queryservice.ReviewTalentMapQueryService;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;
import org.apache.commons.lang3.ArrayUtils;

public class CalibrateSessionApplicationService {
    private final CalibrateSessionService calibrateSessionService = ServiceFactory.getService(CalibrateSessionService.class);
    private final ReviewTalentMapQueryService talentMapQueryService = ServiceFactory.getService(ReviewTalentMapQueryService.class);
    private final OnlineCalibrationDomainService onlineCalibrationService = ServiceFactory.getService(OnlineCalibrationDomainService.class);

    public Map<String, String> getSessionTalentMapName(Long activityId) {
        return this.calibrateSessionService.getSessionTalentMapName(activityId);
    }

    public String beginCalibrate(Long sessionId) {
        DynamicObject calibrateSession = this.calibrateSessionService.getCalibrateSession(sessionId);
        Long activityId = calibrateSession.getLong("reviewactivity.id");
        String talentMap = calibrateSession.getString("talentmap");
        if (HRStringUtils.isEmpty((String)talentMap)) {
            return "talentMapEmpty";
        }
        DynamicObject talentMapConfig = this.talentMapQueryService.getOneTalentMapConfig(activityId, Long.valueOf(talentMap));
        return this.calibrateSessionService.beginCalibrate(sessionId, talentMapConfig);
    }

    public void finishCalibrate(Long sessionId) {
        this.calibrateSessionService.finishCalibrate(sessionId);
    }

    public void updateCalibrateSessionPersonNum(List<Long> calibrateIds) {
        DynamicObject[] calibrateSessionObj = this.calibrateSessionService.listCalibrateSessionById(calibrateIds);
        Object[] onlineCalibrations = this.onlineCalibrationService.getOnlineCalibration(calibrateIds);
        if (ArrayUtils.isNotEmpty((Object[])onlineCalibrations)) {
            Map<Long, Long> calibrateSessionIdPersonNumMap = Arrays.stream(onlineCalibrations).collect(Collectors.groupingBy(obj -> obj.getLong("calibratesession"), Collectors.counting()));
            for (DynamicObject calibrateObj : calibrateSessionObj) {
                long id = calibrateObj.getLong("id");
                Long personNum = calibrateSessionIdPersonNumMap.get(id);
                if (personNum != null) {
                    calibrateObj.set("calibratepersonnum", (Object)personNum);
                    continue;
                }
                calibrateObj.set("calibratepersonnum", (Object)0);
            }
        } else {
            for (DynamicObject calibrateObj : calibrateSessionObj) {
                calibrateObj.set("calibratepersonnum", (Object)0);
            }
        }
        this.calibrateSessionService.save(calibrateSessionObj);
    }

    public boolean validateWaitStartTalentMap(long sessionId) {
        DynamicObject calibrateSession = this.calibrateSessionService.getCalibrateSession(sessionId);
        String calibrateStatus = calibrateSession.getString("calibratestatus");
        if (!HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.WAIT_START.getCode())) {
            return true;
        }
        Long activityId = calibrateSession.getLong("reviewactivity.id");
        String talentMap = calibrateSession.getString("talentmap");
        if (HRStringUtils.isEmpty((String)talentMap)) {
            return false;
        }
        DynamicObject talentMapConfig = this.talentMapQueryService.getOneTalentMapConfig(activityId, Long.valueOf(talentMap));
        if (HRObjectUtils.isEmpty((Object)talentMapConfig)) {
            return false;
        }
        DynamicObjectCollection talentMapEntry = talentMapConfig.getDynamicObjectCollection("talentmapentry");
        return !talentMapEntry.isEmpty();
    }
}

