/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.application;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.CalibrateSessionApplicationService;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.calibrate.OnlineCalibrationDomainService;
import kd.tdc.oatr.bussiness.queryservice.CalibrateSessionQueryService;
import kd.tdc.oatr.bussiness.queryservice.OnlineCalibrationQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewObjectQueryService;
import kd.tdc.oatr.common.bo.onlinecalibration.PersonCardInfo;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;

public class OnlineCalibrationApplicationService {
    private final OnlineCalibrationDomainService calibrationDomainService = ServiceFactory.getService(OnlineCalibrationDomainService.class);
    private final ReviewObjectQueryService reviewObjectQueryService = ServiceFactory.getService(ReviewObjectQueryService.class);
    private final CalibrateSessionQueryService calSessionQueryService = ServiceFactory.getService(CalibrateSessionQueryService.class);
    private final ReviewActivityApplicationService reviewApplicationService = ServiceFactory.getService(ReviewActivityApplicationService.class);
    private final CalibrateSessionApplicationService sessionApplicationService = ServiceFactory.getService(CalibrateSessionApplicationService.class);
    private final ReviewActivityQueryService activityQueryService = ServiceFactory.getService(ReviewActivityQueryService.class);
    private final OnlineCalibrationQueryService calibrationQueryService = ServiceFactory.getService(OnlineCalibrationQueryService.class);

    public String updateOnlineCalibrateResult(Long calSessionId, Map<String, PersonCardInfo> personCardInfoMap) {
        QFilter sessionFilter = new QFilter("calibratesession.id", "=", (Object)calSessionId);
        ArrayList personIds = Lists.newArrayListWithExpectedSize((int)personCardInfoMap.size());
        personCardInfoMap.keySet().forEach(str -> personIds.add(Long.valueOf(str)));
        QFilter personFilter = new QFilter("person.id", "in", (Object)personIds);
        DynamicObject[] onlineCalFromDB = this.calibrationDomainService.queryOnlineCalibrateInfo("id,person,calibrateresult,calibratereason,reviewobject,modifier,modifytime", new QFilter[]{sessionFilter, personFilter});
        if (onlineCalFromDB == null || onlineCalFromDB.length == 0) {
            return "deleted";
        }
        Date now = new Date();
        for (DynamicObject onlineCalInfo : onlineCalFromDB) {
            String personId = onlineCalInfo.getString("person.id");
            PersonCardInfo personCardInfo = personCardInfoMap.get(personId);
            if (personCardInfo == null) continue;
            String afterCalibratePath = personCardInfo.getCalibratePath().getAfterCard();
            String calibrateResult = personCardInfo.isCalibrated() ? this.transCalibratePathToPosition(afterCalibratePath) : "";
            String calibrateReason = personCardInfo.getReason();
            onlineCalInfo.set("calibrateresult", (Object)calibrateResult);
            onlineCalInfo.set("calibratereason", (Object)(HRStringUtils.isNotEmpty((String)calibrateReason) ? calibrateReason : ""));
            long currUserId = RequestContext.get().getCurrUserId();
            onlineCalInfo.set("modifier", (Object)currUserId);
            onlineCalInfo.set("modifytime", (Object)now);
        }
        this.calibrationDomainService.updateOnlineCalibrateInfo(onlineCalFromDB);
        return "success";
    }

    public void syncOnlineCalibrationData(long activityId, long calibrateSessionId, List<Long> reviewObjIds, String talentMapId) {
        if (reviewObjIds.isEmpty()) {
            this.calibrationDomainService.deleteByCalibrateSessionId(calibrateSessionId);
            return;
        }
        DynamicObject[] reviewObjectData = this.reviewObjectQueryService.getReviewObjectData(reviewObjIds);
        this.calibrationDomainService.generateOnlineCalibration(activityId, calibrateSessionId, reviewObjIds, reviewObjectData, talentMapId);
    }

    public void beginCalibrate(List<DynamicObject> onlineCalibrationData) {
        if (CollectionUtils.isEmpty(onlineCalibrationData)) {
            return;
        }
        long sessionId = onlineCalibrationData.get(0).getLong("calibratesession.id");
        String beginCalibrate = this.sessionApplicationService.beginCalibrate(sessionId);
        if (!HRStringUtils.equals((String)beginCalibrate, (String)"success")) {
            return;
        }
        DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(sessionId);
        String talentMap = calibrateSession.getString("talentmap");
        List<Long> reviewObjIds = onlineCalibrationData.stream().map(onlineOriginalObj -> onlineOriginalObj.getLong("reviewobject.id")).collect(Collectors.toList());
        DynamicObject[] reviewObjectData = this.reviewObjectQueryService.getReviewObjectData(reviewObjIds);
        this.calibrationDomainService.updateOnlineCalibrateResultBefore(onlineCalibrationData, talentMap, reviewObjectData);
    }

    public void finishCalibrate(List<DynamicObject> calibrateObjs) {
        if (CollectionUtils.isEmpty(calibrateObjs)) {
            return;
        }
        long sessionId = calibrateObjs.get(0).getLong("calibratesession.id");
        DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(sessionId);
        if (HRObjectUtils.isEmpty((Object)calibrateSession)) {
            return;
        }
        String talentMapKey = calibrateSession.getString("talentmap");
        Map<Long, String> calibrateResultMap = calibrateObjs.stream().collect(Collectors.toMap(calibrateObj -> calibrateObj.getLong("reviewobject.id"), calibrateObj -> {
            String calibrateResult = calibrateObj.getString("calibrateresult");
            if (HRStringUtils.isNotEmpty((String)calibrateResult)) {
                return calibrateResult;
            }
            return calibrateObj.getString("calibratebefore");
        }, (v1, v2) -> v2));
        ArrayList<Long> reviewObjIds = new ArrayList<Long>(calibrateResultMap.keySet());
        this.calibrationDomainService.finishCalibrate(calibrateObjs);
        this.reviewApplicationService.updateCalibrateResult(reviewObjIds, calibrateResultMap, talentMapKey, sessionId);
        this.sessionApplicationService.finishCalibrate(sessionId);
    }

    public void recordCollaborationBusinessData(long activityId) {
        this.reviewApplicationService.recordCollaborationBusinessData(activityId);
    }

    public Map<Long, String> getCalibrateResultBefore(DynamicObject[] reviewObjectData, String talentMapKey) {
        return this.calibrationDomainService.getCalibrateResultBefore(reviewObjectData, talentMapKey);
    }

    public List<String> validateCalibrateCondition(long activityId, long sessionId, String collaborationFlag, List<String> requireCalibrateStatus) {
        String curCalibrateStatus;
        DynamicObject calibrateSession;
        ArrayList<String> errorMsg = new ArrayList<String>(10);
        DynamicObject reviewActivity = this.activityQueryService.getReviewActivity(activityId);
        if (HRObjectUtils.isEmpty((Object)reviewActivity)) {
            errorMsg.add("activityEmptyError");
            return errorMsg;
        }
        String activityStatus = reviewActivity.getString("activitystatus");
        if (!HRStringUtils.equals((String)ActivityStatusEnum.GOING.getCode(), (String)activityStatus)) {
            errorMsg.add("activityStatusError");
        }
        if (HRObjectUtils.isEmpty((Object)(calibrateSession = this.calSessionQueryService.getCalibrateSession(sessionId)))) {
            errorMsg.add("sessionEmptyError");
            return errorMsg;
        }
        boolean isMapExists = this.sessionApplicationService.validateWaitStartTalentMap(sessionId);
        if (!isMapExists) {
            errorMsg.add("talentMapError");
        }
        if (HRStringUtils.equals((String)collaborationFlag, (String)"1")) {
            long currUserId;
            DynamicObjectCollection organizers = calibrateSession.getDynamicObjectCollection("organizers");
            if (CollectionUtils.isEmpty((Collection)organizers)) {
                errorMsg.add("organizerError");
                return errorMsg;
            }
            List organizerIds = organizers.stream().map(organizer -> organizer.getLong("fbasedataid_id")).collect(Collectors.toList());
            if (!organizerIds.contains(currUserId = RequestContext.get().getCurrUserId())) {
                errorMsg.add("organizerError");
            }
        }
        if (!requireCalibrateStatus.contains(curCalibrateStatus = calibrateSession.getString("calibratestatus"))) {
            errorMsg.add("calibrateStatusError");
        }
        return errorMsg;
    }

    public List<Long> queryOnlineCalibrateReviewTool(long sessionId) {
        DynamicObject[] onlineCalibrationData = this.calibrationDomainService.listOnlineCalibrationData(sessionId);
        List<Long> reviewObjIds = Arrays.stream(onlineCalibrationData).map(onlineCalibration -> HRDyObjectPropUtil.getId((DynamicObject)onlineCalibration.getDynamicObject("reviewobject"))).collect(Collectors.toList());
        return this.reviewObjectQueryService.getReviewObjectReviewGroup(reviewObjIds);
    }

    public DynamicObject[] queryOnlineCalibrate(String props, QFilter[] filters) {
        return this.calibrationDomainService.queryOnlineCalibrateInfo(props, filters);
    }

    public String transCalibratePathToPosition(String calibratePath) {
        if (HRStringUtils.isEmpty((String)calibratePath)) {
            return "";
        }
        String[] split = calibratePath.trim().split("[()]");
        if (split.length != 2) {
            return "";
        }
        return MessageFormat.format("{0}-{1}", split[1], split[0]);
    }

    public String transCalibratePositionToPath(String calibratePosition) {
        if (HRStringUtils.isEmpty((String)calibratePosition)) {
            return "";
        }
        String[] split = calibratePosition.trim().split("-");
        if (split.length != 2) {
            return "";
        }
        return MessageFormat.format("{0}({1})", split[1], split[0]);
    }

    public Map<Long, List<Map<String, String>>> queryCalibrationHistory(long sessionId, String talentMapId, List<Long> reviewObjIds) {
        DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(sessionId);
        Date modifyTime = calibrateSession.getDate("modifytime");
        DynamicObject[] sessionObjs = this.calSessionQueryService.listCalibrateSessionByTalentMap(talentMapId);
        List<Long> sessionObjIds = Arrays.stream(sessionObjs).filter(sessionObj -> {
            Date time = sessionObj.getDate("modifytime");
            boolean isBefore = false;
            if (time != null && modifyTime != null) {
                isBefore = time.before(modifyTime);
            }
            boolean isNotCurrentSession = sessionObj.getLong("id") != sessionId;
            return isNotCurrentSession && isBefore;
        }).map(sessionObj -> sessionObj.getLong("id")).collect(Collectors.toList());
        DynamicObject[] onlineCalibrationObjs = this.calibrationQueryService.listOnlineCalibrationByReviewObject(reviewObjIds, sessionObjIds);
        List<DynamicObject> onlineCalibrationObjList = Arrays.asList(onlineCalibrationObjs);
        onlineCalibrationObjList.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Date date1 = o1.getDate("calibratesession.modifytime");
            Date date2 = o2.getDate("calibratesession.modifytime");
            if (date1 == null && date2 == null) {
                return 0;
            }
            if (date1 == null) {
                return -1;
            }
            if (date2 == null) {
                return 1;
            }
            if (date1.after(date2)) {
                return -1;
            }
            if (date2.after(date1)) {
                return 1;
            }
            return 0;
        });
        HashMap<Long, List<Map<String, String>>> calibrationHistoryData = new HashMap<Long, List<Map<String, String>>>(reviewObjIds.size());
        for (DynamicObject onlineCalibrationObj : onlineCalibrationObjList) {
            Long reviewObjId = onlineCalibrationObj.getLong("reviewobject.id");
            ArrayList hisDataList = (ArrayList)calibrationHistoryData.get(reviewObjId);
            if (hisDataList == null) {
                hisDataList = new ArrayList(10);
            }
            HashMap<String, String> hisDataMap = new HashMap<String, String>(5);
            String sessionName = onlineCalibrationObj.getString("calibratesession.name");
            String beforeCalibrate = onlineCalibrationObj.getString("calibratebefore");
            String calibrateResult = onlineCalibrationObj.getString("calibrateresult");
            String calibrateReason = onlineCalibrationObj.getString("calibratereason");
            hisDataMap.put("sessionName", sessionName);
            hisDataMap.put("beforeCalibrate", beforeCalibrate);
            hisDataMap.put("calibrateResult", calibrateResult);
            hisDataMap.put("calibrateReason", calibrateReason);
            hisDataList.add(hisDataMap);
            calibrationHistoryData.put(reviewObjId, hisDataList);
        }
        return calibrationHistoryData;
    }
}

