/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.application;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewPersonScopeConfigApplicationService;
import kd.tdc.oatr.bussiness.application.ext.AdminorgExternalService;
import kd.tdc.oatr.bussiness.domain.activity.ReviewActivityService;
import kd.tdc.oatr.bussiness.domain.activity.ReviewBusinessDataListService;
import kd.tdc.oatr.bussiness.domain.activitytpl.ReviewActivityTemplateService;
import kd.tdc.oatr.bussiness.domain.calibrate.CalibrateSessionService;
import kd.tdc.oatr.bussiness.domain.collaborator.ReviewCollaboratorService;
import kd.tdc.oatr.bussiness.domain.reviewgroup.ReviewGroupService;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.bussiness.domain.reviewplan.ReviewPlanService;
import kd.tdc.oatr.bussiness.queryservice.CalibrateSessionQueryService;
import kd.tdc.oatr.bussiness.queryservice.HRCSDataPermissionService;
import kd.tdc.oatr.bussiness.queryservice.PersonAboutQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewEmpEvalQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewObjectQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewSuperiorEvalQueryService;
import kd.tdc.oatr.bussiness.queryservice.TalentFileQueryService;
import kd.tdc.oatr.common.bo.CollaboratorObject;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;
import kd.tdc.oatr.common.utils.JsonUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReviewActivityApplicationService {
    private static final Log log = LogFactory.getLog(ReviewActivityApplicationService.class);
    private final ReviewGroupService reviewGroupService = ServiceFactory.getService(ReviewGroupService.class);
    private final ReviewActivityService reviewActivityService = ServiceFactory.getService(ReviewActivityService.class);
    private final ReviewActivityTemplateService reviewActivityTplService = ServiceFactory.getService(ReviewActivityTemplateService.class);
    private final ReviewPlanService reviewPlanService = ServiceFactory.getService(ReviewPlanService.class);
    private final ReviewObjectService reviewObjectService = ServiceFactory.getService(ReviewObjectService.class);
    private final TalentFileQueryService talentFileQueryService = ServiceFactory.getService(TalentFileQueryService.class);
    private final PersonAboutQueryService personAboutQueryService = ServiceFactory.getService(PersonAboutQueryService.class);
    private final CalibrateSessionService calibrateSessionService = ServiceFactory.getService(CalibrateSessionService.class);
    private static final HRCSDataPermissionService permissionService = ServiceFactory.getService(HRCSDataPermissionService.class);
    private final ReviewActivityQueryService activityQueryService = ServiceFactory.getService(ReviewActivityQueryService.class);
    private final ReviewObjectQueryService reviewObjectQueryService = ServiceFactory.getService(ReviewObjectQueryService.class);
    private final CalibrateSessionQueryService calSessionQueryService = ServiceFactory.getService(CalibrateSessionQueryService.class);
    private final ReviewCollaboratorService reviewCollaboratorService = ServiceFactory.getService(ReviewCollaboratorService.class);
    private static final AdminorgExternalService adminorgExternalService = ServiceFactory.getService(AdminorgExternalService.class);
    private static final HRBaseServiceHelper REVIEWOBJECT_HELPER = new HRBaseServiceHelper("oatr_reviewobject");

    public void saveReviewActivity(DynamicObject dataEntity, OperateOption operateOption) {
        this.initReviewGroup(dataEntity);
        this.activityUpdate(dataEntity, this::refreshDataByTplChange);
        Map<DynamicObject, Integer> activityTplNumOfRef = this.updateActivityNumOfRef("activitytemplate", dataEntity, this.reviewActivityTplService::updateTemplateActivityNumOfRef);
        operateOption.setVariableValue("update_num_flagactivitytemplate", SerializationUtils.serializeToBase64(activityTplNumOfRef));
        Map<DynamicObject, Integer> activityPlanNumOfRef = this.updateActivityNumOfRef("reviewplan", dataEntity, this.reviewPlanService::updatePlanActivityNumOfRef);
        operateOption.setVariableValue("update_num_flagreviewplan", SerializationUtils.serializeToBase64(activityPlanNumOfRef));
        long activityId = dataEntity.getLong("id");
        this.updateReviewPersonNumber(activityId);
    }

    public void updateReviewObjMapBeforePos(DynamicObject dataEntity) {
        this.activityUpdate(dataEntity, this::resetReviewObjMapBeforePos);
    }

    private void resetReviewObjMapBeforePos(DynamicObject activityObj) {
        long activityId = activityObj.getLong("id");
        Object[] joinedReviewObj = this.reviewObjectService.listJoinedReviewObjectsByActivityId(activityId);
        ArrayList joinedReviewObjList = Lists.newArrayList((Object[])joinedReviewObj);
        log.info("ReviewActivityApplicationService.resetReviewObjMapBeforePos");
        this.reviewObjectService.resetReviewObjMapBeforePos(joinedReviewObjList, activityObj);
        this.reviewObjectService.save(joinedReviewObjList);
    }

    private void refreshDataByTplChange(DynamicObject activityObj) {
        long activityId = activityObj.getLong("id");
        Object[] joinedReviewObj = this.reviewObjectService.listJoinedReviewObjectsByActivityId(activityId);
        ArrayList joinedReviewObjList = Lists.newArrayList((Object[])joinedReviewObj);
        DynamicObject dbReviewActivity = this.reviewActivityService.getReviewActivity(activityId);
        List curTalentMapEntryId = activityObj.getDynamicObjectCollection("talentmapentry").stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        List<Long> dbTalentMapEntryId = dbReviewActivity.getDynamicObjectCollection("talentmapentry").stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        dbTalentMapEntryId.removeAll(curTalentMapEntryId);
        this.deleteDynamicColumnData(joinedReviewObjList, dbTalentMapEntryId);
        this.removeCalibrateSessionTalentMap(activityId, dbTalentMapEntryId);
    }

    private void deleteDynamicColumnData(List<DynamicObject> joinedReviewObjList, List<Long> dbTalentMapEntryId) {
        if (CollectionUtils.isEmpty(dbTalentMapEntryId)) {
            return;
        }
        List ids = joinedReviewObjList.stream().map(joinedReviewObj -> joinedReviewObj.getLong("id")).collect(Collectors.toList());
        QFilter idQFilter = new QFilter("id", "in", ids);
        DynamicObject[] reviewObjects = REVIEWOBJECT_HELPER.query("entryentity_mapbefore,entryentity_mapbefore.mapbeforekey,entryentity_map,entryentity_map.mapkey", new QFilter[]{idQFilter});
        Arrays.stream(reviewObjects).forEach(reviewObject -> {
            DynamicObjectCollection maps = reviewObject.getDynamicObjectCollection("entryentity_map");
            maps.removeIf(map -> {
                boolean isContain = false;
                String id = map.getString("mapkey");
                for (Long dbTalentMapEntry : dbTalentMapEntryId) {
                    if (!HRStringUtils.equals((String)id, (String)String.valueOf(dbTalentMapEntry))) continue;
                    isContain = true;
                    break;
                }
                return isContain;
            });
            DynamicObjectCollection beforeMaps = reviewObject.getDynamicObjectCollection("entryentity_mapbefore");
            beforeMaps.removeIf(beforeMap -> {
                boolean isContain = false;
                String id = beforeMap.getString("mapbeforekey");
                for (Long dbTalentMapEntry : dbTalentMapEntryId) {
                    if (!HRStringUtils.equals((String)id, (String)String.valueOf(dbTalentMapEntry))) continue;
                    isContain = true;
                    break;
                }
                return isContain;
            });
        });
        REVIEWOBJECT_HELPER.save(reviewObjects);
    }

    private void removeCalibrateSessionTalentMap(long activityId, List<Long> dbTalentMapEntryId) {
        if (CollectionUtils.isNotEmpty(dbTalentMapEntryId)) {
            DynamicObject[] calibrateSessions = this.calibrateSessionService.listCalibrateSessionByActivityId(activityId, dbTalentMapEntryId);
            Arrays.stream(calibrateSessions).forEach(obj -> obj.set("talentmap", null));
            this.calibrateSessionService.save(calibrateSessions);
        }
    }

    public void refreshReviewObjectByActivityConfig(long activityId) {
        try (TXHandle txHandle = TX.required((String)"generatorReviewObject");){
            try {
                DynamicObject reviewActivity = this.reviewActivityService.getReviewActivity(activityId);
                this.reviewObjectGenerate(reviewActivity);
            }
            catch (Exception exception) {
                txHandle.markRollback();
                log.error("ReviewActivityApplicationService.refreshReviewObjectByActivityConfig error: ", (Throwable)exception);
                throw exception;
            }
        }
    }

    public void reviewObjectGenerate(DynamicObject dataEntity, String taskId) {
        String filterJson = dataEntity.getString("perscopefilter_tag");
        QFilter personScopeQFilter = this.getPersonScopeQFilter(filterJson);
        long activityId = dataEntity.getLong("id");
        if (personScopeQFilter == null) {
            this.reviewObjectService.deleteNotJoinedObj(activityId);
            return;
        }
        List<Long> adminorgIds = this.getActivityAdminorgIds(dataEntity);
        DynamicObject[] talentFilesObjs = this.listActivityTalentFilesByPersonScope(filterJson, adminorgIds, taskId);
        List<Long> talentFilesIds = Arrays.stream(talentFilesObjs != null ? talentFilesObjs : new DynamicObject[]{}).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        log.info("reviewObjectGenerate scopeConfig talentFilesIds: {}, activityId: {}", talentFilesIds, (Object)activityId);
        if (CollectionUtils.isEmpty(talentFilesIds)) {
            this.reviewObjectService.deleteNotJoinedObj(activityId);
            return;
        }
        if (!dataEntity.getDataEntityState().getFromDatabase()) {
            List<DynamicObject> reviewObjects = this.generatorNotJoinedReviewObject(talentFilesObjs, activityId);
            if (CollectionUtils.isNotEmpty(reviewObjects)) {
                Object[] reviewObjectIds = reviewObjects.stream().map(obj -> obj.getLong("id")).toArray();
                log.info("reviewObjectGenerate edit Delete reviewObjectIds: {}, activityId: {}", (Object)reviewObjectIds, (Object)activityId);
                this.reviewObjectService.save(reviewObjects);
            }
        } else {
            DynamicObject[] activityCurObjects = this.reviewObjectService.getReviewObjectByActivityId(activityId);
            Map<Boolean, List<DynamicObject>> groupReviewObject = Arrays.stream(activityCurObjects).collect(Collectors.partitioningBy(obj -> obj.getLong("reviewgroup.id") != 0L));
            List<DynamicObject> joinedReviewObjs = groupReviewObject.get(Boolean.TRUE);
            List<DynamicObject> notJoinedReviewObjs = groupReviewObject.get(Boolean.FALSE);
            this.joinedReviewObjMarkErrorInfo(activityId, talentFilesIds, joinedReviewObjs);
            this.unJoinedReviewObjDelete(activityId, talentFilesIds, notJoinedReviewObjs);
            this.generatorNewReviewObjByPersonScope(activityId, talentFilesObjs, activityCurObjects);
        }
    }

    public void reviewObjectGenerate(DynamicObject dataEntity) {
        this.reviewObjectGenerate(dataEntity, "");
    }

    private void generatorNewReviewObjByPersonScope(long activityId, DynamicObject[] talentFilesObjs, DynamicObject[] activityCurObjects) {
        List<DynamicObject> reviewObjectNew;
        List activityCruTalentFileIds = Arrays.stream(activityCurObjects).map(obj -> obj.getLong("talentfile.id")).collect(Collectors.toList());
        Object[] noGeneratorReviewObjsTalentFile = (DynamicObject[])Arrays.stream(talentFilesObjs).filter(obj -> !activityCruTalentFileIds.contains(obj.getLong("id"))).toArray(DynamicObject[]::new);
        if (ArrayUtils.isNotEmpty((Object[])noGeneratorReviewObjsTalentFile) && CollectionUtils.isNotEmpty(reviewObjectNew = this.generatorNotJoinedReviewObject((DynamicObject[])noGeneratorReviewObjsTalentFile, activityId))) {
            Object[] talentIds = reviewObjectNew.stream().map(obj -> obj.getLong("id")).toArray();
            log.info("reviewObjectGenerate edit New reviewObjectIds: {}, activityId: {}", (Object)talentIds, (Object)activityId);
            this.reviewObjectService.save(reviewObjectNew);
        }
    }

    private void unJoinedReviewObjDelete(long activityId, List<Long> talentFilesIds, List<DynamicObject> notJoinedReviewObjs) {
        List<DynamicObject> deleteObjs;
        if (CollectionUtils.isNotEmpty(notJoinedReviewObjs) && CollectionUtils.isNotEmpty(deleteObjs = notJoinedReviewObjs.stream().filter(obj -> !talentFilesIds.contains(obj.getLong("talentfile.id"))).collect(Collectors.toList()))) {
            Object[] talentIds = deleteObjs.stream().map(obj -> obj.getLong("id")).toArray();
            log.info("reviewObjectGenerate edit Del reviewObjectIds: {}, activityId: {}", (Object)talentIds, (Object)activityId);
            this.reviewObjectService.delete(deleteObjs);
        }
    }

    private void joinedReviewObjMarkErrorInfo(long activityId, List<Long> talentFilesIds, List<DynamicObject> joinedReviewObjs) {
        if (CollectionUtils.isNotEmpty(joinedReviewObjs)) {
            List markErrorMsgObjs = joinedReviewObjs.stream().filter(obj -> !talentFilesIds.contains(obj.getLong("talentfile.id"))).collect(Collectors.toList());
            ArrayList updateErrMsgObjs = Lists.newArrayList();
            for (DynamicObject markErrorMsgObj : markErrorMsgObjs) {
                DynamicObjectCollection errorMsgEntry = markErrorMsgObj.getDynamicObjectCollection("errormsgentry");
                boolean hasErrorInfo = errorMsgEntry.stream().anyMatch(obj -> "objNotPersonScope".equals(obj.getString("errormsgtype")));
                if (hasErrorInfo) continue;
                DynamicObject msgEntry = new DynamicObject(errorMsgEntry.getDynamicObjectType());
                msgEntry.set("errormsgtype", (Object)"objNotPersonScope");
                msgEntry.set("errormsgcontent", (Object)ResManager.getLocaleString((String)"\u4e0d\u518d\u7b26\u5408\u76d8\u70b9\u4eba\u5458\u9002\u7528\u8303\u56f4", (String)"ReviewActivityApplicationService_0", (String)"tdc-oatr-business"));
                errorMsgEntry.add((Object)msgEntry);
                updateErrMsgObjs.add(markErrorMsgObj);
            }
            if (CollectionUtils.isNotEmpty((Collection)updateErrMsgObjs)) {
                Object[] talentIds = updateErrMsgObjs.stream().map(obj -> obj.getLong("id")).toArray();
                log.info("reviewObjectGenerate edit Delete reviewObjectIds: {}, activityId: {}", (Object)talentIds, (Object)activityId);
                this.reviewObjectService.save(updateErrMsgObjs);
            }
        }
    }

    public void initReviewGroup(DynamicObject dataEntity) {
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        if (!dataEntityState.getFromDatabase()) {
            this.reviewGroupService.initOneGroup(dataEntity.getPkValue());
        }
    }

    public void activityTemplateChangeRun(DynamicObject activity, DynamicObject reviewTool, BiConsumer<DynamicObject, DynamicObject> initMethod, BiConsumer<DynamicObject, DynamicObject> updateMethod) {
        DataEntityState dataEntityState = activity.getDataEntityState();
        boolean fromDatabase = dataEntityState.getFromDatabase();
        if (!fromDatabase) {
            initMethod.accept(activity, reviewTool);
        } else {
            Iterable bizChangedProperties = dataEntityState.getBizChangedProperties();
            boolean activityTemplateChangeFlag = false;
            for (IDataEntityProperty bizChangedProperty : bizChangedProperties) {
                String name = bizChangedProperty.getName();
                if (!"activitytemplate_id".equals(name) && !"contentchangetime".equals(name)) continue;
                activityTemplateChangeFlag = true;
            }
            if (activityTemplateChangeFlag) {
                updateMethod.accept(activity, reviewTool);
            }
        }
    }

    public void activityUpdate(DynamicObject activity, Consumer<DynamicObject> updateMethod) {
        DataEntityState dataEntityState = activity.getDataEntityState();
        boolean fromDatabase = dataEntityState.getFromDatabase();
        if (fromDatabase) {
            updateMethod.accept(activity);
        }
    }

    private Map<DynamicObject, Integer> updateActivityNumOfRef(String changePropKey, DynamicObject dataEntity, Consumer<Map<DynamicObject, Integer>> updateNumMethod) {
        HashMap updateActivityNumOfRef = Maps.newHashMapWithExpectedSize((int)4);
        boolean fromDatabase = dataEntity.getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            DynamicObject pageActivityTemplate = dataEntity.getDynamicObject(changePropKey);
            if (pageActivityTemplate != null) {
                updateActivityNumOfRef.put(pageActivityTemplate, 1);
            }
        } else {
            Object pkValue = dataEntity.getPkValue();
            Iterable bizChangedProperties = dataEntity.getDataEntityState().getBizChangedProperties();
            for (IDataEntityProperty bizChangedProperty : bizChangedProperties) {
                DynamicObject pageActivityTemplate;
                String name = bizChangedProperty.getName();
                if (!(changePropKey + "_id").equals(name)) continue;
                DynamicObject reviewActivity = this.reviewActivityService.getReviewActivity(pkValue);
                DynamicObject dbActivityTemplate = reviewActivity.getDynamicObject(changePropKey);
                if (dbActivityTemplate != null) {
                    updateActivityNumOfRef.put(dbActivityTemplate, -1);
                }
                if ((pageActivityTemplate = dataEntity.getDynamicObject(changePropKey)) == null) continue;
                updateActivityNumOfRef.put(pageActivityTemplate, 1);
            }
        }
        updateNumMethod.accept(updateActivityNumOfRef);
        return updateActivityNumOfRef;
    }

    public QFilter getPersonScopeQFilter(String filterJson) {
        return this.getPersonScopeFilterBuilder(filterJson).getQFilter();
    }

    public DynamicObject[] listActivityTalentFilesByPersonScope(String filterJson, List<Long> orgIds) {
        return this.listActivityTalentFilesByPersonScope(filterJson, orgIds, "");
    }

    private DynamicObject[] listActivityTalentFilesByPersonScope(String filterJson, List<Long> orgIds, String taskId) {
        QFilter personScopeQFilter = this.getPersonScopeQFilter(filterJson);
        if (personScopeQFilter == null) {
            return null;
        }
        List<QFilter> personScopeQFilters = this.getPersonScopeQFilters(filterJson);
        ReviewPersonScopeConfigApplicationService serviceReviewPerson = ServiceFactory.getService(ReviewPersonScopeConfigApplicationService.class);
        DynamicObject[] reviewPersons = serviceReviewPerson.getReviewPersons(personScopeQFilters, personScopeQFilter, taskId);
        if (HRCollUtil.isEmpty(orgIds)) {
            return reviewPersons;
        }
        return (DynamicObject[])Arrays.stream(reviewPersons).filter(reviewPerson -> orgIds.contains(reviewPerson.getLong("affiliateadminorg.id"))).toArray(DynamicObject[]::new);
    }

    public List<DynamicObject> generatorNotJoinedReviewObject(DynamicObject[] talentFiles, Long activityId) {
        List<Long> personIds = Arrays.stream(talentFiles).map(obj -> obj.getLong("person.id")).collect(Collectors.toList());
        log.info("generatorNotJoinedReviewObject_personIds: {}", personIds);
        Map<Long, List<Map<String, Object>>> directSuperiorOfPerson = this.personAboutQueryService.getDirectSuperior(personIds);
        Map<Long, Long> userPersonMap = this.personAboutQueryService.getUserPersonMap(personIds);
        List<DynamicObject> emptyReviewObjects = this.reviewObjectService.generatorEmptyObjs(talentFiles.length);
        long[] reviewObjIds = ORM.create().genLongIds("oatr_reviewobject", emptyReviewObjects.size());
        int i = 0;
        for (DynamicObject emptyReviewObject : emptyReviewObjects) {
            DynamicObject talentFile = talentFiles[i];
            emptyReviewObject.set("id", (Object)reviewObjIds[i]);
            emptyReviewObject.set("status", (Object)ObjectStatusEnum.UN_IN.getCode());
            emptyReviewObject.set("enable", (Object)"1");
            emptyReviewObject.set("name", (Object)talentFile.getString("name"));
            emptyReviewObject.set("number", (Object)talentFile.getString("number"));
            emptyReviewObject.set("talentfile", (Object)talentFile.getLong("id"));
            emptyReviewObject.set("reviewstatus", (Object)ObjectStatusEnum.UN_IN.getCode());
            emptyReviewObject.set("reviewactivity", (Object)activityId);
            long personId = talentFile.getLong("person.id");
            emptyReviewObject.set("person", (Object)personId);
            emptyReviewObject.set("user", (Object)userPersonMap.get(personId));
            emptyReviewObject.set("personboid", (Object)personId);
            List<Map<String, Object>> directSuperior = directSuperiorOfPerson.get(personId);
            if (!CollectionUtils.isEmpty(directSuperior)) {
                ReviewActivityApplicationService.setSuperiorEvaluators(emptyReviewObject, directSuperior);
            } else {
                log.info("personId: {}, person directSuperior is null.", (Object)personId);
            }
            emptyReviewObject.set("pospattern", talentFile.get("apositiontype"));
            emptyReviewObject.set("company", talentFile.get("company"));
            emptyReviewObject.set("adminorg", talentFile.get("adminorg"));
            emptyReviewObject.set("position", talentFile.get("position"));
            emptyReviewObject.set("stdposition", talentFile.get("stdposition"));
            emptyReviewObject.set("job", talentFile.get("job"));
            ++i;
        }
        return emptyReviewObjects;
    }

    private static void setSuperiorEvaluators(DynamicObject emptyReviewObject, List<Map<String, Object>> directSuperior) {
        List superiorIds = directSuperior.stream().map(obj -> (Long)obj.get("person.id")).collect(Collectors.toList());
        DynamicObjectCollection superiorCol = emptyReviewObject.getDynamicObjectCollection("supereval");
        superiorCol.clear();
        DynamicObjectType dynamicObjectType = superiorCol.getDynamicObjectType();
        for (Long superiorId : superiorIds) {
            if (superiorId == null || superiorId == 0L) continue;
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
            dynamicObject.set("fbasedataid_id", (Object)superiorId);
            superiorCol.add((Object)dynamicObject);
        }
    }

    private FilterBuilder getPersonScopeFilterBuilder(String filterJson) {
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"oatr_reviewpersonfilter");
        FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
        filterBuilder.buildFilter();
        return filterBuilder;
    }

    private List<QFilter> getPersonScopeQFilters(String filterJson) {
        return this.getPersonScopeFilterBuilder(filterJson).getQFilters();
    }

    public Pair<Boolean, DynamicObject[]> listActivityTalentFilesByPersonScope(long activityId) {
        DynamicObject reviewActivity = this.reviewActivityService.getReviewActivity(activityId);
        String filterJson = reviewActivity.getString("perscopefilter_tag");
        QFilter personScopeQFilter = this.getPersonScopeQFilter(filterJson);
        if (personScopeQFilter == null) {
            return Pair.of((Object)Boolean.FALSE, null);
        }
        DynamicObject[] reviewObjectData = this.reviewObjectQueryService.getReviewObjectData(activityId);
        List<Long> talentFileIds = Arrays.stream(reviewObjectData).map(reviewObj -> reviewObj.getLong("talentfile.id")).collect(Collectors.toList());
        DynamicObject[] talentFileObjs = this.talentFileQueryService.listTalentFile(talentFileIds);
        return Pair.of((Object)Boolean.TRUE, (Object)talentFileObjs);
    }

    public List<Long> listTalentFilesIds(String filterJson, List<Long> orgIds) {
        return Arrays.stream(this.listActivityTalentFilesByPersonScope(filterJson, orgIds)).map(obj -> obj.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> getActivityAdminorgIds(DynamicObject reviewActivity) {
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        if (reviewActivity == null) {
            return orgIds;
        }
        DynamicObjectCollection adminorgEntry = reviewActivity.getDynamicObjectCollection("adminorgentry");
        ArrayList<Long> includeSubOrgIds = new ArrayList<Long>(10);
        for (DynamicObject orgEntry : adminorgEntry) {
            long adminorgId = orgEntry.getLong("adminorgvid.id");
            boolean includeSub = orgEntry.getBoolean("includesub");
            if (adminorgId != 0L && adminorgId == rootOrgId && includeSub) {
                return new ArrayList<Long>(0);
            }
            orgIds.add(adminorgId);
            if (!includeSub) continue;
            includeSubOrgIds.add(adminorgId);
        }
        List<Map<String, Object>> allSubOrg = adminorgExternalService.batchGetAllSubOrg(includeSubOrgIds, new Date());
        List subOrgIds = allSubOrg.stream().map(orgInfoMap -> Long.valueOf(orgInfoMap.get("orgId").toString())).collect(Collectors.toList());
        orgIds.addAll(subOrgIds);
        return orgIds;
    }

    public boolean activityConfigPersonScope(String filterJson) {
        QFilter personScopeQFilter = this.getPersonScopeQFilter(filterJson);
        return personScopeQFilter != null;
    }

    public DynamicObject getReviewActivityTemplate(Object activityTplId) {
        return this.reviewActivityTplService.getReviewActivityTemplate(activityTplId);
    }

    public boolean isExistsReviewGroup(Object pkValue) {
        return this.reviewGroupService.isExists(pkValue);
    }

    public void generatorReviewObject(Pair<List<Long>, List<Long>> diffAndIntersection, Long activityId, Long reviewGroupId) {
        try (TXHandle txHandle = TX.required((String)"generatorReviewObject");){
            try {
                this.generatorJoinedReviewObjectByNew((List)diffAndIntersection.getLeft(), activityId, reviewGroupId);
                DynamicObject reviewActivity = this.reviewActivityService.getReviewActivity(activityId);
                String activityStatus = reviewActivity.getString("activitystatus");
                this.generatorJoinedReviewObjectByNotJoined((List)diffAndIntersection.getRight(), activityId, reviewGroupId, activityStatus);
            }
            catch (Exception exception) {
                txHandle.markRollback();
                log.error("ReviewActivityApplicationService.generatorReviewObject error: ", (Throwable)exception);
                throw exception;
            }
        }
    }

    public void generatorJoinedReviewObjectByNew(List<Long> talentListIds, Long activityId, Long groupId) {
        if (CollectionUtils.isEmpty(talentListIds)) {
            return;
        }
        DynamicObject[] talentFiles = this.talentFileQueryService.listTalentFile(talentListIds);
        List<DynamicObject> notJoinedReviewObjects = this.generatorNotJoinedReviewObject(talentFiles, activityId);
        DynamicObject reviewActivity = this.reviewActivityService.getReviewActivity(activityId);
        String activityStatus = reviewActivity.getString("activitystatus");
        this.reviewObjectChangeJoined(notJoinedReviewObjects, groupId, activityStatus, activityId);
    }

    public void generatorJoinedReviewObjectByNotJoined(List<Long> notJoinedTalendFileIds, Long activityId, Long groupId, String activityStatus) {
        if (CollectionUtils.isEmpty(notJoinedTalendFileIds)) {
            return;
        }
        DynamicObject[] notJoinedReviewObjects = this.reviewObjectService.listReviewObjectsByTalentFileIds(notJoinedTalendFileIds, activityId);
        List<DynamicObject> notJoinedReviewObjectList = Arrays.stream(notJoinedReviewObjects).collect(Collectors.toList());
        this.reviewObjectChangeJoined(notJoinedReviewObjectList, groupId, activityStatus, activityId);
    }

    public void reviewObjectChangeJoined(List<DynamicObject> notJoinedReviewObjects, Long groupId, String activityStatus, Long activityId) {
        for (DynamicObject emptyReviewObject : notJoinedReviewObjects) {
            emptyReviewObject.set("reviewgroup", (Object)groupId);
            if (ActivityStatusEnum.WAIT_START.getCode().equals(activityStatus)) {
                emptyReviewObject.set("reviewstatus", (Object)ObjectStatusEnum.WAIT_START.getCode());
                continue;
            }
            emptyReviewObject.set("reviewstatus", (Object)ObjectStatusEnum.GOING_UNCHECK.getCode());
        }
        this.reviewObjectService.save(notJoinedReviewObjects);
        if (HRCollUtil.isNotEmpty(notJoinedReviewObjects) && notJoinedReviewObjects.get(0) != null) {
            this.updateReviewPersonNumber(activityId);
        }
    }

    public void inviteEmpFillQuestion(DynamicObject[] dataEntities, long activityId, OperateOption option) {
        ReviewEmpEvalQueryService evalQueryService = ServiceFactory.getService(ReviewEmpEvalQueryService.class);
        DynamicObject[] evalObjs = evalQueryService.generatorEvalObjs(dataEntities.length);
        long[] ids = ORM.create().genLongIds("oatr_employeeeval", evalObjs.length);
        int i = 0;
        for (DynamicObject evalObj : evalObjs) {
            evalObj.set("id", (Object)ids[i]);
            evalObj.set("billstatus", (Object)"A");
            evalObj.set("evalstatus", (Object)"A");
            evalObj.set("reviewactivity", (Object)activityId);
            evalObj.set("reviewobject", dataEntities[i].get("id"));
            evalObj.set("evaluator", dataEntities[i].get("user"));
            evalObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            evalObj.set("question", (Object)1010L);
            ++i;
        }
        SaveServiceHelper.saveOperate((String)"oatr_employeeeval", (DynamicObject[])evalObjs, (OperateOption)OperateOption.create());
        option.setVariableValue("evalObjIds", JsonUtils.toString((Object)ids));
    }

    public void inviteSuperiorFillQuestion(DynamicObject[] dataEntities, Map<Long, Set<Long>> selectSuperiorMap, long activityId, OperateOption option) {
        Map reviewObjMap = Arrays.stream(dataEntities).collect(Collectors.toMap(obj -> obj.getLong("id"), Function.identity()));
        long count = selectSuperiorMap.values().stream().mapToLong(Set::size).sum();
        ReviewSuperiorEvalQueryService superiorService = ServiceFactory.getService(ReviewSuperiorEvalQueryService.class);
        DynamicObject[] evalObjs = superiorService.generatorEvalObjs((int)count);
        long[] ids = ORM.create().genLongIds("oatr_employeeeval", evalObjs.length);
        int j = 0;
        for (Map.Entry<Long, Set<Long>> superiorMap : selectSuperiorMap.entrySet()) {
            Long reviewObjId = superiorMap.getKey();
            if (!reviewObjMap.containsKey(reviewObjId)) continue;
            for (Long superiorId : superiorMap.getValue()) {
                DynamicObject evalObj = evalObjs[j];
                evalObj.set("id", (Object)ids[j]);
                evalObj.set("billstatus", (Object)"A");
                evalObj.set("evalstatus", (Object)"A");
                evalObj.set("reviewactivity", (Object)activityId);
                evalObj.set("reviewobject", (Object)reviewObjId);
                evalObj.set("evaluator", (Object)superiorId);
                evalObj.set("creator", (Object)RequestContext.get().getCurrUserId());
                evalObj.set("question", (Object)1020L);
                ++j;
            }
        }
        SaveServiceHelper.saveOperate((String)"oatr_superioreval", (DynamicObject[])evalObjs, (OperateOption)OperateOption.create());
        option.setVariableValue("evalObjIds", JsonUtils.toString((Object)ids));
    }

    public void generateBusinessData(long userId, long activityId) {
        ServiceFactory.getService(ReviewBusinessDataListService.class).generateData(userId, activityId);
    }

    public void recordCollaborationBusinessData(long activityId) {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject[] collaborations = ServiceFactory.getService(ReviewGroupService.class).getReviewGroupByActivityId(activityId);
        boolean isCollaborationCurUser = Arrays.stream(collaborations).anyMatch(obj -> obj.getLong("entryentity.collaborator") == currUserId);
        if (isCollaborationCurUser) {
            this.generateBusinessData(currUserId, activityId);
        }
    }

    public Map<Long, Map<Long, List<Long>>> getColReviewObjectList(DynamicObject[] reviewObjs, DynamicObject[] reviewGroups, Map<Long, List<Long>> groupReviewObjMap) {
        Set<Long> collaboratorIds = Arrays.stream(reviewGroups).map(obj -> obj.getLong("entryentity.collaborator")).filter(id -> id != 0L).collect(Collectors.toSet());
        Map groupCollaboratorMap = Arrays.stream(reviewGroups).collect(Collectors.groupingBy(obj -> obj.getLong("id"), Collectors.mapping(obj -> obj.getLong("entryentity.collaborator"), Collectors.toList())));
        List<Long> reviewObjIds = Arrays.stream(reviewObjs).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        Map<Long, Map<Long, Boolean>> collaboratorPermissionDataMap = permissionService.listUserPermissionData(collaboratorIds, reviewObjIds);
        HashMap colReviewObjectList = Maps.newHashMap();
        groupCollaboratorMap.forEach((groupId, collaboratorIdList) -> collaboratorIdList.forEach(collaboratorId -> {
            Map groupCollaborator = (Map)colReviewObjectList.get(groupId);
            if (MapUtils.isEmpty((Map)groupCollaborator)) {
                groupCollaborator = Maps.newHashMapWithExpectedSize((int)16);
                colReviewObjectList.put(groupId, groupCollaborator);
            }
            List groupReviewObjIds = (List)groupReviewObjMap.get(groupId);
            Map collaboratorDataPermission = (Map)collaboratorPermissionDataMap.get(collaboratorId);
            if (CollectionUtils.isNotEmpty((Collection)groupReviewObjIds)) {
                for (Long reviewObjId : groupReviewObjIds) {
                    Boolean hasPerm;
                    if (!MapUtils.isNotEmpty((Map)collaboratorDataPermission) || (hasPerm = (Boolean)collaboratorDataPermission.get(reviewObjId)) == null || !hasPerm.booleanValue()) continue;
                    List hasPermCollaboratorIds = (List)groupCollaborator.get(collaboratorId);
                    if (CollectionUtils.isEmpty((Collection)hasPermCollaboratorIds)) {
                        hasPermCollaboratorIds = Lists.newArrayList();
                        groupCollaborator.put(collaboratorId, hasPermCollaboratorIds);
                    }
                    hasPermCollaboratorIds.add(reviewObjId);
                }
            }
        }));
        return colReviewObjectList;
    }

    public Map<Long, List<Long>> getGroupReviewObjMap(long activityId) {
        DynamicObject[] reviewObjs = this.reviewObjectService.listJoinedReviewObjects(activityId);
        return Arrays.stream(reviewObjs).collect(Collectors.groupingBy(obj -> obj.getLong("reviewgroup.id"), Collectors.mapping(obj -> obj.getLong("id"), Collectors.toList())));
    }

    public Map<Long, List<Long>> getGroupReviewObjMap(DynamicObject[] reviewObjs) {
        return Arrays.stream(reviewObjs).collect(Collectors.groupingBy(obj -> obj.getLong("reviewgroup.id"), Collectors.mapping(obj -> obj.getLong("id"), Collectors.toList())));
    }

    public List<CollaboratorObject> getCollaboratorObjects(DynamicObject[] reviewObjs, DynamicObject[] reviewGroups) {
        Map<Long, List<Long>> groupReviewObjMap = this.getGroupReviewObjMap(reviewObjs);
        Map<Long, Map<Long, List<Long>>> colReviewObjectListByActivity = this.getColReviewObjectList(reviewObjs, reviewGroups, groupReviewObjMap);
        Map<Long, String> objNumberMap = Arrays.stream(reviewObjs).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getString("number"), (k1, k2) -> k1));
        Map<Long, String> collNumberMap = Arrays.stream(reviewGroups).collect(Collectors.toMap(obj -> obj.getLong("entryentity.collaborator"), obj -> Optional.ofNullable(obj.getString("collaborator.number")).orElse(""), (k1, k2) -> k1));
        ArrayList collaboratorObjects = Lists.newArrayList();
        for (Map<Long, List<Long>> colObjMap : colReviewObjectListByActivity.values()) {
            colObjMap.forEach((colId, objIds) -> {
                for (Long objId : objIds) {
                    collaboratorObjects.add(new CollaboratorObject(colId, (String)collNumberMap.get(colId), objId, (String)objNumberMap.get(objId)));
                }
            });
        }
        return collaboratorObjects;
    }

    public void updateCalibrateResult(List<Long> reviewObjIds, Map<Long, String> calibrateResultData, String mapIdKey, long sessionId) {
        this.reviewObjectService.updateCalibrateResult(reviewObjIds, calibrateResultData, mapIdKey, sessionId);
    }

    public void deleteNotJoinedObj(long activityId) {
        this.reviewObjectService.deleteNotJoinedObj(activityId);
    }

    public void syncReviewResult(List<Long> activityIds) {
        int BATCH_MAXIMUM = 20;
        ThreadPools.executeOnce((String)"ReviewActivityApplicationService.syncReviewResult", () -> {
            int size = activityIds.size();
            int batchNum = size / BATCH_MAXIMUM + 1;
            for (int i = 0; i < batchNum; ++i) {
                int batchSize = Math.min(i * BATCH_MAXIMUM + BATCH_MAXIMUM, size);
                List<Long> subActivityIds = activityIds.subList(i * BATCH_MAXIMUM, batchSize);
                if (!HRCollUtil.isNotEmpty(subActivityIds)) continue;
                DynamicObjectCollection reviewActivityData = this.activityQueryService.listReviewActivity(subActivityIds);
                DynamicObject[] reviewObjectData = this.reviewObjectQueryService.listReviewObjectData(subActivityIds);
                List<Long> sessionIds = Arrays.stream(reviewObjectData).flatMap(reviewObject -> reviewObject.getDynamicObjectCollection("entryentity_map").stream()).map(entry -> entry.getLong("calibratesession.id")).distinct().collect(Collectors.toList());
                DynamicObject[] calibrateSession = this.calSessionQueryService.listCalibrateSession(sessionIds);
                List<Map<String, Object>> talentReviewData = this.buildTalentReviewResultData(reviewActivityData, reviewObjectData, calibrateSession);
                this.syncToTDCSReviewResult(talentReviewData);
            }
        });
    }

    private void syncToTDCSReviewResult(List<Map<String, Object>> talentReviewData) {
        HRMServiceHelper.invokeBizService((String)"tdc", (String)"tdcs", (String)"IReviewResultService", (String)"syncReviewResult", (Object[])new Object[]{talentReviewData});
    }

    private List<Map<String, Object>> buildTalentReviewResultData(DynamicObjectCollection reviewActivityData, DynamicObject[] reviewObjectData, DynamicObject[] calibrateSessionData) {
        ArrayList talentReviewData = Lists.newArrayListWithExpectedSize((int)reviewObjectData.length);
        Map<Long, DynamicObject> reviewActivityDataMap = reviewActivityData.stream().collect(Collectors.toMap(reviewActivity -> reviewActivity.getLong("id"), reviewActivity -> reviewActivity, (v1, v2) -> v1));
        Map<Long, DynamicObject> calibrateSessionDataMap = Arrays.stream(calibrateSessionData).collect(Collectors.toMap(calibrateSession -> calibrateSession.getLong("id"), calibrateSession -> calibrateSession, (v1, v2) -> v1));
        for (DynamicObject reviewObject : reviewObjectData) {
            String reviewStatus = reviewObject.getString("reviewstatus");
            if (!HRStringUtils.equals((String)reviewStatus, (String)ObjectStatusEnum.END.getCode())) continue;
            Long activityId = reviewObject.getLong("reviewactivity.id");
            DynamicObject reviewActivity2 = reviewActivityDataMap.get(activityId);
            DynamicObjectCollection talentMapEntry = reviewActivity2.getDynamicObjectCollection("talentmapentry");
            DynamicObjectCollection mapEntryEntity = reviewObject.getDynamicObjectCollection("entryentity_map");
            DynamicObjectCollection mapBeforeEntryEntity = reviewObject.getDynamicObjectCollection("entryentity_mapbefore");
            if (CollectionUtils.isEmpty((Collection)mapEntryEntity) && CollectionUtils.isEmpty((Collection)mapBeforeEntryEntity)) continue;
            Map<String, DynamicObject> mapKeyEntryMap = mapEntryEntity.stream().filter(entry -> HRStringUtils.isNotEmpty((String)entry.getString("mapvalue"))).collect(Collectors.toMap(entry -> entry.getString("mapkey"), entry -> entry, (v1, v2) -> v1));
            Map<String, DynamicObject> mapBeforeKeyEntryMap = mapBeforeEntryEntity.stream().filter(entry -> HRStringUtils.isNotEmpty((String)entry.getString("mapbeforevalue"))).collect(Collectors.toMap(entry -> entry.getString("mapbeforekey"), entry -> entry, (v1, v2) -> v1));
            for (DynamicObject talentEntry : talentMapEntry) {
                String mapKey = talentEntry.getPkValue().toString();
                DynamicObject mapEntryData = mapKeyEntryMap.get(mapKey);
                if (mapEntryData != null) {
                    Map<String, Object> reviewResultMap = this.buildReviewResultMapByMapEntry(reviewObject, reviewActivityDataMap, calibrateSessionDataMap, mapEntryData);
                    talentReviewData.add(reviewResultMap);
                    continue;
                }
                DynamicObject mapBeforeEntryData = mapBeforeKeyEntryMap.get(mapKey);
                if (mapBeforeEntryData == null) continue;
                Map<String, Object> reviewResultMap = this.buildReviewResultByMapBeforeEntry(reviewObject, reviewActivityDataMap, talentEntry, mapBeforeEntryData);
                talentReviewData.add(reviewResultMap);
            }
        }
        return talentReviewData;
    }

    private Map<String, Object> buildReviewResultMapByMapEntry(DynamicObject reviewObject, Map<Long, DynamicObject> reviewActivityDataMap, Map<Long, DynamicObject> calibrateSessionDataMap, DynamicObject mapEntryData) {
        HashMap reviewResultMap = Maps.newHashMapWithExpectedSize((int)16);
        Long personId = reviewObject.getLong("person.id");
        Long employeeId = reviewObject.getLong("talentfile.employee.id");
        Long talentFileId = reviewObject.getLong("talentfile.id");
        Long activityId = reviewObject.getLong("reviewactivity.id");
        DynamicObject reviewActivity = reviewActivityDataMap.get(activityId);
        Date actFinishDate = reviewActivity.getDate("finishtime");
        String activityNumber = reviewActivity.getString("number");
        ILocaleString activityName = reviewActivity.getLocaleString("name");
        ILocaleString reviewTypeName = reviewActivity.getLocaleString("reviewtype.name");
        long sessionId = mapEntryData.getLong("calibratesession.id");
        DynamicObject calibrateSession = calibrateSessionDataMap.get(sessionId);
        ILocaleString xDimName = calibrateSession.getLocaleString("xaxisdim.name");
        ILocaleString yDimName = calibrateSession.getLocaleString("yaxisdim.name");
        String talentMapConfig = calibrateSession.getString("talentmapconfig_tag");
        String mapKey = mapEntryData.getString("mapkey");
        String mapValue = mapEntryData.getString("mapvalue");
        if (mapValue.contains("-") && !mapValue.startsWith("-") && !mapValue.endsWith("-")) {
            String positionNumber = mapValue.substring(0, mapValue.indexOf("-"));
            String reviewPosition = mapValue.substring(mapValue.indexOf("-") + 1);
            reviewResultMap.put("positionnumber", positionNumber);
            reviewResultMap.put("reviewposition", reviewPosition);
        } else {
            reviewResultMap.put("reviewposition", mapValue);
        }
        reviewResultMap.put("person", personId);
        reviewResultMap.put("employee", employeeId);
        reviewResultMap.put("talentfile", talentFileId);
        reviewResultMap.put("activityid", activityId);
        reviewResultMap.put("sessionid", sessionId);
        reviewResultMap.put("activitynumber", activityNumber);
        reviewResultMap.put("activityname", activityName);
        reviewResultMap.put("reviewtypename", reviewTypeName);
        reviewResultMap.put("actfinishdate", actFinishDate);
        reviewResultMap.put("xdimname", xDimName);
        reviewResultMap.put("ydimname", yDimName);
        reviewResultMap.put("gridmap_tag", talentMapConfig);
        reviewResultMap.put("mapkey", mapKey);
        return reviewResultMap;
    }

    private Map<String, Object> buildReviewResultByMapBeforeEntry(DynamicObject reviewObject, Map<Long, DynamicObject> reviewActivityDataMap, DynamicObject talentEntry, DynamicObject mapBeforeEntryData) {
        HashMap reviewResultMap = Maps.newHashMapWithExpectedSize((int)16);
        Long personId = reviewObject.getLong("person.id");
        Long employeeId = reviewObject.getLong("talentfile.employee.id");
        Long talentFileId = reviewObject.getLong("talentfile.id");
        Long activityId = reviewObject.getLong("reviewactivity.id");
        DynamicObject reviewActivity = reviewActivityDataMap.get(activityId);
        Date actFinishDate = reviewActivity.getDate("finishtime");
        String activityNumber = reviewActivity.getString("number");
        ILocaleString activityName = reviewActivity.getLocaleString("name");
        ILocaleString reviewTypeName = reviewActivity.getLocaleString("reviewtype.name");
        ILocaleString xDimName = talentEntry.getLocaleString("xaxisdim.name");
        ILocaleString yDimName = talentEntry.getLocaleString("yaxisdim.name");
        String talentMapConfig = talentEntry.getString("talentmapconfig_tag");
        String mapKey = mapBeforeEntryData.getString("mapbeforekey");
        String mapValue = mapBeforeEntryData.getString("mapbeforevalue");
        if (mapValue.contains("-") && !mapValue.startsWith("-") && !mapValue.endsWith("-")) {
            String positionNumber = mapValue.substring(0, mapValue.indexOf("-"));
            String reviewPosition = mapValue.substring(mapValue.indexOf("-") + 1);
            reviewResultMap.put("positionnumber", positionNumber);
            reviewResultMap.put("reviewposition", reviewPosition);
        } else {
            reviewResultMap.put("reviewposition", mapValue);
        }
        reviewResultMap.put("person", personId);
        reviewResultMap.put("employee", employeeId);
        reviewResultMap.put("talentfile", talentFileId);
        reviewResultMap.put("activityid", activityId);
        reviewResultMap.put("activitynumber", activityNumber);
        reviewResultMap.put("activityname", activityName);
        reviewResultMap.put("reviewtypename", reviewTypeName);
        reviewResultMap.put("actfinishdate", actFinishDate);
        reviewResultMap.put("xdimname", xDimName);
        reviewResultMap.put("ydimname", yDimName);
        reviewResultMap.put("gridmap_tag", talentMapConfig);
        reviewResultMap.put("mapkey", mapKey);
        return reviewResultMap;
    }

    public void updateReserveTalentNameByPersonId(String name, Long personId) {
        this.reviewObjectService.updateReserveTalentNameByPersonId(name, personId);
    }

    public void updateReserveTalentNumberByPersonId(String number, Long personId) {
        this.reviewObjectService.updateReserveTalentNumberByPersonId(number, personId);
    }

    public Map<String, Object> syncRecommendTalent(Map<String, Object> recommendData) {
        Map<String, Object> dataMap = this.formatDataParams(recommendData);
        Map result = Maps.newHashMapWithExpectedSize((int)5);
        try {
            result = (Map)HRMServiceHelper.invokeBizService((String)"tdc", (String)"talp", (String)"ITALPService", (String)"saveTalentRecommend", (Object[])new Object[]{dataMap});
        }
        catch (Exception exception) {
            log.error("ReviewActivityApplicationService.syncRecommendTalent: saveTalentRecommend param is {}", dataMap, (Object)exception);
        }
        return result;
    }

    private Map<String, Object> formatDataParams(Map<String, Object> recommendData) {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)recommendData.size());
        dataMap.put("org", Long.valueOf(recommendData.get("org").toString()));
        dataMap.put("recommendsource", Long.valueOf(recommendData.get("recommendsource").toString()));
        List dataList = (List)recommendData.get("data");
        ArrayList data = Lists.newArrayListWithExpectedSize((int)dataList.size());
        for (Map listItem : dataList) {
            HashMap dataItem = Maps.newHashMapWithExpectedSize((int)listItem.size());
            dataItem.put("employee", Long.valueOf(listItem.get("employee").toString()));
            dataItem.put("recommendintopool", Long.valueOf(listItem.get("recommendintopool").toString()));
            dataItem.put("recommendemp", Long.valueOf(listItem.get("recommendemp").toString()));
            dataItem.put("recommendreason", listItem.get("recommendreason"));
            data.add(dataItem);
        }
        dataMap.put("data", data);
        return dataMap;
    }

    public void updateReviewPersonNumber(long activityId) {
        int personNumber = this.reviewObjectService.countJoinedReviewObjects(activityId);
        this.reviewActivityService.updateReviewActivityPersonNum(activityId, personNumber);
    }

    public void updateReviewObjReviewResult(List<Long> activityIds) {
        int BATCH_MAXIMUM = 1000;
        int size = activityIds.size();
        int batchNum = size / BATCH_MAXIMUM + 1;
        for (int i = 0; i < batchNum; ++i) {
            int toIndex = Math.min(size, i * BATCH_MAXIMUM + BATCH_MAXIMUM);
            List<Long> subActivityIds = activityIds.subList(i * BATCH_MAXIMUM, toIndex);
            DynamicObjectCollection reviewActivityData = this.activityQueryService.listReviewActivity(subActivityIds);
            DynamicObject[] reviewObjectData = this.reviewObjectQueryService.listReviewObjectData(subActivityIds);
            Map<Long, DynamicObject> reviewActivityDataMap = reviewActivityData.stream().collect(Collectors.toMap(reviewActivity -> reviewActivity.getLong("id"), reviewActivity -> reviewActivity, (v1, v2) -> v1));
            ArrayList<DynamicObject> updateObjData = new ArrayList<DynamicObject>(reviewObjectData.length);
            for (DynamicObject reviewObject : reviewObjectData) {
                String reviewStatus = reviewObject.getString("reviewstatus");
                if (!HRStringUtils.equals((String)reviewStatus, (String)ObjectStatusEnum.END.getCode())) continue;
                Long activityId = reviewObject.getLong("reviewactivity.id");
                DynamicObject reviewActivity2 = reviewActivityDataMap.get(activityId);
                DynamicObjectCollection talentMapEntry = reviewActivity2.getDynamicObjectCollection("talentmapentry");
                DynamicObjectCollection mapEntryEntity = reviewObject.getDynamicObjectCollection("entryentity_map");
                DynamicObjectCollection mapBeforeEntryEntity = reviewObject.getDynamicObjectCollection("entryentity_mapbefore");
                if (CollectionUtils.isEmpty((Collection)mapEntryEntity) && CollectionUtils.isEmpty((Collection)mapBeforeEntryEntity)) continue;
                Map<String, DynamicObject> mapKeyEntryMap = mapEntryEntity.stream().filter(entry -> HRStringUtils.isNotEmpty((String)entry.getString("mapvalue"))).collect(Collectors.toMap(entry -> entry.getString("mapkey"), entry -> entry, (v1, v2) -> v1));
                Map<String, DynamicObject> mapBeforeKeyEntryMap = mapBeforeEntryEntity.stream().filter(entry -> HRStringUtils.isNotEmpty((String)entry.getString("mapbeforevalue"))).collect(Collectors.toMap(entry -> entry.getString("mapbeforekey"), entry -> entry, (v1, v2) -> v1));
                DynamicObjectCollection mapResultEntry = reviewObject.getDynamicObjectCollection("entryentity_mapres");
                for (DynamicObject talentEntry : talentMapEntry) {
                    DynamicObject resultObj = mapResultEntry.addNew();
                    String mapKey = talentEntry.getPkValue().toString();
                    resultObj.set("mapkeyres", (Object)mapKey);
                    DynamicObject mapEntryData = mapKeyEntryMap.get(mapKey);
                    if (mapEntryData != null) {
                        resultObj.set("mapvalueres", mapEntryData.get("mapvalue"));
                        resultObj.set("calibratesessionres", mapEntryData.get("calibratesession"));
                        continue;
                    }
                    DynamicObject mapBeforeEntryData = mapBeforeKeyEntryMap.get(mapKey);
                    if (mapBeforeEntryData == null) continue;
                    resultObj.set("mapvalueres", mapBeforeEntryData.get("mapbeforevalue"));
                }
                updateObjData.add(reviewObject);
            }
            this.reviewObjectService.save(updateObjData);
        }
    }

    public void sendMsgNotifyCollaborator(DynamicObject[] reviewGroupObjs) {
        if (HRArrayUtils.isEmpty((Object[])reviewGroupObjs)) {
            return;
        }
        List<Long> reviewGroupIds = Arrays.stream(reviewGroupObjs).map(reviewGroupObj -> reviewGroupObj.getLong("id")).collect(Collectors.toList());
        Map<Long, Map<Long, String>> collaborateMap = Arrays.stream(reviewGroupObjs).collect(Collectors.toMap(reviewGroupObj -> reviewGroupObj.getLong("id"), reviewGroupObj -> reviewGroupObj.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(entry -> entry.getLong("collaborator.id"), entry -> entry.getString("colstatus"), (v1, v2) -> v1)), (v1, v2) -> v1));
        this.reviewCollaboratorService.sendMsgNotifyCollaborator(collaborateMap, reviewGroupIds);
    }

    public void sendMsgNotifyCollaborator(DynamicObject[] newReviewGroupObjs, DynamicObject[] oldReviewGroupObjs) {
        if (HRArrayUtils.isEmpty((Object[])newReviewGroupObjs) || HRArrayUtils.isEmpty((Object[])oldReviewGroupObjs)) {
            return;
        }
        this.reviewCollaboratorService.sendMsgNotifyCollaborator(newReviewGroupObjs, oldReviewGroupObjs);
    }

    public void sendMsgNotifyCollaborator(Map<Long, Map<Long, String>> groupCollaStatusMap, List<Long> reviewGroupIds) {
        this.reviewCollaboratorService.sendMsgNotifyCollaborator(groupCollaStatusMap, reviewGroupIds);
    }
}

