/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.application;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.domain.activity.ReviewTalentMapService;
import kd.tdc.oatr.bussiness.queryservice.ReviewTalentMapQueryService;

public class ReviewTalentMapConfigApplicationService {
    private static final Log LOG = LogFactory.getLog(ReviewTalentMapConfigApplicationService.class);
    private final ReviewTalentMapQueryService talentMapQueryService = ServiceFactory.getService(ReviewTalentMapQueryService.class);
    private final ReviewTalentMapService reviewTalentMapService = ServiceFactory.getService(ReviewTalentMapService.class);

    public Map<String, Map<Long, String>> getTalentMapGridPosition(Map<String, Map<Long, Object>> personDimensionData, Long activityId) {
        if (personDimensionData.isEmpty() || activityId == null || activityId == 0L) {
            LOG.error("ReviewTalentMapConfigApplicationService.getTalentMapGridPosition: params exists empty value, personDimensionData={},activityId={}", personDimensionData, (Object)activityId);
            return Maps.newHashMap();
        }
        DynamicObject activity = this.talentMapQueryService.getReviewTalentMapActivity(activityId);
        Map<String, Map<Long, String>> talentMapGridPositionInfo = this.reviewTalentMapService.getTalentMapGridPosition(personDimensionData, activity);
        LOG.info("ReviewTalentMapConfigApplicationService.getTalentMapGridPosition: params is personDimensionData={},activityId={}, the result is {}", new Object[]{personDimensionData, activityId, talentMapGridPositionInfo});
        return talentMapGridPositionInfo;
    }

    public Map<String, String> getTalentMapName(Long activityId) {
        if (activityId == null || activityId == 0L) {
            return Maps.newHashMap();
        }
        DynamicObject activity = this.talentMapQueryService.getReviewTalentMapActivity(activityId);
        Map<String, String> talentMapNameInfo = this.reviewTalentMapService.getTalentMapNameInfo(activity);
        LOG.info("ReviewTalentMapConfigApplicationService.getTalentMapName: param activityId={}, the result={}", (Object)activityId, talentMapNameInfo);
        return talentMapNameInfo;
    }

    public Map<String, Map<Long, Map<String, Object>>> validateDimensionData(Map<String, Map<Long, Object>> personDimensionData, Long activityId) {
        if (personDimensionData.isEmpty() || activityId == null || activityId == 0L) {
            return Maps.newHashMap();
        }
        DynamicObject activity = this.talentMapQueryService.getReviewTalentMapActivity(activityId);
        Map<String, Map<Long, Map<String, Object>>> validateDimensionDataResult = this.reviewTalentMapService.validateDimensionData(personDimensionData, activity);
        LOG.info("ReviewTalentMapConfigApplicationService.validateDimensionData: personDimensionData={}, activityId={}, the result={}", new Object[]{personDimensionData, activityId, validateDimensionDataResult});
        return validateDimensionDataResult;
    }
}

