/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.application;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.domain.reviewgroup.ReviewToolDomainService;

public class ReviewToolApplicationService {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("oatr_reviewtool");
    private static final HRBaseServiceHelper INNER_TOOL_HELPER = new HRBaseServiceHelper("oatr_innertoolentity");
    private static final HRBaseServiceHelper OUTER_TOOL_HELPER = new HRBaseServiceHelper("oatr_outertoolentity");
    private final ReviewToolDomainService toolDomainService = ServiceFactory.getService(ReviewToolDomainService.class);

    public void updateReviewInnerTool(Map<Long, Map<Long, Boolean>> groupOfInnerTool) {
        DynamicObject[] innerToolArray = INNER_TOOL_HELPER.loadDynamicObjectArray(groupOfInnerTool.keySet().toArray(new Object[0]));
        if (innerToolArray == null || innerToolArray.length == 0) {
            return;
        }
        for (DynamicObject reviewInnerTool : innerToolArray) {
            DynamicObjectCollection innerGroupFromDataBase = reviewInnerTool.getDynamicObjectCollection("inner_reviewgroup");
            List innerGroupIdsFromDataBase = innerGroupFromDataBase.stream().map(inner -> inner.getLong("fbasedataid.id")).collect(Collectors.toList());
            Map<Long, Boolean> groupIsUseMap = groupOfInnerTool.get(reviewInnerTool.getLong("id"));
            if (CollectionUtils.isEmpty(groupIsUseMap)) continue;
            groupIsUseMap.forEach((groupId, isUse) -> {
                if (isUse.booleanValue() && !innerGroupIdsFromDataBase.contains(groupId)) {
                    DynamicObject outerGroup = innerGroupFromDataBase.addNew();
                    outerGroup.set("fbasedataid", groupId);
                } else if (!isUse.booleanValue()) {
                    innerGroupFromDataBase.removeIf(inner -> inner.getLong("fbasedataid.id") == groupId.longValue());
                }
            });
        }
        this.toolDomainService.updateReviewInnerTool(innerToolArray);
    }

    public void updateReviewOuterTool(Map<Long, Map<Long, Boolean>> groupOfOuterTool) {
        DynamicObject[] outerToolArray = OUTER_TOOL_HELPER.loadDynamicObjectArray(groupOfOuterTool.keySet().toArray(new Object[0]));
        if (outerToolArray == null || outerToolArray.length == 0) {
            return;
        }
        for (DynamicObject reviewOuterTool : outerToolArray) {
            DynamicObjectCollection outerGroupFromDataBase = reviewOuterTool.getDynamicObjectCollection("outer_reviewgroup");
            List outerGroupIdsFromDataBase = outerGroupFromDataBase.stream().map(outer -> outer.getLong("fbasedataid.id")).collect(Collectors.toList());
            Map<Long, Boolean> groupIsUseMap = groupOfOuterTool.get(reviewOuterTool.getLong("id"));
            if (CollectionUtils.isEmpty(groupIsUseMap)) continue;
            groupIsUseMap.forEach((groupId, isUse) -> {
                if (isUse.booleanValue() && !outerGroupIdsFromDataBase.contains(groupId)) {
                    DynamicObject outerGroup = outerGroupFromDataBase.addNew();
                    outerGroup.set("fbasedataid", groupId);
                } else if (!isUse.booleanValue()) {
                    outerGroupFromDataBase.removeIf(outer -> outer.getLong("fbasedataid.id") == groupId.longValue());
                }
            });
        }
        this.toolDomainService.updateReviewOuterTool(outerToolArray);
    }

    public void saveReviewTool(DynamicObject dynamicObject) {
        if (dynamicObject.getPkValue() != null && !dynamicObject.getPkValue().equals(0L)) {
            this.toolDomainService.updateReviewTool(dynamicObject);
            return;
        }
        this.toolDomainService.saveReviewTool(dynamicObject);
    }

    public void deleteOuterToolByFilter(QFilter[] filters) {
        this.toolDomainService.deleteOuterToolByFilter(filters);
    }
}

