/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.batchconfirm;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.common.constants.enums.PlanStatusEnum;

public class ReviewPlanOpExcelExportService {
    private static final String EXCEL_IS_OPERABLE = "isoperable";
    private static final String EXCEL_CANNOT_OPERATE_REASON = "cannotoperatereason";

    public List<HRExportHeadObject> createExcelHeadData(String opKey, String formId) {
        ArrayList<HRExportHeadObject> headDatalist = new ArrayList<HRExportHeadObject>(16);
        headDatalist.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"ReviewOpExcelExportService_0", (String)"tdc-oatr-business", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"ReviewOpExcelExportService_1", (String)"tdc-oatr-business", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("activitynum", ResManager.loadKDString((String)"\u6d3b\u52a8\u6570\u91cf", (String)"ReviewOpExcelExportService_2", (String)"tdc-oatr-business", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("planstatus", ResManager.loadKDString((String)"\u8ba1\u5212\u72b6\u6001", (String)"ReviewOpExcelExportService_3", (String)"tdc-oatr-business", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("reviewyear", ResManager.loadKDString((String)"\u8ba1\u5212\u5e74\u5ea6", (String)"ReviewOpExcelExportService_4", (String)"tdc-oatr-business", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("date", ResManager.loadKDString((String)"\u8d77\u6b62\u65e5\u671f", (String)"ReviewOpExcelExportService_5", (String)"tdc-oatr-business", (Object[])new Object[0])));
        if (opKey.equals("start")) {
            headDatalist.add(new HRExportHeadObject(EXCEL_IS_OPERABLE, ResManager.loadKDString((String)"\u662f\u5426\u53ef\u542f\u52a8", (String)"ReviewOpExcelExportService_6", (String)"tdc-oatr-business", (Object[])new Object[0])));
            headDatalist.add(new HRExportHeadObject(EXCEL_CANNOT_OPERATE_REASON, ResManager.loadKDString((String)"\u4e0d\u53ef\u542f\u52a8\u539f\u56e0", (String)"ReviewOpExcelExportService_7", (String)"tdc-oatr-business", (Object[])new Object[0])));
        }
        if (opKey.equals("end")) {
            headDatalist.add(new HRExportHeadObject(EXCEL_IS_OPERABLE, ResManager.loadKDString((String)"\u662f\u5426\u53ef\u5b8c\u6210", (String)"ReviewOpExcelExportService_8", (String)"tdc-oatr-business", (Object[])new Object[0])));
            headDatalist.add(new HRExportHeadObject(EXCEL_CANNOT_OPERATE_REASON, ResManager.loadKDString((String)"\u4e0d\u53ef\u5b8c\u6210\u539f\u56e0", (String)"ReviewOpExcelExportService_9", (String)"tdc-oatr-business", (Object[])new Object[0])));
        }
        if (opKey.equals("stop")) {
            headDatalist.add(new HRExportHeadObject(EXCEL_IS_OPERABLE, ResManager.loadKDString((String)"\u662f\u5426\u53ef\u7ec8\u6b62", (String)"ReviewOpExcelExportService_12", (String)"tdc-oatr-business", (Object[])new Object[0])));
            headDatalist.add(new HRExportHeadObject(EXCEL_CANNOT_OPERATE_REASON, ResManager.loadKDString((String)"\u4e0d\u53ef\u7ec8\u6b62\u539f\u56e0", (String)"ReviewOpExcelExportService_13", (String)"tdc-oatr-business", (Object[])new Object[0])));
        }
        return headDatalist;
    }

    public List<Map<String, Object>> createExcelExportData(OperationResult operationResult, DynamicObject[] appointBills) {
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        Map<Long, String> errorInfo = allErrorOrValidateInfo.stream().collect(Collectors.toMap(opInfo -> Long.valueOf(opInfo.getPkValue().toString()), IOperateInfo::getMessage, (v1, v2) -> v1 + System.lineSeparator() + v2));
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject appointBill : appointBills) {
            HashMap<String, String> excelRowData = new HashMap<String, String>(16);
            excelRowData.put("number", appointBill.getString("number"));
            excelRowData.put("name", appointBill.getString("name"));
            excelRowData.put("activitynum", appointBill.getString("activitynum"));
            excelRowData.put("planstatus", PlanStatusEnum.getName((String)appointBill.getString("planstatus")));
            excelRowData.put("reviewyear", HRStringUtils.isEmpty((String)appointBill.getString("reviewyear")) ? "" : HRDateTimeUtils.format((Date)appointBill.getDate("reviewyear"), (String)"YYYY"));
            excelRowData.put("date", HRStringUtils.isEmpty((String)appointBill.getString("startdate")) ? "" : HRDateTimeUtils.format((Date)appointBill.getDate("startdate"), (String)"yyyy-MM-dd") + "~" + HRDateTimeUtils.format((Date)appointBill.getDate("enddate"), (String)"yyyy-MM-dd"));
            long billId = appointBill.getLong("id");
            String errorMessage = errorInfo.get(billId);
            excelRowData.put(EXCEL_IS_OPERABLE, HRStringUtils.isEmpty((String)errorMessage) ? ResManager.loadKDString((String)"\u662f", (String)"ReviewOpExcelExportService_10", (String)"tdc-oatr-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ReviewOpExcelExportService_11", (String)"tdc-oatr-business", (Object[])new Object[0]));
            excelRowData.put(EXCEL_CANNOT_OPERATE_REASON, errorMessage);
            exportData.add(excelRowData);
        }
        return exportData;
    }
}

