/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.batchconfirm.activity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.CalibrateSessionQueryService;
import kd.tdc.oatr.bussiness.queryservice.OnlineCalibrationQueryService;

public class OnlineCalibrationFinishFormService {
    private static final String FINISH_CALIBRATE_ACTION = "finishCalibrateAction";
    private final CalibrateSessionQueryService calSessionQueryService = ServiceFactory.getService(CalibrateSessionQueryService.class);
    private final OnlineCalibrationQueryService calibrationQueryService = ServiceFactory.getService(OnlineCalibrationQueryService.class);
    private static final String EXCEL_IS_OPERABLE = "isoperable";
    private static final String EXCEL_CANNOT_OPERATE_REASON = "cannotoperatereason";

    public void callValidatorBeforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs, String operateKey, AbstractFormPlugin formPlugin) {
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        String opKey = operate.getOperateKey();
        if (!operateKey.equals(opKey)) {
            return;
        }
        String isOpCancel = operate.getOption().getVariableValue("isopcancel", null);
        if (HRStringUtils.isEmpty((String)isOpCancel)) {
            beforeDoOperationEventArgs.setCancel(true);
            this.validateOnlineCalibrationData(operate, formPlugin);
        }
    }

    public void callOperateCloseCallback(ClosedCallBackEvent closedCallBackEvent, AbstractFormPlugin formPlugin) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(FINISH_CALIBRATE_ACTION)) {
            Object eventReturnData = closedCallBackEvent.getReturnData();
            ListView listView = (ListView)formPlugin.getView();
            if (eventReturnData == null) {
                listView.clearSelection();
                return;
            }
            Map returnData = (Map)eventReturnData;
            if (returnData.isEmpty()) {
                listView.clearSelection();
                return;
            }
            boolean isConfirm = (Boolean)returnData.get("iscofirm");
            if (isConfirm) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("isopcancel", "0");
                listView.invokeOperation("actualfinishcalibrate", option);
            }
        }
    }

    private void validateOnlineCalibrationData(FormOperate operate, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        List<Long> pkIds = Arrays.stream(primaryKeyValues).map(value -> Long.valueOf(value.toString())).collect(Collectors.toList());
        Object sessionIdObj = listView.getFormShowParameter().getCustomParam("calSessionId");
        if (CollectionUtils.isEmpty(pkIds) || sessionIdObj == null) {
            return;
        }
        DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(Long.parseLong(sessionIdObj.toString()));
        String sessionNumber = HRDyObjectPropUtil.getString((DynamicObject)calibrateSession, (String)"number");
        String sessionName = HRDyObjectPropUtil.getName((DynamicObject)calibrateSession);
        DynamicObject[] listedOnlineCalibrationOriginalData = this.calibrationQueryService.listOnlineCalibrationOriginalData(pkIds);
        int allCount = pkIds.size();
        int notCalibrateCount = 0;
        int calibratedCount = 0;
        int noReasonCount = 0;
        ArrayList exportData = Lists.newArrayListWithExpectedSize((int)allCount);
        ArrayList noReasonExportData = Lists.newArrayListWithExpectedSize((int)allCount);
        String yesName = ResManager.loadKDString((String)"\u662f", (String)"OnlineCalibrationFinishFormService_0", (String)"tdc-oatr-business", (Object[])new Object[]{allCount});
        String noName = ResManager.loadKDString((String)"\u5426", (String)"OnlineCalibrationFinishFormService_1", (String)"tdc-oatr-business", (Object[])new Object[]{allCount});
        String passTips = ResManager.loadKDString((String)"\u65e0", (String)"OnlineCalibrationFinishFormService_2", (String)"tdc-oatr-business", (Object[])new Object[0]);
        String noReasonTips = ResManager.loadKDString((String)"\u4eba\u5458\u5728\u6821\u51c6\u4f1a\u4f4d\u7f6e\u53d1\u751f\u6539\u53d8\uff0c\u4f46\u672a\u586b\u5199\u6821\u51c6\u539f\u56e0\u3002", (String)"OnlineCalibrationFinishFormService_4", (String)"tdc-oatr-business", (Object[])new Object[0]);
        for (DynamicObject calibrationOriginalDatum : listedOnlineCalibrationOriginalData) {
            String personName = calibrationOriginalDatum.getString("person.name");
            String personNumber = calibrationOriginalDatum.getString("person.number");
            HashMap exportDataItem = Maps.newHashMapWithExpectedSize((int)6);
            exportDataItem.put("number", sessionNumber);
            exportDataItem.put("name", sessionName);
            exportDataItem.put("personName", personName);
            exportDataItem.put("personNumber", personNumber);
            exportDataItem.put(EXCEL_IS_OPERABLE, yesName);
            exportDataItem.put(EXCEL_CANNOT_OPERATE_REASON, passTips);
            exportData.add(new HashMap(exportDataItem));
            String calibrateResult = calibrationOriginalDatum.getString("calibrateresult");
            String calibrateReason = calibrationOriginalDatum.getString("calibratereason");
            String calibrateBefore = calibrationOriginalDatum.getString("calibratebefore");
            if (HRStringUtils.isEmpty((String)calibrateResult) || HRStringUtils.equals((String)calibrateResult, (String)calibrateBefore)) {
                ++notCalibrateCount;
                continue;
            }
            if (HRStringUtils.isNotEmpty((String)calibrateResult) && HRStringUtils.isEmpty((String)calibrateReason)) {
                exportDataItem.put(EXCEL_IS_OPERABLE, noName);
                exportDataItem.put(EXCEL_CANNOT_OPERATE_REASON, noReasonTips);
                noReasonExportData.add(exportDataItem);
                ++noReasonCount;
                continue;
            }
            ++calibratedCount;
        }
        if (notCalibrateCount == 0 && noReasonCount == 0) {
            OperateOption option = operate.getOption();
            option.setVariableValue("isopcancel", "0");
            listView.invokeOperation(operate.getOperateKey(), option);
            return;
        }
        String calibrateReasonMustInput = calibrateSession.getString("calibratereason");
        if (HRStringUtils.equals((String)calibrateReasonMustInput, (String)"1") && noReasonCount != 0) {
            this.showValidateNotPassView(formPlugin, noReasonCount, noReasonExportData);
            return;
        }
        this.showValidateConfirmView(formPlugin, allCount, notCalibrateCount, calibratedCount, noReasonCount, exportData);
    }

    private void showValidateNotPassView(AbstractFormPlugin formPlugin, int noReasonCount, List<Map<String, Object>> noReasonExportData) {
        IListView listView = (IListView)formPlugin.getView();
        FormShowParameter formShowParameter = new FormShowParameter();
        String excelName = String.format(ResManager.loadKDString((String)"\u5b8c\u6210\u6821\u51c6\u786e\u8ba4\u6570\u636e_%S", (String)"OnlineCalibrationFinishFormService_5", (String)"tdc-oatr-business", (Object[])new Object[0]), LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        List<HRExportHeadObject> headDataList = this.createExcelHeadData();
        formShowParameter.setCustomParam("excelname", (Object)excelName);
        formShowParameter.setCustomParam("headdatalist", headDataList);
        formShowParameter.setCustomParam("exportdatalist", noReasonExportData);
        formShowParameter.setCustomParam("noPassNum", (Object)String.valueOf(noReasonCount));
        formShowParameter.setFormId("oatr_finishcalnopass");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listView.showForm(formShowParameter);
    }

    private void showValidateConfirmView(AbstractFormPlugin formPlugin, int allCount, int notCalibrateCount, int calibratedCount, int noReasonCount, List<Map<String, Object>> exportData) {
        IListView listView = (IListView)formPlugin.getView();
        String allNumLbl = ResManager.loadKDString((String)"\u5df2\u9009\u62e9{0}\u4eba\u5b8c\u6210\u6821\u51c6\uff0c\u5176\u4e2d\uff1a", (String)"OnlineCalibrationFinishFormService_6", (String)"tdc-oatr-business", (Object[])new Object[]{allCount});
        String fitNumExtLbl = String.valueOf(notCalibrateCount);
        String fitExtLbl = ResManager.loadKDString((String)"\u4eba\u5728\u5bab\u683c\u5730\u56fe\u6240\u5904\u4f4d\u7f6e\u672a\u53d1\u751f\u6539\u53d8\uff1b", (String)"OnlineCalibrationFinishFormService_7", (String)"tdc-oatr-business", (Object[])new Object[0]);
        String fitNumLbl = String.valueOf(calibratedCount);
        String fitLbl = ResManager.loadKDString((String)"\u4eba\u5728\u5bab\u683c\u5730\u56fe\u6240\u5904\u4f4d\u7f6e\u53d1\u751f\u6539\u53d8\uff0c\u5df2\u586b\u5199\u6821\u51c6\u539f\u56e0\uff1b", (String)"OnlineCalibrationFinishFormService_8", (String)"tdc-oatr-business", (Object[])new Object[0]);
        String noFitNumLbl = String.valueOf(noReasonCount);
        String noFitLbl = ResManager.loadKDString((String)"\u4eba\u5728\u5bab\u683c\u5730\u56fe\u6240\u5904\u4f4d\u7f6e\u53d1\u751f\u6539\u53d8\uff0c\u672a\u586b\u5199\u6821\u51c6\u539f\u56e0\uff1b", (String)"OnlineCalibrationFinishFormService_9", (String)"tdc-oatr-business", (Object[])new Object[0]);
        String finalLbl = ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4e0d\u53ef\u64a4\u9500\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OnlineCalibrationFinishFormService_10", (String)"tdc-oatr-business", (Object[])new Object[0]);
        String excelName = String.format(ResManager.loadKDString((String)"\u5b8c\u6210\u6821\u51c6\u786e\u8ba4\u6570\u636e_%S", (String)"OnlineCalibrationFinishFormService_11", (String)"tdc-oatr-business", (Object[])new Object[0]), LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        List<HRExportHeadObject> headDataList = this.createExcelHeadData();
        FormShowParameter confirmPage = new FormShowParameter();
        confirmPage.getOpenStyle().setShowType(ShowType.Modal);
        confirmPage.setCustomParam("lbl_allnum", (Object)allNumLbl);
        confirmPage.setCustomParam("lbl_fitnumext", (Object)fitNumExtLbl);
        confirmPage.setCustomParam("lbl_fitext", (Object)fitExtLbl);
        confirmPage.setCustomParam("lbl_fitnum", (Object)fitNumLbl);
        confirmPage.setCustomParam("lbl_fit", (Object)fitLbl);
        confirmPage.setCustomParam("lbl_nofitnum", (Object)noFitNumLbl);
        confirmPage.setCustomParam("lbl_nofit", (Object)noFitLbl);
        confirmPage.setCustomParam("lbl_final", (Object)finalLbl);
        confirmPage.setCustomParam("excelname", (Object)excelName);
        confirmPage.setCustomParam("exportdatalist", exportData);
        confirmPage.setCustomParam("headdatalist", headDataList);
        confirmPage.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, FINISH_CALIBRATE_ACTION));
        if (notCalibrateCount == 0) {
            confirmPage.setCustomParam("isShowExt", (Object)"0");
        } else {
            confirmPage.setCustomParam("isShowExt", (Object)"1");
        }
        if (calibratedCount == 0) {
            confirmPage.setCustomParam("isShowFit", (Object)"0");
        } else {
            confirmPage.setCustomParam("isShowFit", (Object)"1");
        }
        if (noReasonCount == 0) {
            confirmPage.setCustomParam("isShowNotFit", (Object)"0");
        } else {
            confirmPage.setCustomParam("isShowNotFit", (Object)"1");
        }
        confirmPage.setFormId("oatr_finishvaliconfirm");
        listView.showForm(confirmPage);
    }

    private List<HRExportHeadObject> createExcelHeadData() {
        ArrayList<HRExportHeadObject> headDatalist = new ArrayList<HRExportHeadObject>(16);
        headDatalist.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u6821\u51c6\u4f1a\u7f16\u53f7", (String)"OnlineCalibrationFinishFormService_12", (String)"tdc-oatr-business", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u6821\u51c6\u4f1a\u540d\u79f0", (String)"OnlineCalibrationFinishFormService_13", (String)"tdc-oatr-business", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("personName", ResManager.loadKDString((String)"\u59d3\u540d", (String)"OnlineCalibrationFinishFormService_14", (String)"tdc-oatr-business", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject("personNumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"OnlineCalibrationFinishFormService_15", (String)"tdc-oatr-business", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject(EXCEL_IS_OPERABLE, ResManager.loadKDString((String)"\u662f\u5426\u53ef\u5b8c\u6210\u6821\u51c6", (String)"OnlineCalibrationFinishFormService_16", (String)"tdc-oatr-business", (Object[])new Object[0])));
        headDatalist.add(new HRExportHeadObject(EXCEL_CANNOT_OPERATE_REASON, ResManager.loadKDString((String)"\u4e0d\u53ef\u5b8c\u6210\u539f\u56e0", (String)"OnlineCalibrationFinishFormService_17", (String)"tdc-oatr-business", (Object[])new Object[0])));
        return headDatalist;
    }
}

