/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.batchconfirm.activity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.OnlineCalibrationApplicationService;
import kd.tdc.oatr.bussiness.queryservice.CalibrateSessionQueryService;
import kd.tdc.oatr.bussiness.queryservice.OnlineCalibrationQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewObjectQueryService;
import kd.tdc.oatr.common.bo.onlinecalibration.PersonCardInfo;
import kd.tdc.oatr.common.constants.enums.ActivityStatusStyleEnum;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;

public class OnlineCalibrationFormService {
    private static final Log LOG = LogFactory.getLog(OnlineCalibrationFormService.class);
    private final OnlineCalibrationApplicationService calibrationApplicationService = ServiceFactory.getService(OnlineCalibrationApplicationService.class);
    private final ReviewObjectQueryService reviewObjectQueryService = ServiceFactory.getService(ReviewObjectQueryService.class);
    private final CalibrateSessionQueryService calSessionQueryService = ServiceFactory.getService(CalibrateSessionQueryService.class);
    private final ReviewActivityQueryService activityQueryService = ServiceFactory.getService(ReviewActivityQueryService.class);
    private final OnlineCalibrationQueryService onlineCalibrationQueryService = ServiceFactory.getService(OnlineCalibrationQueryService.class);

    public List<String> validateCalibrate(AbstractFormPlugin formPlugin) {
        FormShowParameter showParameter = formPlugin.getView().getFormShowParameter();
        Object activityIdObj = showParameter.getCustomParam("activityId");
        if (activityIdObj == null) {
            return new ArrayList<String>(0);
        }
        Object sessionIdObj = showParameter.getCustomParam("calSessionId");
        if (sessionIdObj == null) {
            return new ArrayList<String>(0);
        }
        long sessionId = Long.parseLong(sessionIdObj.toString());
        long activityId = Long.parseLong(activityIdObj.toString());
        String collaborationFlag = (String)showParameter.getCustomParam("collaboration_flag");
        List<String> requireCalibrateStatus = Collections.singletonList(CalibrateSessionStatusEnum.GOING.getCode());
        return this.calibrationApplicationService.validateCalibrateCondition(activityId, sessionId, collaborationFlag, requireCalibrateStatus);
    }

    public void showCalibrateErrorMsg(List<String> errorMsg, String opName, AbstractFormPlugin formPlugin) {
        if (errorMsg.isEmpty()) {
            return;
        }
        if (errorMsg.contains("sessionEmptyError") || errorMsg.contains("activityEmptyError")) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"OnlineCalibrationFormService_3", (String)"tdc-oatr-business", (Object[])new Object[0]));
            return;
        }
        if (errorMsg.contains("organizerError")) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6d3b\u52a8\u7ba1\u7406\u5458\u53ca\u6821\u51c6\u4f1a\u7ec4\u7ec7\u8005\u53ef\u64cd\u4f5c{0}\u3002", (String)"OnlineCalibrationFormService_0", (String)"tdc-oatr-business", (Object[])new Object[]{opName}));
            return;
        }
        if (errorMsg.contains("activityStatusError")) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\uff0c\u624d\u80fd{0}\u3002", (String)"OnlineCalibrationFormService_1", (String)"tdc-oatr-business", (Object[])new Object[]{opName}));
            return;
        }
        if (errorMsg.contains("calibrateStatusError")) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u6821\u51c6\u4f1a\u72b6\u6001\u5fc5\u987b\u662f\u201c\u8fdb\u884c\u4e2d\u201d\u624d\u80fd{0}\u3002", (String)"OnlineCalibrationFormService_2", (String)"tdc-oatr-business", (Object[])new Object[]{opName}));
        }
    }

    public Map<String, String> validateCalibratePerson(Map<String, PersonCardInfo> tempCalInfoMap, AbstractFormPlugin formPlugin) {
        Map<String, String> msgOfPersonMap = this.validatePerson(tempCalInfoMap, formPlugin);
        tempCalInfoMap.keySet().removeIf(msgOfPersonMap::containsKey);
        this.validateDataRule(tempCalInfoMap, msgOfPersonMap);
        tempCalInfoMap.keySet().removeIf(msgOfPersonMap::containsKey);
        return msgOfPersonMap;
    }

    public Map<String, String> validatePerson(Map<String, PersonCardInfo> personCardInfoMap, AbstractFormPlugin formPlugin) {
        PersonCardInfo personCardInfo;
        String personId;
        HashMap validatePersonMsgMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(personCardInfoMap)) {
            return validatePersonMsgMap;
        }
        FormShowParameter showParameter = formPlugin.getView().getFormShowParameter();
        Object sessionIdObj = showParameter.getCustomParam("calSessionId");
        Object activityIdObj = showParameter.getCustomParam("activityId");
        long calSessionId = Long.parseLong(sessionIdObj.toString());
        long activityId = Long.parseLong(activityIdObj.toString());
        ArrayList personIds = Lists.newArrayListWithExpectedSize((int)personCardInfoMap.size());
        personCardInfoMap.keySet().forEach(k -> personIds.add(Long.valueOf(k)));
        DynamicObject[] reviewObjectData = this.reviewObjectQueryService.getReviewObjectData(activityId, personIds);
        if (reviewObjectData != null && reviewObjectData.length > 0) {
            Map<String, DynamicObject> reviewObjectMap = Arrays.stream(reviewObjectData).collect(Collectors.toMap(data -> data.getString("person.id"), data -> data, (v1, v2) -> v2));
            for (Map.Entry<String, PersonCardInfo> entry : personCardInfoMap.entrySet()) {
                String personId2 = entry.getKey();
                PersonCardInfo personCardInfo2 = entry.getValue();
                DynamicObject reviewObj = reviewObjectMap.get(personId2);
                if (reviewObj == null) {
                    validatePersonMsgMap.putIfAbsent(personId2, ResManager.loadKDString((String)"{0}\u76d8\u70b9\u5bf9\u8c61\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"OnlineCalibrationFormService_4", (String)"tdc-oatr-business", (Object[])new Object[]{personCardInfo2.getPersonNumber() + personCardInfo2.getPersonName()}));
                    continue;
                }
                String reviewStatus = reviewObj.getString("reviewstatus");
                if (!HRStringUtils.equals((String)ObjectStatusEnum.STOP_REVIEW.getCode(), (String)reviewStatus)) continue;
                validatePersonMsgMap.putIfAbsent(personId2, ResManager.loadKDString((String)"{0}\u76d8\u70b9\u5bf9\u8c61\u5df2\u7ec8\u6b62\u76d8\u70b9\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"OnlineCalibrationFormService_5", (String)"tdc-oatr-business", (Object[])new Object[]{personCardInfo2.getPersonNumber() + personCardInfo2.getPersonName()}));
            }
        }
        QFilter sessionIdFilter = new QFilter("calibratesession.id", "=", (Object)calSessionId);
        QFilter personIdFilter = new QFilter("person.id", "in", (Object)personIds);
        DynamicObject[] onlineCalibrateDyns = this.calibrationApplicationService.queryOnlineCalibrate("id,person.id", new QFilter[]{sessionIdFilter, personIdFilter});
        for (Map.Entry<String, PersonCardInfo> entry : personCardInfoMap.entrySet()) {
            personId = entry.getKey();
            personCardInfo = entry.getValue();
            DynamicObject reviewObj = null;
            if (onlineCalibrateDyns != null && onlineCalibrateDyns.length > 0) {
                Map<String, DynamicObject> onlineCalibrateMap = Arrays.stream(onlineCalibrateDyns).collect(Collectors.toMap(data -> data.getString("person.id"), data -> data, (v1, v2) -> v2));
                reviewObj = onlineCalibrateMap.get(personId);
            }
            if (reviewObj != null) continue;
            validatePersonMsgMap.putIfAbsent(personId, ResManager.loadKDString((String)"{0}\u76d8\u70b9\u5bf9\u8c61\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"OnlineCalibrationFormService_4", (String)"tdc-oatr-business", (Object[])new Object[]{personCardInfo.getPersonNumber() + personCardInfo.getPersonName()}));
        }
        for (Map.Entry<String, PersonCardInfo> entry : personCardInfoMap.entrySet()) {
            personId = entry.getKey();
            personCardInfo = entry.getValue();
            String afterCalibratePath = personCardInfo.getCalibratePath().getAfterCard();
            String calibrateResult = personCardInfo.isCalibrated() ? this.calibrationApplicationService.transCalibratePathToPosition(afterCalibratePath) : "";
            String calibrateReason = personCardInfo.getReason();
            if (calibrateResult != null && calibrateResult.length() > 120) {
                validatePersonMsgMap.putIfAbsent(personId, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u6821\u51c6\u7ed3\u679c\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,{}]\u3002", (String)"OnlineCalibrationFormService_6", (String)"tdc-oatr-business", (Object[])new Object[]{120, personCardInfo.getPersonNumber() + personCardInfo.getPersonName()}));
            }
            if (calibrateReason == null || calibrateReason.length() <= 255) continue;
            validatePersonMsgMap.putIfAbsent(personId, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u6821\u51c6\u539f\u56e0\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,{}]\u3002", (String)"OnlineCalibrationFormService_7", (String)"tdc-oatr-business", (Object[])new Object[]{255, personCardInfo.getPersonNumber() + personCardInfo.getPersonName()}));
        }
        return validatePersonMsgMap;
    }

    public void validateDataRule(Map<String, PersonCardInfo> tempCalInfoMap, Map<String, String> msgOfPersonMap) {
        QFilter dataRuleFilter = PermissionServiceHelper.getDataRule((long)RequestContext.get().getCurrUserId(), (String)"32J2T2KEXE6T", (String)"oatr_onlinecalibration", (String)"4715a0df000000ac");
        ArrayList personIds = Lists.newArrayListWithExpectedSize((int)tempCalInfoMap.size());
        tempCalInfoMap.keySet().forEach(k -> personIds.add(Long.valueOf(k)));
        QFilter calibratePersonIdFilter = new QFilter("person.id", "in", (Object)personIds);
        DynamicObject[] dataRuleCalibrationInfo = this.calibrationApplicationService.queryOnlineCalibrate("person.id", new QFilter[]{calibratePersonIdFilter, dataRuleFilter});
        String dataRuleMsg = ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u201c\u4fee\u6539\u201d\u3001\u201c\u5728\u7ebf\u6821\u51c6\u201d\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnlineCalibrationFormService_8", (String)"tdc-oatr-business", (Object[])new Object[0]);
        if (dataRuleCalibrationInfo == null || dataRuleCalibrationInfo.length == 0) {
            tempCalInfoMap.forEach((personId, personCardInfo) -> msgOfPersonMap.put((String)personId, dataRuleMsg));
        } else {
            List dataRulePersonIds = Arrays.stream(dataRuleCalibrationInfo).map(info -> info.getString("person.id")).collect(Collectors.toList());
            tempCalInfoMap.forEach((personId, personCardInfo) -> {
                if (!dataRulePersonIds.contains(personId)) {
                    msgOfPersonMap.put((String)personId, dataRuleMsg);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCalibrationInfo(Map<String, PersonCardInfo> tempCalInfoMap, AbstractFormPlugin formPlugin) {
        if (!CollectionUtils.isEmpty(tempCalInfoMap)) {
            try (TXHandle txhandle = TX.required((String)"OnlineCalibrationFormService.updateCalibrationInfo");){
                String updateResult = this.updateDBOnlineCalibrationInfo(tempCalInfoMap, formPlugin);
                if (HRStringUtils.isNotEmpty((String)updateResult)) {
                    this.recordCollaborationBusinessData(formPlugin);
                }
            }
        }
    }

    public String updateDBOnlineCalibrationInfo(Map<String, PersonCardInfo> personCardInfoMap, AbstractFormPlugin formPlugin) {
        Object sessionIdObj = formPlugin.getView().getFormShowParameter().getCustomParam("calSessionId");
        if (sessionIdObj == null || HRStringUtils.isEmpty((String)sessionIdObj.toString())) {
            return "";
        }
        Long calSessionId = Long.valueOf(sessionIdObj.toString());
        return this.calibrationApplicationService.updateOnlineCalibrateResult(calSessionId, personCardInfoMap);
    }

    public void recordCollaborationBusinessData(AbstractFormPlugin formPlugin) {
        Object activityIdObj = formPlugin.getView().getFormShowParameter().getCustomParam("activityId");
        if (activityIdObj != null) {
            long activityId = Long.parseLong(activityIdObj.toString());
            this.calibrationApplicationService.recordCollaborationBusinessData(activityId);
        }
    }

    public void showValidateResult(Map<String, String> msgOfPersonMap, AbstractFormPlugin formPlugin) {
        String opName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"OnlineCalibrationFormService_9", (String)"tdc-oatr-business", (Object[])new Object[0]);
        String caption = ResManager.loadKDString((String)"\u51fa\u9519\u63d0\u793a", (String)"OnlineCalibrationFormService_10", (String)"tdc-oatr-business", (Object[])new Object[0]);
        String title = ResManager.loadKDString((String)"{0}\u4eba\u7684\u6821\u51c6\u7ed3\u679c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"OnlineCalibrationFormService_11", (String)"tdc-oatr-business", (Object[])new Object[]{msgOfPersonMap.size()});
        OperationResult operationResult = new OperationResult();
        msgOfPersonMap.forEach((personId, msg) -> {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setErrorLevel(ErrorLevel.FatalError.name());
            operateErrorInfo.setMessage(msg);
            operationResult.addErrorInfo(operateErrorInfo);
        });
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(true);
        IPageCache pageCache = formPlugin.getPageCache();
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
        parameters.setCaption(caption);
        parameters.setCustomParam("operateName", (Object)opName);
        parameters.setCustomParam("errorMsg", (Object)Lists.newArrayList(msgOfPersonMap.values()));
        parameters.setCustomParam("hasMore", (Object)(msgOfPersonMap.size() > 5 ? 1 : 0));
        parameters.setCustomParam("title", (Object)title);
        formPlugin.getView().showForm(parameters);
    }

    public void setReviewActivityInfo(AbstractFormPlugin formPlugin) {
        IFormView view = formPlugin.getView();
        Object sessionIdObj = view.getFormShowParameter().getCustomParam("calSessionId");
        Object activityIdObj = view.getFormShowParameter().getCustomParam("activityId");
        if (activityIdObj == null || sessionIdObj == null) {
            return;
        }
        Long calibrateSessionId = Long.valueOf(sessionIdObj.toString());
        Long activityId = Long.valueOf(activityIdObj.toString());
        DynamicObject calibrateSession = this.calSessionQueryService.getCalibrateSession(calibrateSessionId);
        DynamicObject reviewActivity = this.activityQueryService.getReviewActivity(activityId);
        if (HRObjectUtils.isEmpty((Object)calibrateSession) || HRObjectUtils.isEmpty((Object)reviewActivity)) {
            return;
        }
        Map<Long, Integer> sessionAdjustNumMap = this.onlineCalibrationQueryService.queryCalibrationSessionAdjustNum(Collections.singletonList(calibrateSessionId));
        String sessionName = HRDyObjectPropUtil.getName((DynamicObject)calibrateSession);
        String activityName = reviewActivity.getString("name");
        String activityNumber = reviewActivity.getString("number");
        String reviewTypeName = HRDyObjectPropUtil.getName((DynamicObject)reviewActivity.getDynamicObject("reviewtype"));
        String activityStatus = reviewActivity.getString("activitystatus");
        ActivityStatusStyleEnum statusEnum = ActivityStatusStyleEnum.getEnumByCode((String)activityStatus);
        int calibratePersonNum = calibrateSession.getInt("calibratepersonnum");
        Integer adjustNum = sessionAdjustNumMap.get(calibrateSessionId);
        Label sessionNameLbl = (Label)view.getControl("name");
        sessionNameLbl.setText(sessionName);
        Label numberLbl = (Label)view.getControl("number");
        numberLbl.setText(activityNumber);
        Label typeLbl = (Label)view.getControl("type");
        typeLbl.setText(reviewTypeName);
        Label activityLbl = (Label)view.getControl("activity");
        activityLbl.setText(activityName);
        Label statusLbl = (Label)formPlugin.getControl("status");
        statusLbl.setText(statusEnum.getName());
        Label personNumLbl = (Label)formPlugin.getControl("calibratepersonnum");
        personNumLbl.setText(String.valueOf(calibratePersonNum));
        Label adjustNumLbl = (Label)formPlugin.getControl("adjustnum");
        adjustNumLbl.setText(adjustNum != null ? String.valueOf(adjustNum) : "0");
    }
}

