/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.domain.activity;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.domain.activity.ReviewActivityAdminOrgService;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.bussiness.queryservice.AdminOrgQueryService;
import kd.tdc.oatr.common.bo.ReviewActivityAdminOrgTreeInfo;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;

public class ReviewActivityService {
    private static final Log LOG = LogFactory.getLog(ReviewActivityService.class);
    private static final HRBaseServiceHelper REVIEW_ACTIVITY_HELPER = new HRBaseServiceHelper("oatr_reviewactivity");
    private final ReviewActivityAdminOrgService reviewActivityAdminOrgService = ServiceFactory.getService(ReviewActivityAdminOrgService.class);
    private final ReviewObjectService reviewObjectService = ServiceFactory.getService(ReviewObjectService.class);

    public DynamicObject queryOne(String selectProps, Object pkId) {
        return REVIEW_ACTIVITY_HELPER.queryOne(selectProps, pkId);
    }

    public DynamicObject getReviewActivity(Object activityPk) {
        return REVIEW_ACTIVITY_HELPER.queryOne("activitytemplate,reviewplan,perscopefilter_tag,activitystatus,talentmapentry,createorg,adminorgentry.adminorgvid,adminorgentry.includesub", activityPk);
    }

    public void save(DynamicObject[] objects) {
        REVIEW_ACTIVITY_HELPER.save(objects);
    }

    public void saveReviewObjAdminorgTree(List<Long> reviewactivityIds) {
        DynamicObject[] reviewObjs = this.reviewObjectService.getJoinedReviewObjectsByActivityIds(reviewactivityIds);
        if (reviewObjs == null) {
            return;
        }
        LOG.info("===saveReviewObjAdminorgTree===,reviewactivityIds = {} ,reviewObjs.size = {}", reviewactivityIds, (Object)reviewObjs.length);
        ArrayList<ReviewActivityAdminOrgTreeInfo> allReviewActivityAdminOrgTreeInfos = new ArrayList<ReviewActivityAdminOrgTreeInfo>(16);
        for (Long reviewactivityId : reviewactivityIds) {
            List<ReviewActivityAdminOrgTreeInfo> activityAdminOrgTreeInfos = ReviewActivityService.getActAdminOrgTreeInfo(reviewactivityId, reviewObjs);
            allReviewActivityAdminOrgTreeInfos.addAll(activityAdminOrgTreeInfos);
        }
        LOG.info("===saveReviewObjAdminorgTree->allReviewActivityAdminOrgTreeInfos===\uff1a,allReviewActivityAdminOrgTreeInfos = {}", (Object)SerializationUtils.toJsonString(allReviewActivityAdminOrgTreeInfos));
        List<DynamicObject> reviewObjAdminorgTreeDOs = this.generatorNotReviewActOrgTreeObject(allReviewActivityAdminOrgTreeInfos);
        LOG.info("===saveReviewObjAdminorgTree->reviewObjAdminorgTreeDOs.size===\uff1a{}", (Object)reviewObjAdminorgTreeDOs.size());
        this.reviewActivityAdminOrgService.delete(reviewactivityIds);
        this.reviewActivityAdminOrgService.save(reviewObjAdminorgTreeDOs);
    }

    public List<DynamicObject> generatorNotReviewActOrgTreeObject(List<ReviewActivityAdminOrgTreeInfo> allReviewActivityAdminOrgTreeInfos) {
        List<DynamicObject> emptyReviewActOrgTreeObjects = this.reviewActivityAdminOrgService.generatorEmptyObjs(allReviewActivityAdminOrgTreeInfos.size());
        long[] ReviewActOrgTreeIds = ORM.create().genLongIds("oatr_revactadmorgtree", emptyReviewActOrgTreeObjects.size());
        int i = 0;
        for (DynamicObject emptyReviewActOrgTreeObject : emptyReviewActOrgTreeObjects) {
            emptyReviewActOrgTreeObject.set("id", (Object)ReviewActOrgTreeIds[i]);
            emptyReviewActOrgTreeObject.set("status", (Object)ObjectStatusEnum.UN_IN.getCode());
            emptyReviewActOrgTreeObject.set("enable", (Object)"1");
            emptyReviewActOrgTreeObject.set("reviewactivity", (Object)allReviewActivityAdminOrgTreeInfos.get(i).getReviewActivityFid());
            emptyReviewActOrgTreeObject.set("adminorgboid", (Object)allReviewActivityAdminOrgTreeInfos.get(i).getAdminorgBoId());
            if (allReviewActivityAdminOrgTreeInfos.get(i).getActivitystatus().equals("C") || allReviewActivityAdminOrgTreeInfos.get(i).getActivitystatus().equals("D")) {
                emptyReviewActOrgTreeObject.set("adminorname", (Object)allReviewActivityAdminOrgTreeInfos.get(i).getAdminorName());
                emptyReviewActOrgTreeObject.set("adminorgfid", (Object)allReviewActivityAdminOrgTreeInfos.get(i).getAdminorgFid());
            }
            emptyReviewActOrgTreeObject.set("adminstructfid", (Object)allReviewActivityAdminOrgTreeInfos.get(i).getAdminstructFid());
            emptyReviewActOrgTreeObject.set("admstructlongnum", (Object)allReviewActivityAdminOrgTreeInfos.get(i).getAdminstructLongNumber());
            emptyReviewActOrgTreeObject.set("ishavereviewobjec", (Object)allReviewActivityAdminOrgTreeInfos.get(i).isHaveReviewObjec());
            emptyReviewActOrgTreeObject.set("reviewobjectsum", (Object)allReviewActivityAdminOrgTreeInfos.get(i).getReviewObjectSum());
            ++i;
        }
        return emptyReviewActOrgTreeObjects;
    }

    public static String getActStatus(DynamicObject[] reviewObjs) {
        String actStatus = "";
        if (reviewObjs != null && reviewObjs.length > 0) {
            actStatus = reviewObjs[0].getString("reviewactivity.activitystatus");
        }
        return actStatus;
    }

    public static List<ReviewActivityAdminOrgTreeInfo> getActAdminOrgTreeInfo(Long reviewActivityId, DynamicObject[] reviewObjs) {
        DynamicObject[] actAdmStructDOs;
        DynamicObject[] actAdmOrgDOs;
        LOG.info("===getActAdminOrgTreeInfo===,reviewActivityId = {} ,reviewObjs.size = {}", (Object)reviewActivityId, (Object)reviewObjs.length);
        ArrayList<ReviewActivityAdminOrgTreeInfo> actAdminOrgTreeInfos = new ArrayList<ReviewActivityAdminOrgTreeInfo>(16);
        List<Long> revObjsAdmOrgBoIds = ReviewActivityService.reviewObjsAdminOrgBoIds(reviewActivityId, reviewObjs);
        LOG.info("===getActAdminOrgTreeInfo->reviewObjsAdminOrgFids===,revObjsAdmOrgBoIds = {}", revObjsAdmOrgBoIds);
        List<String> admOrgLongNumbers = ReviewActivityService.getAdmOrgLongNumber(revObjsAdmOrgBoIds);
        LOG.info("===getActAdminOrgTreeInfo->getAdmOrgLongNumber===,admOrgLongNumbers = {}", admOrgLongNumbers);
        List<String> allAdmOrgLongNumbers = ReviewActivityService.getAllAdmOrgNumber(admOrgLongNumbers);
        LOG.info("===getActAdminOrgTreeInfo->allAdmOrgLongNumbers===,allAdmOrgLongNumbers = {}", allAdmOrgLongNumbers);
        ArrayList<Long> allAdmOrgBoId = new ArrayList<Long>(16);
        String reviewActivityStatus = ReviewActivityService.getActStatus(reviewObjs);
        for (DynamicObject actAdmOrgDO : actAdmOrgDOs = AdminOrgQueryService.getAdminorgInfos(allAdmOrgLongNumbers)) {
            ReviewActivityAdminOrgTreeInfo actAdminOrgTree = new ReviewActivityAdminOrgTreeInfo();
            actAdminOrgTree.setReviewActivityFid(reviewActivityId);
            actAdminOrgTree.setAdminorgBoId(Long.valueOf(actAdmOrgDO.getLong("boid")));
            actAdminOrgTree.setAdminorgFid(Long.valueOf(actAdmOrgDO.getLong("sourcevid")));
            actAdminOrgTree.setAdminorName(actAdmOrgDO.getString("name"));
            actAdminOrgTree.setActivitystatus(reviewActivityStatus);
            actAdminOrgTreeInfos.add(actAdminOrgTree);
            allAdmOrgBoId.add(actAdmOrgDO.getLong("boid"));
        }
        for (DynamicObject actAdmStructDO : actAdmStructDOs = AdminOrgQueryService.getAdminstructInfos(allAdmOrgBoId)) {
            Long adminorgBoId = actAdmStructDO.getDynamicObject("adminorg").getLong("boid");
            Long actAdmStrucFid = actAdmStructDO.getLong("sourcevid");
            String actAdmStrucLongNumber = actAdmStructDO.getString("structlongnumber");
            for (ReviewActivityAdminOrgTreeInfo actAdminOrgTree : actAdminOrgTreeInfos) {
                if (!adminorgBoId.equals(actAdminOrgTree.getAdminorgBoId())) continue;
                actAdminOrgTree.setAdminstructFid(actAdmStrucFid);
                actAdminOrgTree.setAdminstructLongNumber(actAdmStrucLongNumber);
            }
        }
        for (DynamicObject reviewObj : reviewObjs) {
            DynamicObject adminOrg;
            if (reviewObj.getDynamicObject("reviewactivity").getLong("id") != reviewActivityId.longValue() || (adminOrg = reviewObj.getDynamicObject("adminorg")) == null) continue;
            Long adminOrgBoId = adminOrg.getLong("boid");
            String actStatus = reviewObj.getString("reviewactivity.activitystatus");
            for (ReviewActivityAdminOrgTreeInfo actAdminOrgTree : actAdminOrgTreeInfos) {
                if (!actAdminOrgTree.getAdminorgBoId().equals(adminOrgBoId)) continue;
                actAdminOrgTree.setHaveReviewObjec(true);
                actAdminOrgTree.setReviewObjectSum(actAdminOrgTree.getReviewObjectSum() + 1);
            }
        }
        LOG.info("===getActAdminOrgTreeInfo->allAdmOrgLongNumbers===\uff1a,actAdminOrgTreeInfos = {}", (Object)SerializationUtils.toJsonString(actAdminOrgTreeInfos));
        return actAdminOrgTreeInfos;
    }

    public static List<Long> reviewObjsAdminOrgBoIds(Long reviewActivityId, DynamicObject[] reviewObjs) {
        ArrayList<Long> adminOrgBoIds = new ArrayList<Long>(reviewObjs.length);
        for (DynamicObject reviewObj : reviewObjs) {
            Long adminOrgBoid;
            DynamicObject adminOrg;
            if (reviewObj.getDynamicObject("reviewactivity").getLong("id") != reviewActivityId.longValue() || (adminOrg = reviewObj.getDynamicObject("adminorg")) == null || adminOrgBoIds.contains(adminOrgBoid = Long.valueOf(adminOrg.getLong("boid")))) continue;
            adminOrgBoIds.add(adminOrgBoid);
        }
        return adminOrgBoIds;
    }

    public static List<String> getAdmOrgLongNumber(List<Long> revObjsAdmOrgBoIds) {
        ArrayList<String> admOrgLongNumbers = new ArrayList<String>(revObjsAdmOrgBoIds.size());
        DynamicObject[] adminstructInfos = AdminOrgQueryService.getAdminstructInfos(revObjsAdmOrgBoIds);
        if (adminstructInfos != null) {
            for (DynamicObject adminstruct : adminstructInfos) {
                admOrgLongNumbers.add(adminstruct.getString("structlongnumber"));
            }
        }
        return admOrgLongNumbers;
    }

    public static List<String> getAllAdmOrgNumber(List<String> admOrgLongNumbers) {
        ArrayList<String> allAdmOrgNumber = new ArrayList<String>(admOrgLongNumbers.size());
        for (String admOrgLongNumber : admOrgLongNumbers) {
            String[] numbers;
            for (String number : numbers = admOrgLongNumber.split("!")) {
                if (allAdmOrgNumber.contains(number)) continue;
                allAdmOrgNumber.add(number);
            }
        }
        return allAdmOrgNumber;
    }

    public void updateReviewActivityPersonNum(long activityId, int personNum) {
        DynamicObject activityObj = REVIEW_ACTIVITY_HELPER.queryOne("reviewpernum", (Object)activityId);
        if (!HRObjectUtils.isEmpty((Object)activityObj)) {
            int reviewPerNum = activityObj.getInt("reviewpernum");
            if (reviewPerNum == personNum) {
                return;
            }
            activityObj.set("reviewpernum", (Object)personNum);
            REVIEW_ACTIVITY_HELPER.saveOne(activityObj);
        }
    }
}

