/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.domain.activity;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ReviewBusinessDataListService {
    private static final HRBaseServiceHelper REPOSITORY = new HRBaseServiceHelper("oatr_businessdatalist");

    public void generateData(long userId, long activityId) {
        try (TXHandle txHandle = TX.required((String)"ReviewBusinessDataListService");){
            try {
                if (!this.haveBusinessData(Collections.singletonList(userId), activityId)) {
                    DynamicObject dynamicObject = REPOSITORY.generateEmptyDynamicObject();
                    dynamicObject.set("user", (Object)userId);
                    dynamicObject.set("reviewactivity", (Object)activityId);
                    REPOSITORY.saveOne(dynamicObject);
                }
            }
            catch (Exception exception) {
                txHandle.markRollback();
            }
        }
    }

    public boolean haveBusinessData(List<Long> userIdList, long activityId) {
        try (TXHandle txHandle = TX.required((String)"ReviewBusinessDataListService.haveBusinessData");){
            QFilter qFilter = new QFilter("user", "in", userIdList);
            qFilter.and(new QFilter("reviewactivity", "=", (Object)activityId));
            boolean bl = QueryServiceHelper.exists((String)REPOSITORY.getEntityName(), (QFilter[])qFilter.toArray());
            return bl;
        }
    }
}

