/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.domain.activity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.common.bo.gridtemplate.GridBlockInfo;
import kd.tdc.oatr.common.bo.talentmap.AxisInfo;
import kd.tdc.oatr.common.bo.talentmap.TalentMapConfigInfo;
import kd.tdc.oatr.common.constants.enums.MapAxisValueTypeEnum;
import kd.tdc.oatr.common.constants.enums.MapRangeEnum;
import kd.tdc.oatr.common.constants.enums.MapValidateResultCode;

public class ReviewTalentMapService {
    private static final String KEY_TALENT_MAP_INFO = "talentMapInfo";
    private static final String KEY_X_AXIS_DIM_ID = "xAxisDimId";
    private static final String KEY_Y_AXIS_DIM_ID = "yAxisDimId";
    private static final String KEY_MAP_ID = "mapId";

    public Map<String, Map<Long, String>> getTalentMapGridPosition(Map<String, Map<Long, Object>> personDimensionData, DynamicObject activity) {
        List<Map<String, Object>> talentMapInfo = this.getTalentMapInfo(activity);
        return this.matchMapGridPositionInfo(personDimensionData, talentMapInfo);
    }

    public Map<String, Map<Long, Map<String, Object>>> validateDimensionData(Map<String, Map<Long, Object>> personDimensionData, DynamicObject activity) {
        List<Map<String, Object>> talentMapInfo = this.getTalentMapInfo(activity);
        return this.validateDimensionFormat(personDimensionData, talentMapInfo);
    }

    private Map<String, Map<Long, Map<String, Object>>> validateDimensionFormat(Map<String, Map<Long, Object>> personDimensionData, List<Map<String, Object>> talentMapInfo) {
        HashMap validateResult = Maps.newHashMapWithExpectedSize((int)personDimensionData.size());
        for (Map.Entry<String, Map<Long, Object>> personDimEntry : personDimensionData.entrySet()) {
            String reviewObjKey = personDimEntry.getKey();
            Map<Long, Object> dimDataMap = personDimEntry.getValue();
            HashMap mapValidateInfo = Maps.newHashMapWithExpectedSize((int)talentMapInfo.size());
            for (Map<String, Object> mapInfo : talentMapInfo) {
                HashMap dimValidateInfo = Maps.newHashMapWithExpectedSize((int)10);
                TalentMapConfigInfo mapConfigInfo = (TalentMapConfigInfo)mapInfo.get(KEY_TALENT_MAP_INFO);
                long xAxisDimId = (Long)mapInfo.get(KEY_X_AXIS_DIM_ID);
                Object xAxisDimData = dimDataMap.get(xAxisDimId);
                AxisInfo axisInfo = mapConfigInfo.getxAxisInfo();
                String validateResultCode = this.validateDimensionEffective(xAxisDimData, axisInfo);
                dimValidateInfo.put("xDimId", xAxisDimId);
                dimValidateInfo.put("xDimValueType", axisInfo.getValueType().getType());
                dimValidateInfo.put("xDimValidSuccess", MapValidateResultCode.SUCCESS.getCode().equals(validateResultCode));
                dimValidateInfo.put("xDimResultCode", validateResultCode);
                long yAxisDimId = (Long)mapInfo.get(KEY_Y_AXIS_DIM_ID);
                Object yAxisDimData = dimDataMap.get(yAxisDimId);
                axisInfo = mapConfigInfo.getyAxisInfo();
                validateResultCode = this.validateDimensionEffective(yAxisDimData, axisInfo);
                dimValidateInfo.put("yDimId", yAxisDimId);
                dimValidateInfo.put("yDimValueType", axisInfo.getValueType().getType());
                dimValidateInfo.put("yDimValidSuccess", MapValidateResultCode.SUCCESS.getCode().equals(validateResultCode));
                dimValidateInfo.put("yDimResultCode", validateResultCode);
                long mapId = (Long)mapInfo.get(KEY_MAP_ID);
                mapValidateInfo.put(mapId, dimValidateInfo);
            }
            validateResult.put(reviewObjKey, mapValidateInfo);
        }
        return validateResult;
    }

    private String validateDimensionEffective(Object dimValueData, AxisInfo axisInfo) {
        String validCode;
        String result = MapValidateResultCode.SUCCESS.getCode();
        if (dimValueData == null || HRStringUtils.isEmpty((String)dimValueData.toString())) {
            return MapValidateResultCode.EMPTY.getCode();
        }
        String type = axisInfo.getValueType().getType();
        if (type.equals(MapAxisValueTypeEnum.SCORE.getValue()) && HRStringUtils.isNotEmpty((String)(validCode = this.validScoreDimension(dimValueData, axisInfo)))) {
            return validCode;
        }
        if (type.equals(MapAxisValueTypeEnum.PERCENT.getValue()) && HRStringUtils.isNotEmpty((String)(validCode = this.validPercentDimension(dimValueData, axisInfo)))) {
            return validCode;
        }
        if (type.equals(MapAxisValueTypeEnum.GRADE.getValue()) && HRStringUtils.isNotEmpty((String)(validCode = this.validGradeDimension(dimValueData, axisInfo)))) {
            return validCode;
        }
        return result;
    }

    private String validGradeDimension(Object dimValueData, AxisInfo axisInfo) {
        String dimValue = dimValueData.toString().trim();
        int valueMaxLength = 100;
        if (dimValue.length() > valueMaxLength) {
            return MapValidateResultCode.OVER_LENGTH.getCode();
        }
        String[] values = axisInfo.getDivideScale().getValues();
        if (Arrays.asList(values).contains("")) {
            return MapValidateResultCode.OVER_RANGE.getCode();
        }
        boolean isMatch = false;
        for (String value : values) {
            if (!value.contains(",")) {
                if (!value.equals(dimValue)) continue;
                isMatch = true;
                break;
            }
            String[] mulValues = value.split(",");
            if (!Arrays.asList(mulValues).contains(dimValue)) continue;
            isMatch = true;
            break;
        }
        if (!isMatch) {
            return MapValidateResultCode.OVER_RANGE.getCode();
        }
        return "";
    }

    private String validPercentDimension(Object dimValueData, AxisInfo axisInfo) {
        String dimPercentValue;
        boolean isNumericStr;
        String dimValueStr = dimValueData.toString().trim();
        if (dimValueStr.contains("%")) {
            if (dimValueStr.indexOf("%") != dimValueStr.length() - 1) {
                return MapValidateResultCode.NOT_PERCENTAGE.getCode();
            }
        } else {
            boolean isNumericStr2 = StringUtils.isNumeric((String)dimValueStr);
            if (!isNumericStr2) {
                return MapValidateResultCode.NOT_PERCENTAGE.getCode();
            }
            NumberFormat numberFormat = NumberFormat.getPercentInstance();
            int scaleNum = 0;
            if (dimValueStr.contains(".")) {
                scaleNum = dimValueStr.substring(dimValueStr.indexOf(".")).length() - 3;
            }
            numberFormat.setGroupingUsed(false);
            numberFormat.setMaximumFractionDigits(scaleNum);
            dimValueStr = numberFormat.format(Double.parseDouble(dimValueStr));
        }
        if (!(isNumericStr = StringUtils.isNumeric((String)(dimPercentValue = dimValueStr.replace("%", ""))))) {
            return MapValidateResultCode.NOT_PERCENTAGE.getCode();
        }
        String valueOnlyNumStr = dimPercentValue.replace(".", "");
        if (valueOnlyNumStr.length() > 23) {
            return MapValidateResultCode.OVER_LENGTH.getCode();
        }
        String[] splitNumber = dimPercentValue.split("\\.");
        if (splitNumber.length == 2 && splitNumber[1].length() > 2) {
            return MapValidateResultCode.OVER_SCALE.getCode();
        }
        double dimValue = Double.parseDouble(dimPercentValue);
        String range = axisInfo.getDivideScale().getRange();
        String[] values = axisInfo.getDivideScale().getValues();
        if (Arrays.asList(values).contains("")) {
            return MapValidateResultCode.OVER_RANGE.getCode();
        }
        double scaleLeftValue = 0.0;
        double scaleRightValue = Double.parseDouble(values[values.length - 1].replace("%", ""));
        if (range.equals(MapRangeEnum.LEFT.getValue()) && (dimValue < scaleLeftValue || dimValue >= scaleRightValue)) {
            return MapValidateResultCode.OVER_RANGE.getCode();
        }
        if (range.equals(MapRangeEnum.RIGHT.getValue()) && (dimValue <= scaleLeftValue || dimValue > scaleRightValue)) {
            return MapValidateResultCode.OVER_RANGE.getCode();
        }
        return "";
    }

    private String validScoreDimension(Object dimValueData, AxisInfo axisInfo) {
        String valueOnlyNumStr;
        String dimValueStr = dimValueData.toString().trim();
        if (dimValueStr.contains("%") && dimValueStr.indexOf("%") == dimValueStr.length() - 1) {
            NumberFormat numberFormat = NumberFormat.getPercentInstance();
            numberFormat.setGroupingUsed(false);
            try {
                Number number = numberFormat.parse(dimValueStr);
                int scaleNum = 2;
                if (dimValueStr.contains(".")) {
                    scaleNum = dimValueStr.substring(dimValueStr.indexOf("."), dimValueStr.indexOf("%")).length() + 1;
                }
                double dimValue = BigDecimal.valueOf(number.doubleValue()).setScale(scaleNum, RoundingMode.HALF_UP).doubleValue();
                dimValueStr = String.valueOf(dimValue);
            }
            catch (ParseException exp) {
                return MapValidateResultCode.NOT_NUMERIC.getCode();
            }
        } else {
            boolean isNumericStr = StringUtils.isNumeric((String)dimValueStr);
            if (!isNumericStr) {
                return MapValidateResultCode.NOT_NUMERIC.getCode();
            }
        }
        if ((valueOnlyNumStr = dimValueStr.replace(".", "")).length() > 23) {
            return MapValidateResultCode.OVER_LENGTH.getCode();
        }
        String[] splitNumber = dimValueStr.split("\\.");
        if (splitNumber.length == 2 && splitNumber[1].length() > 4) {
            return MapValidateResultCode.OVER_SCALE.getCode();
        }
        double dimValue = Double.parseDouble(dimValueStr);
        String range = axisInfo.getDivideScale().getRange();
        String[] values = axisInfo.getDivideScale().getValues();
        if (Arrays.asList(values).contains("")) {
            return MapValidateResultCode.OVER_RANGE.getCode();
        }
        double scaleLeftValue = 0.0;
        double scaleRightValue = Double.parseDouble(values[values.length - 1]);
        if (range.equals(MapRangeEnum.LEFT.getValue()) && (dimValue < scaleLeftValue || dimValue >= scaleRightValue)) {
            return MapValidateResultCode.OVER_RANGE.getCode();
        }
        if (range.equals(MapRangeEnum.RIGHT.getValue()) && (dimValue <= scaleLeftValue || dimValue > scaleRightValue)) {
            return MapValidateResultCode.OVER_RANGE.getCode();
        }
        return "";
    }

    private Map<String, Map<Long, String>> matchMapGridPositionInfo(Map<String, Map<Long, Object>> personDimensionData, List<Map<String, Object>> talentMapInfo) {
        HashMap gridPositionInfo = Maps.newHashMapWithExpectedSize((int)personDimensionData.size());
        for (Map.Entry<String, Map<Long, Object>> personDimEntry : personDimensionData.entrySet()) {
            String reviewObjKey = personDimEntry.getKey();
            Map<Long, Object> dimDataMap = personDimEntry.getValue();
            HashMap mapPositionInfo = Maps.newHashMapWithExpectedSize((int)talentMapInfo.size());
            for (Map<String, Object> mapInfo : talentMapInfo) {
                long mapId = (Long)mapInfo.get(KEY_MAP_ID);
                String positionName = this.getGridPositionName(dimDataMap, mapInfo);
                mapPositionInfo.put(mapId, positionName);
            }
            gridPositionInfo.put(reviewObjKey, mapPositionInfo);
        }
        return gridPositionInfo;
    }

    private String getGridPositionName(Map<Long, Object> dimDataMap, Map<String, Object> mapInfo) {
        String positionName = "";
        long xAxisDimId = (Long)mapInfo.get(KEY_X_AXIS_DIM_ID);
        long yAxisDimId = (Long)mapInfo.get(KEY_Y_AXIS_DIM_ID);
        if (xAxisDimId == 0L || yAxisDimId == 0L) {
            return positionName;
        }
        TalentMapConfigInfo mapConfigInfo = (TalentMapConfigInfo)mapInfo.get(KEY_TALENT_MAP_INFO);
        AxisInfo axisInfo = mapConfigInfo.getxAxisInfo();
        Object xDimValueObj = dimDataMap.get(xAxisDimId);
        int xValue = this.getAxisValue(xDimValueObj, axisInfo);
        if (xValue == -1) {
            return positionName;
        }
        Object yDimValueObj = dimDataMap.get(yAxisDimId);
        int yValue = this.getAxisValue(yDimValueObj, axisInfo = mapConfigInfo.getyAxisInfo());
        if (yValue == -1) {
            return positionName;
        }
        int xAxisScales = mapConfigInfo.getGridData().getxAxisScales();
        int gridNumber = (yValue - 1) * xAxisScales + xValue;
        String gridNumberStr = String.valueOf(gridNumber);
        List gridBlocks = mapConfigInfo.getGridData().getGridBlocks();
        for (GridBlockInfo gridBlock : gridBlocks) {
            if (!gridBlock.getNumber().equals(gridNumberStr)) continue;
            positionName = gridBlock.getCustomNumber() + "-" + gridBlock.getName().getText();
            break;
        }
        return positionName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getAxisValue(Object dimValueObj, AxisInfo axisInfo) {
        if (dimValueObj == null || HRStringUtils.isEmpty((String)dimValueObj.toString())) {
            return -1;
        }
        String dimValueStr = dimValueObj.toString();
        String type = axisInfo.getValueType().getType();
        if (type.equals(MapAxisValueTypeEnum.SCORE.getValue())) {
            double dimValue;
            boolean isNumericStr = StringUtils.isNumeric((String)dimValueStr);
            if (!isNumericStr) {
                if (!dimValueStr.contains("%")) return -1;
                NumberFormat numberFormat = NumberFormat.getPercentInstance();
                numberFormat.setGroupingUsed(false);
                try {
                    Number number = numberFormat.parse(dimValueStr);
                    int scaleNum = 2;
                    if (dimValueStr.contains(".")) {
                        scaleNum = dimValueStr.substring(dimValueStr.indexOf("."), dimValueStr.indexOf("%")).length() + 1;
                    }
                    dimValue = BigDecimal.valueOf(number.doubleValue()).setScale(scaleNum, RoundingMode.HALF_UP).doubleValue();
                }
                catch (ParseException exp) {
                    return -1;
                }
            } else {
                dimValue = Double.parseDouble(dimValueStr);
            }
            String range = axisInfo.getDivideScale().getRange();
            String[] values = axisInfo.getDivideScale().getValues();
            if (Arrays.asList(values).contains("")) {
                return -1;
            }
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                double scaleValue = Double.parseDouble(value);
                if (!(range.equals(MapRangeEnum.LEFT.getValue()) ? dimValue < scaleValue : range.equals(MapRangeEnum.RIGHT.getValue()) && dimValue <= scaleValue)) continue;
                return i + 1;
            }
            return -1;
        }
        if (type.equals(MapAxisValueTypeEnum.PERCENT.getValue())) {
            double dimValue;
            if (dimValueStr.contains("%")) {
                String dimPercentValue = dimValueStr.replace("%", "");
                boolean isNumericStr = StringUtils.isNumeric((String)dimPercentValue);
                if (!isNumericStr) {
                    return -1;
                }
                dimValue = Double.parseDouble(dimPercentValue);
            } else {
                boolean isNumericStr = StringUtils.isNumeric((String)dimValueStr);
                if (!isNumericStr) {
                    return -1;
                }
                NumberFormat numberFormat = NumberFormat.getPercentInstance();
                int scaleNum = 0;
                if (dimValueStr.contains(".")) {
                    scaleNum = dimValueStr.substring(dimValueStr.indexOf(".")).length() - 3;
                }
                if (scaleNum < 0) {
                    scaleNum = 0;
                }
                numberFormat.setMaximumFractionDigits(scaleNum);
                numberFormat.setGroupingUsed(false);
                String percentStr = numberFormat.format(Double.parseDouble(dimValueStr));
                String dimPercentValue = percentStr.replace("%", "");
                dimValue = Double.parseDouble(dimPercentValue);
            }
            String range = axisInfo.getDivideScale().getRange();
            String[] values = axisInfo.getDivideScale().getValues();
            if (Arrays.asList(values).contains("")) {
                return -1;
            }
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                String percentValue = value.replace("%", "");
                double scaleValue = Double.parseDouble(percentValue);
                if (!(range.equals(MapRangeEnum.LEFT.getValue()) ? dimValue < scaleValue : range.equals(MapRangeEnum.RIGHT.getValue()) && dimValue <= scaleValue)) continue;
                return i + 1;
            }
            return -1;
        }
        if (!type.equals(MapAxisValueTypeEnum.GRADE.getValue())) return -1;
        String[] values = axisInfo.getDivideScale().getValues();
        if (Arrays.asList(values).contains("")) {
            return -1;
        }
        int index = -1;
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (!value.contains(",")) {
                if (!value.equals(dimValueStr)) continue;
                index = i;
                break;
            }
            String[] mulValues = value.split(",");
            if (!Arrays.asList(mulValues).contains(dimValueStr)) continue;
            index = i;
            break;
        }
        if (index != -1) return index + 1;
        return index;
    }

    private List<Map<String, Object>> getTalentMapInfo(DynamicObject activity) {
        DynamicObjectCollection talentMapEntry = activity.getDynamicObjectCollection("talentmapentry");
        ArrayList gridPositionInfoList = Lists.newArrayListWithExpectedSize((int)talentMapEntry.size());
        for (DynamicObject mapInfo : talentMapEntry) {
            long mapId = HRDyObjectPropUtil.getId((DynamicObject)mapInfo);
            long xAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)mapInfo.getDynamicObject("xaxisdim"));
            long yAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)mapInfo.getDynamicObject("yaxisdim"));
            String mapConfigData = mapInfo.getString("talentmapconfig_tag");
            if (HRStringUtils.isEmpty((String)mapConfigData)) continue;
            TalentMapConfigInfo mapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)mapConfigData, TalentMapConfigInfo.class);
            HashMap mapPositionInfoMap = Maps.newHashMapWithExpectedSize((int)10);
            mapPositionInfoMap.put(KEY_MAP_ID, mapId);
            mapPositionInfoMap.put(KEY_X_AXIS_DIM_ID, xAxisDimId);
            mapPositionInfoMap.put(KEY_Y_AXIS_DIM_ID, yAxisDimId);
            mapPositionInfoMap.put(KEY_TALENT_MAP_INFO, mapConfigInfo);
            gridPositionInfoList.add(mapPositionInfoMap);
        }
        return gridPositionInfoList;
    }

    public Map<String, String> getTalentMapNameInfo(DynamicObject activity) {
        DynamicObjectCollection talentMapEntry = activity.getDynamicObjectCollection("talentmapentry");
        HashMap talentMapNameMap = Maps.newHashMapWithExpectedSize((int)talentMapEntry.size());
        for (DynamicObject mapInfo : talentMapEntry) {
            long mapId = HRDyObjectPropUtil.getId((DynamicObject)mapInfo);
            String xAxisDimName = HRDyObjectPropUtil.getName((DynamicObject)mapInfo.getDynamicObject("xaxisdim"));
            String yAxisDimName = HRDyObjectPropUtil.getName((DynamicObject)mapInfo.getDynamicObject("yaxisdim"));
            if (HRStringUtils.isEmpty((String)xAxisDimName) || HRStringUtils.isEmpty((String)yAxisDimName)) continue;
            talentMapNameMap.put(String.valueOf(mapId), xAxisDimName + "+" + yAxisDimName);
        }
        return talentMapNameMap;
    }
}

