/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.domain.activitytpl;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ReviewActivityTemplateService {
    private static final HRBaseServiceHelper BASE_SERVICE_HELPER = new HRBaseServiceHelper("oatr_reviewactivitytpl");
    private static final Log LOG = LogFactory.getLog(ReviewActivityTemplateService.class);

    public void save(DynamicObject[] objects) {
        BASE_SERVICE_HELPER.save(objects);
    }

    public DynamicObject getReviewActivityTemplate(Object activityId) {
        return BASE_SERVICE_HELPER.queryOne("id,perscopefilter_tag,personscopectlstg,contentchangetime", new QFilter[]{new QFilter("id", "=", activityId)});
    }

    public void updateTemplateActivityNumOfRef(Map<DynamicObject, Integer> updateActivityNumOfRef) {
        updateActivityNumOfRef.forEach((dynamicObject, updateNum) -> {
            Object pkValue = dynamicObject.getPkValue();
            String lockKey = String.valueOf(pkValue);
            DLock dLock = DLock.create((String)lockKey, (String)"review activity template num of ref update");
            if (!dLock.tryLock(10000L)) {
                dLock.unlock();
                dLock.close();
                throw new KDBizException("save review activity fail");
            }
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    DynamicObject curObj = BASE_SERVICE_HELPER.queryOne(dynamicObject.getPkValue());
                    int activityNumOfRef = curObj.getInt("actusednum");
                    curObj.set("actusednum", (Object)(activityNumOfRef + updateNum));
                    BASE_SERVICE_HELPER.saveOne(curObj);
                }
                catch (Exception exception) {
                    txHandle.markRollback();
                    throw exception;
                }
            }
            catch (Exception exception) {
                throw new KDBizException((Throwable)exception, new ErrorCode("", "save review activity fail"), new Object[0]);
            }
            finally {
                dLock.unlock();
                dLock.close();
            }
        });
    }
}

