/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.domain.calibrate;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;

public class CalibrateSessionService {
    private static final Log LOG = LogFactory.getLog(CalibrateSessionService.class);
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("oatr_calibratesession");

    public void saveCalibrateSession(DynamicObject[] listCalibrateSession) {
        if (HRArrayUtils.isEmpty((Object[])listCalibrateSession)) {
            return;
        }
        SERVICE_HELPER.save(listCalibrateSession);
    }

    public DynamicObject getCalibrateSession(Object id) {
        return SERVICE_HELPER.queryOriginalOne("calibratestatus,reviewactivity.id,talentmap", new QFilter("id", "=", id));
    }

    public DynamicObject[] listCalibrateSessionByActivityId(long activityId, List<Long> dbTalentMapEntryId) {
        QFilter statusFilter = new QFilter("reviewactivity", "=", (Object)activityId);
        QFilter activityFilter = new QFilter("calibratestatus", "=", (Object)CalibrateSessionStatusEnum.WAIT_START.getCode());
        List stringTalentMapIds = dbTalentMapEntryId.stream().map(String::valueOf).collect(Collectors.toList());
        QFilter talentMap = new QFilter("talentmap", "in", stringTalentMapIds);
        return SERVICE_HELPER.query("calibratestatus,talentmap", new QFilter[]{statusFilter, activityFilter, talentMap});
    }

    public DynamicObject[] listCalibrateSessionById(Collection<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        return SERVICE_HELPER.query("id,calibratepersonnum", new QFilter[]{idFilter});
    }

    public void save(DynamicObject[] dynamicObjects) {
        SERVICE_HELPER.save(dynamicObjects);
    }

    public Map<String, String> getSessionTalentMapName(Long activityId) {
        LOG.info("CalibrateSessionService.getSessionTalentMapName: the param activityId is {}", (Object)activityId);
        QFilter activityFilter = new QFilter("reviewactivity", "=", (Object)activityId);
        String[] status = new String[]{CalibrateSessionStatusEnum.GOING.getCode(), CalibrateSessionStatusEnum.END.getCode()};
        QFilter statusFilter = new QFilter("calibratestatus", "in", Arrays.asList(status));
        DynamicObject[] calibrateSessions = SERVICE_HELPER.query("talentmap,calibratestatus,xaxisdim,yaxisdim", new QFilter[]{statusFilter, activityFilter});
        HashMap talentMapNameMap = Maps.newHashMapWithExpectedSize((int)calibrateSessions.length);
        for (DynamicObject calibrateSession : calibrateSessions) {
            String talentMapId = calibrateSession.getString("talentmap");
            if (HRStringUtils.isEmpty((String)talentMapId)) continue;
            String xAxisDimName = HRDyObjectPropUtil.getName((DynamicObject)calibrateSession.getDynamicObject("xaxisdim"));
            String yAxisDimName = HRDyObjectPropUtil.getName((DynamicObject)calibrateSession.getDynamicObject("yaxisdim"));
            if (!HRStringUtils.isNotEmpty((String)xAxisDimName) || !HRStringUtils.isNotEmpty((String)yAxisDimName)) continue;
            String mapName = MessageFormat.format("{0}+{1}", xAxisDimName, yAxisDimName);
            long sessionId = calibrateSession.getLong("id");
            talentMapNameMap.put(String.valueOf(sessionId), mapName);
        }
        LOG.info("CalibrateSessionService.getSessionTalentMapName: the result is {}", (Object)talentMapNameMap);
        return talentMapNameMap;
    }

    public String beginCalibrate(Long sessionId, DynamicObject talentMapConfig) {
        if (HRObjectUtils.isEmpty((Object)talentMapConfig)) {
            LOG.error("CalibrateSessionService.beginCalibrate: param sessionId is {}, talent map is empty", (Object)sessionId);
            return "talentMapEmpty";
        }
        DynamicObjectCollection talentMapEntry = talentMapConfig.getDynamicObjectCollection("talentmapentry");
        if (talentMapEntry.isEmpty()) {
            LOG.error("CalibrateSessionService.beginCalibrate: param sessionId is {}, talent map is empty", (Object)sessionId);
            return "talentMapEmpty";
        }
        DynamicObject mapEntry = (DynamicObject)talentMapEntry.get(0);
        String mapConfigData = mapEntry.getString("talentmapconfig_tag");
        Long xAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)mapEntry.getDynamicObject("xaxisdim"));
        Long yAxisDimId = HRDyObjectPropUtil.getId((DynamicObject)mapEntry.getDynamicObject("yaxisdim"));
        DynamicObjectCollection perCardDims = mapEntry.getDynamicObjectCollection("percarddim");
        List perCardDimIds = perCardDims.stream().map(dim -> dim.getLong("fbasedataid_id")).collect(Collectors.toList());
        DynamicObject calibrateSession = SERVICE_HELPER.queryOne("calibratestatus,xaxisdim,yaxisdim,percarddim,talentmapconfig_tag,modifier,modifytime", (Object)sessionId);
        String calibrateStatus = calibrateSession.getString("calibratestatus");
        if (HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.WAIT_START.getCode())) {
            long currUserId = RequestContext.get().getCurrUserId();
            Date now = new Date();
            calibrateSession.set("modifier", (Object)currUserId);
            calibrateSession.set("modifytime", (Object)now);
            calibrateSession.set("calibratestatus", (Object)CalibrateSessionStatusEnum.GOING.getCode());
            calibrateSession.set("xaxisdim", (Object)xAxisDimId);
            calibrateSession.set("yaxisdim", (Object)yAxisDimId);
            DynamicObjectCollection perCardDim = calibrateSession.getDynamicObjectCollection("percarddim");
            for (Long perCardDimId : perCardDimIds) {
                DynamicObject perCardDimObj = perCardDim.addNew();
                perCardDimObj.set("fbasedataid", (Object)perCardDimId);
            }
            calibrateSession.set("talentmapconfig_tag", (Object)mapConfigData);
            SERVICE_HELPER.saveOne(calibrateSession);
            LOG.info("CalibrateSessionService.beginCalibrate: sessionId is {}, beginCalibrate success", (Object)sessionId);
            return "success";
        }
        return "fail";
    }

    public void finishCalibrate(Long sessionId) {
        DynamicObject calibrateSession = SERVICE_HELPER.queryOne("calibratestatus,modifier,modifytime", (Object)sessionId);
        String calibrateStatus = calibrateSession.getString("calibratestatus");
        if (HRStringUtils.equals((String)calibrateStatus, (String)CalibrateSessionStatusEnum.GOING.getCode())) {
            long currUserId = RequestContext.get().getCurrUserId();
            Date now = new Date();
            calibrateSession.set("modifier", (Object)currUserId);
            calibrateSession.set("modifytime", (Object)now);
            calibrateSession.set("calibratestatus", (Object)CalibrateSessionStatusEnum.END.getCode());
            SERVICE_HELPER.saveOne(calibrateSession);
            LOG.info("CalibrateSessionService.beginCalibrate: sessionId is {}, finishCalibrate success", (Object)sessionId);
        }
    }
}

