/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.domain.calibrate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class OnlineCalibrationDomainService {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("oatr_onlinecalibration");

    public DynamicObject[] listOnlineCalibrationData(Long calibrateSessionId) {
        QFilter sessionIdFilter = new QFilter("calibratesession", "=", (Object)calibrateSessionId);
        return SERVICE_HELPER.query("id,person,calibrateresult,calibratereason,calibratebefore,reviewactivity,reviewobject,calibratesession", new QFilter[]{sessionIdFilter});
    }

    public void finishCalibrate(List<DynamicObject> calibrateObjs) {
        Date now = new Date();
        for (DynamicObject onlineCalibration : calibrateObjs) {
            String calibrateResult = onlineCalibration.getString("calibrateresult");
            if (HRStringUtils.isNotEmpty((String)calibrateResult)) continue;
            String calibrateBefore = onlineCalibration.getString("calibratebefore");
            onlineCalibration.set("calibrateresult", (Object)calibrateBefore);
            long currUserId = RequestContext.get().getCurrUserId();
            onlineCalibration.set("modifier", (Object)currUserId);
            onlineCalibration.set("modifytime", (Object)now);
        }
        if (!calibrateObjs.isEmpty()) {
            SERVICE_HELPER.update(calibrateObjs.toArray(new DynamicObject[0]));
        }
    }

    public DynamicObject[] queryOnlineCalibrateInfo(String props, QFilter[] filters) {
        return SERVICE_HELPER.query(props, filters);
    }

    public void updateOnlineCalibrateInfo(DynamicObject[] calibrateObjs) {
        SERVICE_HELPER.update(calibrateObjs);
    }

    public void deleteByCalibrateSessionId(long calibrateSessionId) {
        QFilter sessionFilter = new QFilter("calibratesession.id", "=", (Object)calibrateSessionId);
        SERVICE_HELPER.deleteByFilter(new QFilter[]{sessionFilter});
    }

    public void generateOnlineCalibration(long activityId, long calibrateSessionId, List<Long> reviewObjIds, DynamicObject[] reviewObjectData, String talentMapId) {
        QFilter sessionFilter = new QFilter("calibratesession.id", "=", (Object)calibrateSessionId);
        DynamicObject[] calibrations = SERVICE_HELPER.query("person,reviewobject,calibratesession,calibratesession.talentmap", new QFilter[]{sessionFilter});
        Map<Long, String> calibrateResultMap = this.getCalibrateResultBefore(reviewObjectData, talentMapId);
        List hasSaveReviewObjIds = Arrays.stream(calibrations).map(calibration -> calibration.getLong("reviewobject.id")).collect(Collectors.toList());
        ArrayList onlineCalibration = Lists.newArrayList();
        for (DynamicObject reviewObjectDatum : reviewObjectData) {
            long reviewObjId = reviewObjectDatum.getLong("id");
            if (hasSaveReviewObjIds.contains(reviewObjId)) continue;
            DynamicObject onlineCalObj = SERVICE_HELPER.generateEmptyDynamicObject();
            onlineCalObj.set("person", (Object)reviewObjectDatum.getLong("personboid"));
            onlineCalObj.set("employee", (Object)reviewObjectDatum.getLong("talentfile.employee.id"));
            onlineCalObj.set("calibratesession", (Object)calibrateSessionId);
            onlineCalObj.set("reviewobject", (Object)HRDyObjectPropUtil.getId((DynamicObject)reviewObjectDatum));
            onlineCalObj.set("reviewactivity", (Object)activityId);
            long currUserId = RequestContext.get().getCurrUserId();
            Date now = new Date();
            onlineCalObj.set("creator", (Object)currUserId);
            onlineCalObj.set("createtime", (Object)now);
            onlineCalObj.set("modifier", (Object)currUserId);
            onlineCalObj.set("modifytime", (Object)now);
            String calibrateResult = calibrateResultMap.get(reviewObjId);
            if (HRStringUtils.isNotEmpty((String)calibrateResult)) {
                onlineCalObj.set("calibratebefore", (Object)calibrateResult);
            }
            onlineCalibration.add(onlineCalObj);
        }
        SERVICE_HELPER.save(onlineCalibration.toArray(new DynamicObject[0]));
        hasSaveReviewObjIds.removeAll(reviewObjIds);
        QFilter qFilter = new QFilter("reviewobject.id", "in", hasSaveReviewObjIds);
        SERVICE_HELPER.deleteByFilter(new QFilter[]{sessionFilter, qFilter});
    }

    public Map<Long, String> getCalibrateResultBefore(DynamicObject[] reviewObjectData, String talentMapKey) {
        return Arrays.stream(reviewObjectData).collect(Collectors.toMap(reviewObject -> reviewObject.getLong("id"), reviewObject -> {
            Optional<DynamicObject> mapBeforeObj;
            Optional<DynamicObject> mapBeforeObj2;
            DynamicObjectCollection entryEntityMap = reviewObject.getDynamicObjectCollection("entryentity_map");
            if (CollectionUtils.isNotEmpty((Collection)entryEntityMap) && (mapBeforeObj2 = entryEntityMap.stream().filter(map -> HRStringUtils.equals((String)talentMapKey, (String)map.getString("mapkey"))).findFirst()).isPresent()) {
                return mapBeforeObj2.get().getString("mapvalue");
            }
            DynamicObjectCollection entryEntityMapBefore = reviewObject.getDynamicObjectCollection("entryentity_mapbefore");
            if (CollectionUtils.isNotEmpty((Collection)entryEntityMapBefore) && (mapBeforeObj = entryEntityMapBefore.stream().filter(mapBefore -> HRStringUtils.equals((String)talentMapKey, (String)mapBefore.getString("mapbeforekey"))).findFirst()).isPresent()) {
                return mapBeforeObj.get().getString("mapbeforevalue");
            }
            return "";
        }));
    }

    public DynamicObject[] queryReviewByCalibration(long calibrationSessionId) {
        QFilter calibrationFilter = new QFilter("calibratesession.id", "=", (Object)calibrationSessionId);
        return SERVICE_HELPER.query("reviewobject.id,person.headsculpture", new QFilter[]{calibrationFilter});
    }

    public void updateOnlineCalibrateResultBefore(List<DynamicObject> onlineCalibrationData, String talentMap, DynamicObject[] reviewObjectData) {
        Map<Long, String> reviewMapBeforeValueMap = this.getCalibrateResultBefore(reviewObjectData, talentMap);
        for (DynamicObject onlineCalibration : onlineCalibrationData) {
            long reviewObjId = onlineCalibration.getLong("reviewobject.id");
            onlineCalibration.set("calibratebefore", (Object)reviewMapBeforeValueMap.get(reviewObjId));
        }
        if (!onlineCalibrationData.isEmpty()) {
            SERVICE_HELPER.update(onlineCalibrationData.toArray(new DynamicObject[0]));
        }
    }

    public DynamicObject[] getOnlineCalibrationDataByReviewObjIds(long activityId, List<Long> reviewObjIds) {
        QFilter activityFilter = new QFilter("reviewactivity", "=", (Object)activityId);
        QFilter objFilter = new QFilter("reviewobject.id", "in", reviewObjIds);
        return SERVICE_HELPER.queryOriginalArray("id,calibratesession,reviewobject", new QFilter[]{activityFilter, objFilter});
    }

    public DynamicObject[] getOnlineCalibration(List<Long> ids) {
        QFilter idFilter = new QFilter("calibratesession.id", "in", ids);
        return SERVICE_HELPER.queryOriginalArray("id,calibratesession,reviewobject", new QFilter[]{idFilter});
    }
}

