/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.domain.collaborator.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ext.BosMessageService;
import kd.tdc.oatr.bussiness.domain.collaborator.ReviewCollaboratorService;
import kd.tdc.oatr.bussiness.domain.reviewgroup.ReviewGroupService;
import kd.tdc.oatr.bussiness.domain.vid.UpdateVidDto;
import kd.tdc.oatr.bussiness.domain.vid.VidPropType;
import kd.tdc.oatr.bussiness.domain.vid.service.UpdateHistoryVidService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReviewCollaboratorServiceImpl
implements ReviewCollaboratorService {
    private static final Log LOG = LogFactory.getLog(ReviewCollaboratorServiceImpl.class);
    private static final ReviewGroupService reviewGroupService = ServiceFactory.getService(ReviewGroupService.class);
    private static final HRBaseServiceHelper REPOSITORY = new HRBaseServiceHelper("oatr_reviewgroup");
    private static final Map<VidPropType, List<String>> PROP_MAPPING = Maps.newHashMapWithExpectedSize((int)4);

    @Override
    public void personInfoSnapshot(DynamicObject[] reviewActivityDOArr) {
        if (reviewActivityDOArr == null || reviewActivityDOArr.length == 0) {
            return;
        }
        List activityIdList = Arrays.stream(reviewActivityDOArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        QFilter idQF = new QFilter("reviewactivity", "in", activityIdList);
        DynamicObject[] dynamicObjects = REPOSITORY.query("entryentity,adminorg,position,std_position,job", new QFilter[]{idQF});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        UpdateVidDto updateVidDto = new UpdateVidDto();
        updateVidDto.setDynamicObjectList(Arrays.stream(dynamicObjects).map(dy -> dy.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).collect(Collectors.toList()));
        updateVidDto.setPropMapping(PROP_MAPPING);
        UpdateHistoryVidService.getInstance().updateHistoryVid(updateVidDto);
        REPOSITORY.save(dynamicObjects);
    }

    private long getPropId(DynamicObject dynamicObject, String prop) {
        Object o = dynamicObject.get(prop);
        if (o instanceof DynamicObject) {
            return ((DynamicObject)o).getLong("id");
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        return 0L;
    }

    @Override
    public void fillWorkInfo(DynamicObjectCollection reviewCollaboratorDOCol) {
        if (CollectionUtils.isEmpty((Collection)reviewCollaboratorDOCol)) {
            return;
        }
        List userIdList = reviewCollaboratorDOCol.stream().filter(dy -> !dy.getDataEntityState().getFromDatabase()).map(dy -> this.getPropId((DynamicObject)dy, "collaborator")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userIdList)) {
            return;
        }
        Map personInfoResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"queryPersonInfoByUserIds", (Object[])new Object[]{userIdList});
        if (CollectionUtils.isEmpty((Map)personInfoResult) || !((Boolean)personInfoResult.get("success")).booleanValue()) {
            LOG.warn("no hrpiPersonId,userId: {}", userIdList);
            return;
        }
        Map personData = (Map)personInfoResult.get("data");
        HashMap<Long, Long> userId2PersonId = new HashMap<Long, Long>(personData.size());
        personData.forEach((userId, personInfo) -> userId2PersonId.put((Long)userId, (Long)personInfo.get("person")));
        LOG.info("user-hrpiPersonId, userId2PersonId: {}", userId2PersonId);
        Map erManFileMap = (Map)HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"listPrimaryErmanFile", (Object[])new Object[]{Lists.newArrayList(userId2PersonId.values())});
        HashMap person2ErManFileMap = Maps.newHashMapWithExpectedSize((int)erManFileMap.size());
        erManFileMap.forEach((personId, erManFile) -> person2ErManFileMap.put(personId, erManFile.getLong("id")));
        if (CollectionUtils.isEmpty((Map)erManFileMap)) {
            LOG.warn("no erManFile,userId2PersonId: {}", userId2PersonId);
            return;
        }
        LOG.info("person2ermanfileMap:{}", (Object)person2ErManFileMap);
        List cardFields = (List)HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{Lists.newArrayList(person2ErManFileMap.values())});
        if (CollectionUtils.isEmpty((Collection)cardFields)) {
            LOG.warn("no cardFields,userId2PersonId: {}", userId2PersonId);
            return;
        }
        userId2PersonId.forEach((userId, personId) -> {
            for (Map cardField : cardFields) {
                LOG.info("fillWorkInfo mapping userId2PersonId:{},{}", userId, cardField.get("person_id"));
                if (personId.longValue() != ((Long)cardField.get("person_id")).longValue()) continue;
                reviewCollaboratorDOCol.stream().filter(dy -> userId.longValue() == this.getPropId((DynamicObject)dy, "collaborator")).findFirst().ifPresent(dy -> {
                    this.setValueSkipNotNull((DynamicObject)dy, "position", cardField.get("position_id"));
                    this.setValueSkipNotNull((DynamicObject)dy, "job", cardField.get("job_id"));
                    this.setValueSkipNotNull((DynamicObject)dy, "adminorg", cardField.get("adminorg_id"));
                    this.setValueSkipNotNull((DynamicObject)dy, "std_position", cardField.get("stdposition_id"));
                });
            }
        });
    }

    private void setValueSkipNotNull(DynamicObject dynamicObject, String prop, Object value) {
        if (Objects.isNull(value)) {
            return;
        }
        if (Objects.isNull(dynamicObject.get(prop))) {
            dynamicObject.set(prop, value);
        }
    }

    @Override
    public void updateActivityCollaboratorNum(long activityId) {
        block28: {
            if (activityId == 0L) {
                return;
            }
            HRBaseServiceHelper activityHelper = new HRBaseServiceHelper("oatr_reviewactivity");
            try (DLock lock = DLock.create((String)("updateCollaboratorNum_" + activityId));
                 TXHandle txHandle = TX.required((String)"updateActivityCollaboratorNum");){
                try {
                    if (lock.tryLock(10000L)) {
                        DynamicObject[] dynamicObjects = REPOSITORY.queryOriginalArray("entryentity.collaborator,entryentity.colstatus", new QFilter("reviewactivity", "=", (Object)activityId).toArray());
                        long number = Arrays.stream(dynamicObjects).filter(dynamicObject -> HRStringUtils.equals((String)"1", (String)dynamicObject.getString("entryentity.colstatus"))).map(dy -> dy.getLong("entryentity.collaborator")).distinct().count();
                        DynamicObject reviewActivity = activityHelper.queryOne("collaboratornum", new QFilter("id", "=", (Object)activityId));
                        reviewActivity.set("collaboratornum", (Object)number);
                        activityHelper.saveOne(reviewActivity);
                        break block28;
                    }
                    throw new KDBizException("save error\uff01");
                }
                catch (Exception exception) {
                    txHandle.markRollback();
                    LOG.error("updateActivityCollaboratorNum error: ", (Throwable)exception);
                    throw exception;
                }
            }
        }
    }

    @Override
    public void sendMsgNotifyCollaborator(DynamicObject[] newReviewGroupObjs, DynamicObject[] oldReviewGroupObjs) {
        Map<Long, Map<Long, String>> newCollaborateMap = Arrays.stream(newReviewGroupObjs).collect(Collectors.toMap(reviewGroupObj -> reviewGroupObj.getLong("id"), reviewGroupObj -> reviewGroupObj.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(entry -> entry.getLong("collaborator.id"), entry -> entry.getString("colstatus"), (v1, v2) -> v1)), (v1, v2) -> v1));
        Map<Long, Map<Long, String>> oldCollaborateMap = Arrays.stream(oldReviewGroupObjs).collect(Collectors.toMap(reviewGroupObj -> reviewGroupObj.getLong("id"), reviewGroupObj -> reviewGroupObj.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(entry -> entry.getLong("collaborator.id"), entry -> entry.getString("colstatus"), (v1, v2) -> v1)), (v1, v2) -> v1));
        String activityName = oldReviewGroupObjs[0].getString("reviewactivity.name");
        Map<Long, String> groupNameMap = Arrays.stream(oldReviewGroupObjs).collect(Collectors.toMap(groupObj -> groupObj.getLong("id"), groupObj -> groupObj.getString("name"), (v1, v2) -> v1));
        this.mergeCollaboratorSendMsg(newCollaborateMap, oldCollaborateMap, groupNameMap, activityName);
    }

    @Override
    public void sendMsgNotifyCollaborator(Map<Long, Map<Long, String>> groupCollaStatusMap, List<Long> reviewGroupIds) {
        Object[] oldReviewGroupObjs = reviewGroupService.listReviewGroup(reviewGroupIds);
        if (HRArrayUtils.isEmpty((Object[])oldReviewGroupObjs)) {
            return;
        }
        String activityName = oldReviewGroupObjs[0].getString("reviewactivity.name");
        Map<Long, String> groupNameMap = Arrays.stream(oldReviewGroupObjs).collect(Collectors.toMap(groupObj -> groupObj.getLong("id"), groupObj -> groupObj.getString("name"), (v1, v2) -> v1));
        HashMap<Long, Map<Long, String>> oldGroupCollaStatusMap = new HashMap<Long, Map<Long, String>>(16);
        for (Object oldReviewGroupObj : oldReviewGroupObjs) {
            long reviewGroupId = oldReviewGroupObj.getLong("id");
            HashMap<Long, String> collaStatusMap = new HashMap<Long, String>(16);
            DynamicObjectCollection entryEntity = oldReviewGroupObj.getDynamicObjectCollection("entryentity");
            if (!HRCollUtil.isEmpty((Collection)entryEntity)) {
                for (DynamicObject entry : entryEntity) {
                    long userId = entry.getLong("collaborator.id");
                    String colStatus = entry.getString("colstatus");
                    collaStatusMap.put(userId, colStatus);
                }
            }
            oldGroupCollaStatusMap.put(reviewGroupId, collaStatusMap);
        }
        this.mergeCollaboratorSendMsg(groupCollaStatusMap, oldGroupCollaStatusMap, groupNameMap, activityName);
    }

    public void mergeCollaboratorSendMsg(Map<Long, Map<Long, String>> newGroupCollaStatusMap, Map<Long, Map<Long, String>> oldGroupCollaStatusMap, Map<Long, String> groupNameMap, String activityName) {
        List groupNameList;
        List userIds;
        String sameGroupKey;
        HashMap<Long, List<Long>> groupBeginCollaUserIdsMap = new HashMap<Long, List<Long>>(16);
        HashMap<Long, List<Long>> groupStopCollaUserIdsMap = new HashMap<Long, List<Long>>(16);
        for (Map.Entry<Long, Map<Long, String>> oldGroupCollaEntry : oldGroupCollaStatusMap.entrySet()) {
            Long groupId = oldGroupCollaEntry.getKey();
            Map<Long, String> oldCollaborateMap = oldGroupCollaEntry.getValue();
            Map<Long, String> collaborateMap = newGroupCollaStatusMap.get(groupId);
            ArrayList<Long> beginCollaUserIds = new ArrayList<Long>(10);
            ArrayList<Long> stopCollaUserIds = new ArrayList<Long>(10);
            for (Map.Entry<Long, String> oldEntry : oldCollaborateMap.entrySet()) {
                Long collaboratorId = oldEntry.getKey();
                String colStatus = oldEntry.getValue();
                if (!collaborateMap.containsKey(collaboratorId)) {
                    if (!"1".equals(colStatus)) continue;
                    stopCollaUserIds.add(collaboratorId);
                    continue;
                }
                String newColStatus = collaborateMap.get(collaboratorId);
                if (colStatus.equals(newColStatus)) continue;
                if ("1".equals(newColStatus)) {
                    beginCollaUserIds.add(collaboratorId);
                    continue;
                }
                stopCollaUserIds.add(collaboratorId);
            }
            HashSet<Long> userIds2 = new HashSet<Long>(collaborateMap.keySet());
            userIds2.removeAll(oldCollaborateMap.keySet());
            for (Long userId : userIds2) {
                String newColStatus = collaborateMap.get(userId);
                if (!"1".equals(newColStatus)) continue;
                beginCollaUserIds.add(userId);
            }
            groupBeginCollaUserIdsMap.put(groupId, beginCollaUserIds);
            groupStopCollaUserIdsMap.put(groupId, stopCollaUserIds);
        }
        Map<Long, List<String>> beginCollaUserGroupMap = this.getUserToGroupNameMap(groupNameMap, groupBeginCollaUserIdsMap);
        Map<Long, List<String>> stopCollaUserGroupMap = this.getUserToGroupNameMap(groupNameMap, groupStopCollaUserIdsMap);
        Pair<Map<String, List<Long>>, Map<String, List<String>>> beginSameGroupUserInfo = this.getSameGroupUserInfo(beginCollaUserGroupMap);
        Map beginSameGroupUserIdsMap = (Map)beginSameGroupUserInfo.getLeft();
        Map beginSameGroupNameMap = (Map)beginSameGroupUserInfo.getRight();
        Pair<Map<String, List<Long>>, Map<String, List<String>>> stopSameGroupUserInfo = this.getSameGroupUserInfo(stopCollaUserGroupMap);
        Map stopSameGroupUserIdsMap = (Map)stopSameGroupUserInfo.getLeft();
        Map stopSameGroupNameMap = (Map)stopSameGroupUserInfo.getRight();
        for (Map.Entry sameGroupUserIdsMap : beginSameGroupUserIdsMap.entrySet()) {
            sameGroupKey = (String)sameGroupUserIdsMap.getKey();
            userIds = (List)sameGroupUserIdsMap.getValue();
            groupNameList = (List)beginSameGroupNameMap.get(sameGroupKey);
            this.sendBeginCollaMsg(userIds, activityName, groupNameList);
        }
        for (Map.Entry sameGroupUserIdsMap : stopSameGroupUserIdsMap.entrySet()) {
            sameGroupKey = (String)sameGroupUserIdsMap.getKey();
            userIds = (List)sameGroupUserIdsMap.getValue();
            groupNameList = (List)stopSameGroupNameMap.get(sameGroupKey);
            this.sendStopCollaMsg(userIds, activityName, groupNameList);
        }
    }

    private Pair<Map<String, List<Long>>, Map<String, List<String>>> getSameGroupUserInfo(Map<Long, List<String>> userGroupMap) {
        HashMap<String, ArrayList<Long>> sameGroupUserIdsMap = new HashMap<String, ArrayList<Long>>(16);
        HashMap<String, List<String>> sameGroupNameMap = new HashMap<String, List<String>>(16);
        for (Map.Entry<Long, List<String>> userGroupEntry : userGroupMap.entrySet()) {
            Long userId = userGroupEntry.getKey();
            List<String> groupNames = userGroupEntry.getValue();
            Collections.sort(groupNames);
            String sameGroupNameKey = StringUtils.join(groupNames, (String)"#");
            ArrayList<Long> userIds = (ArrayList<Long>)sameGroupUserIdsMap.get(sameGroupNameKey);
            if (HRCollUtil.isEmpty((Collection)userIds)) {
                userIds = new ArrayList<Long>(10);
            }
            userIds.add(userId);
            sameGroupUserIdsMap.put(sameGroupNameKey, userIds);
            sameGroupNameMap.put(sameGroupNameKey, groupNames);
        }
        return Pair.of(sameGroupUserIdsMap, sameGroupNameMap);
    }

    private Map<Long, List<String>> getUserToGroupNameMap(Map<Long, String> groupNameMap, Map<Long, List<Long>> groupBeginCollaUserIdsMap) {
        HashMap<Long, List<String>> beginCollaUserGroupMap = new HashMap<Long, List<String>>(16);
        for (Map.Entry<Long, List<Long>> groupCollaUserEntry : groupBeginCollaUserIdsMap.entrySet()) {
            Long groupId = groupCollaUserEntry.getKey();
            String groupName = groupNameMap.get(groupId);
            List<Long> userIds = groupCollaUserEntry.getValue();
            for (Long userId : userIds) {
                ArrayList<String> groupNameList = (ArrayList<String>)beginCollaUserGroupMap.get(userId);
                if (HRCollUtil.isEmpty((Collection)groupNameList)) {
                    groupNameList = new ArrayList<String>(10);
                }
                groupNameList.add(groupName);
                beginCollaUserGroupMap.put(userId, groupNameList);
            }
        }
        return beginCollaUserGroupMap;
    }

    private void sendBeginCollaMsg(List<Long> beginCollaUserIds, String activityName, List<String> groupNames) {
        String title = ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u534f\u4f5c\u901a\u77e5", (String)"ReviewCollaboratorServiceImpl_0", (String)"tdc-oatr-business", (Object[])new Object[0]);
        String userName = RequestContext.get().getUserName();
        String separator = ResManager.loadKDString((String)"\u3001", (String)"ReviewCollaboratorServiceImpl_3", (String)"tdc-oatr-business", (Object[])new Object[0]);
        String groupName = StringUtils.join(groupNames, (String)separator);
        String content = ResManager.loadKDString((String)"{0}\u5411\u4f60\u5206\u914d\u4e86{1}\u4e2d{2}\u7684\u534f\u4f5c\u5de5\u4f5c", (String)"ReviewCollaboratorServiceImpl_1", (String)"tdc-oatr-business", (Object[])new Object[]{userName, activityName, groupName});
        String contentUrl = null;
        Long senderId = 0L;
        String tag = ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u534f\u4f5c\u901a\u77e5", (String)"ReviewCollaboratorServiceImpl_0", (String)"tdc-oatr-business", (Object[])new Object[0]);
        Long bizDataId = null;
        String entityNumber = null;
        BosMessageService.sendMessage(title, content, contentUrl, senderId, beginCollaUserIds, tag, bizDataId, entityNumber);
    }

    private void sendStopCollaMsg(List<Long> stopCollaUserIds, String activityName, List<String> groupNames) {
        String title = ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u534f\u4f5c\u505c\u6b62\u901a\u77e5", (String)"ReviewCollaboratorServiceImpl_2", (String)"tdc-oatr-business", (Object[])new Object[0]);
        String userName = RequestContext.get().getUserName();
        String separator = ResManager.loadKDString((String)"\u3001", (String)"ReviewCollaboratorServiceImpl_3", (String)"tdc-oatr-business", (Object[])new Object[0]);
        String groupName = StringUtils.join(groupNames, (String)separator);
        String content = ResManager.loadKDString((String)"{0}\u505c\u6b62\u4e86\u4f60\u5bf9\u4e8e{1}\u4e2d{2}\u7684\u534f\u4f5c\u5de5\u4f5c", (String)"ReviewCollaboratorServiceImpl_4", (String)"tdc-oatr-business", (Object[])new Object[]{userName, activityName, groupName});
        String contentUrl = null;
        Long senderId = 0L;
        String tag = ResManager.loadKDString((String)"\u76d8\u70b9\u6d3b\u52a8\u534f\u4f5c\u505c\u6b62\u901a\u77e5", (String)"ReviewCollaboratorServiceImpl_2", (String)"tdc-oatr-business", (Object[])new Object[0]);
        Long bizDataId = null;
        String entityNumber = null;
        BosMessageService.sendMessage(title, content, contentUrl, senderId, stopCollaUserIds, tag, bizDataId, entityNumber);
    }

    static {
        PROP_MAPPING.put(VidPropType.JOB, Collections.singletonList("job"));
        PROP_MAPPING.put(VidPropType.ADMIN_ORG, Collections.singletonList("adminorg"));
        PROP_MAPPING.put(VidPropType.POSITION, Collections.singletonList("position"));
        PROP_MAPPING.put(VidPropType.STAND_POSITION, Collections.singletonList("std_position"));
    }
}

