/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.domain.collaborator.impl;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.tdc.oatr.bussiness.domain.collaborator.ReviewToolService;
import kd.tdc.oatr.bussiness.domain.repository.EvaluationItemRepository;
import kd.tdc.oatr.common.constants.activity.detail.ReviewToolConstants;
import kd.tdc.oatr.common.utils.PropUtils;

public class ReviewToolServiceImpl
implements ReviewToolService,
ReviewToolConstants {
    private static final Log LOG = LogFactory.getLog(ReviewToolServiceImpl.class);
    private static final HRBaseServiceHelper TOOL_REPOSITORY = new HRBaseServiceHelper("oatr_reviewtool");
    private static final HRBaseServiceHelper OBJECT_REPOSITORY = new HRBaseServiceHelper("oatr_reviewobject");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluationItemSnapshot(DynamicObject[] reviewActivities) {
        if (Objects.isNull(reviewActivities) || reviewActivities.length == 0) {
            LOG.info("evaluationItemSnapshot.param is null");
            return;
        }
        List activityIdList = Arrays.stream(reviewActivities).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        LOG.info("evaluationItemSnapshot.param:{}", activityIdList);
        DynamicObject[] reviewToolDOArr = TOOL_REPOSITORY.query("evaluationitem", new QFilter("reviewactivity", "in", activityIdList).toArray());
        List evaluationItemIdList = Arrays.stream(reviewToolDOArr).map(tool -> tool.getDynamicObjectCollection("entryentity_outer")).filter(dyC -> !CollectionUtils.isEmpty((Collection)dyC)).flatMap(Collection::stream).map(dyC -> dyC.getDynamicObjectCollection("evaluationitem")).filter(dyC -> !CollectionUtils.isEmpty((Collection)dyC)).flatMap(Collection::stream).map(dy -> dy.getLong("fbasedataid_id")).distinct().collect(Collectors.toList());
        DynamicObject[] evaluationItemHisDOArr = EvaluationItemRepository.getInstance().queryHis(evaluationItemIdList, LocalDate.now());
        for (DynamicObject reviewToolDO : reviewToolDOArr) {
            DynamicObjectCollection outToolDOList = reviewToolDO.getDynamicObjectCollection("entryentity_outer");
            for (DynamicObject outToolDO : outToolDOList) {
                DynamicObjectCollection evaluationItemList = outToolDO.getDynamicObjectCollection("evaluationitem");
                for (DynamicObject evaluationItem : evaluationItemList) {
                    long itemId = evaluationItem.getLong("fbasedataid_id");
                    Arrays.stream(evaluationItemHisDOArr).filter(hisDO -> itemId == hisDO.getLong("boid")).findFirst().ifPresent(hisDO -> {
                        LOG.info("reviewToolDO:evaluationItemSnapshot.boId-{},fid-{}", (Object)hisDO.getLong("boid"), (Object)hisDO.getLong("id"));
                        evaluationItem.set("fbasedataid", hisDO);
                    });
                }
            }
        }
        DynamicObject[] reviewObjArr = OBJECT_REPOSITORY.query("entryentity_eval.evaluationitem", new QFilter("reviewactivity", "in", activityIdList).toArray());
        if (reviewObjArr == null || reviewObjArr.length == 0) {
            return;
        }
        for (DynamicObject reviewObj : reviewObjArr) {
            DynamicObjectCollection entryEntityEval = reviewObj.getDynamicObjectCollection("entryentity_eval");
            if (CollectionUtils.isEmpty((Collection)entryEntityEval)) continue;
            entryEntityEval.forEach(evalEntity -> {
                long itemId = evalEntity.getLong("evaluationitem.id");
                Arrays.stream(evaluationItemHisDOArr).filter(hisDO -> itemId == hisDO.getLong("boid")).findFirst().ifPresent(hisDO -> {
                    LOG.info("reviewObj:evaluationItemSnapshot.boId-{},fid-{}", (Object)hisDO.getLong("boid"), (Object)hisDO.getLong("id"));
                    evalEntity.set("evaluationitem", hisDO);
                });
            });
        }
        try (TXHandle txhandle = TX.required((String)"evaluationItemSnapshot");){
            TOOL_REPOSITORY.save(reviewToolDOArr);
            OBJECT_REPOSITORY.save(reviewObjArr);
        }
    }

    @Override
    public void initReviewTool(DynamicObject reviewActivity, DynamicObject reviewTool) {
        if (reviewActivity == null) {
            return;
        }
        LOG.info("initReviewTool.reviewActivity: {}", (Object)reviewActivity.getLong("id"));
        DynamicObject activityTpl = this.getTplByActivity(reviewActivity);
        this.setValue2ReviewTool(reviewActivity, activityTpl, reviewTool);
    }

    @Override
    public void refreshReviewTool(DynamicObject reviewActivity, DynamicObject reviewTool) {
        if (reviewActivity == null) {
            return;
        }
        LOG.info("refreshReviewTool.reviewActivity:{}", (Object)reviewActivity.getLong("id"));
        if (Objects.isNull(reviewTool)) {
            LOG.error("refreshReviewTool.reviewActivity:{},reviewTool is null", (Object)reviewActivity.getLong("id"));
            return;
        }
        Map<Long, DynamicObjectCollection> innerReviewGroupMap = this.getInnerReviewGroupMap(reviewTool);
        Map<Long, DynamicObjectCollection> outerReviewGroupMap = this.getOuterReviewGroupMap(reviewTool);
        DynamicObject template = this.getTplByActivity(reviewActivity);
        reviewTool.set("entryentity_outer", null);
        reviewTool.set("entryentity_inner", null);
        this.setValue2ReviewTool(reviewActivity, template, reviewTool);
        this.setInnerReviewGroup(reviewTool, innerReviewGroupMap);
        this.setOuterReviewGroup(reviewTool, outerReviewGroupMap);
    }

    private void setValue2ReviewTool(DynamicObject reviewActivity, DynamicObject activityTpl, DynamicObject reviewTool) {
        reviewTool.set("reviewactivity", reviewActivity.get("id"));
        reviewTool.set("isfromtpl", (Object)Boolean.FALSE);
        Date now = new Date();
        reviewTool.set("updatetime", (Object)now);
        if (Objects.nonNull(activityTpl)) {
            reviewTool.set("isfromtpl", (Object)Boolean.TRUE);
            DynamicObjectCollection innerEntry = activityTpl.getDynamicObjectCollection("entryentity_inner");
            DynamicObjectCollection outerEntry = activityTpl.getDynamicObjectCollection("entryentity_outer");
            DynamicObjectCollection toolOuterEntry = reviewTool.getDynamicObjectCollection("entryentity_outer");
            for (DynamicObject outerDO : outerEntry) {
                DynamicObject toolOuterDO = toolOuterEntry.addNew();
                toolOuterDO.set("outer_tool", outerDO.get("outer_tool"));
                toolOuterDO.set("evaluationitem_num", outerDO.get("evaluationitem_num"));
                DynamicObjectCollection evaluationItemList = outerDO.getDynamicObjectCollection("evaluationitem");
                DynamicObjectCollection toolEvaluationItemList = toolOuterDO.getDynamicObjectCollection("evaluationitem");
                this.copyMultiBaseDataProp(evaluationItemList, toolEvaluationItemList);
                toolOuterDO.set("outtoolselect", outerDO.get("outtoolselect"));
                DynamicObjectCollection attachmentList = outerDO.getDynamicObjectCollection("attachment");
                DynamicObjectCollection toolAttachmentList = toolOuterDO.getDynamicObjectCollection("attachment");
                this.copyMultiBaseDataProp(attachmentList, toolAttachmentList);
                toolOuterDO.set("outertool_modifytime", (Object)now);
                toolOuterDO.set("toolname", (Object)HRDyObjectPropUtil.getName((DynamicObject)outerDO.getDynamicObject("outer_tool")));
            }
            DynamicObjectCollection toolInnerEntry = reviewTool.getDynamicObjectCollection("entryentity_inner");
            for (DynamicObject innerDO : innerEntry) {
                DynamicObject toolInnerDO = toolInnerEntry.addNew();
                toolInnerDO.set("innertooltype", (Object)"1");
                toolInnerDO.set("questionnaire", innerDO.get("questionnaire"));
                toolInnerDO.set("innertoolselect", innerDO.get("innertoolselect"));
                toolInnerDO.set("innertool_modifytime", (Object)now);
            }
        }
    }

    private void copyMultiBaseDataProp(DynamicObjectCollection from, DynamicObjectCollection to) {
        if (CollectionUtils.isEmpty((Collection)from)) {
            return;
        }
        for (DynamicObject fromDO : from) {
            DynamicObject dynamicObject = to.addNew();
            dynamicObject.set("fbasedataid_id", fromDO.get("fbasedataid_id"));
        }
    }

    private DynamicObject getTplByActivity(DynamicObject reviewActivity) {
        if (reviewActivity.getDynamicObjectType().getProperty("activitytemplate") == null) {
            return null;
        }
        Object activityTplId = reviewActivity.get(PropUtils.getIdDot((String)"activitytemplate"));
        if (Objects.isNull(activityTplId)) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewactivitytpl");
        return serviceHelper.queryOne(activityTplId);
    }

    private Map<Long, DynamicObjectCollection> getInnerReviewGroupMap(DynamicObject reviewTool) {
        HashMap<Long, DynamicObjectCollection> innerReviewGroupMap = new HashMap<Long, DynamicObjectCollection>(16);
        DynamicObjectCollection entryEntityInner = reviewTool.getDynamicObjectCollection("entryentity_inner");
        for (DynamicObject innerTool : entryEntityInner) {
            long questionnaireId = innerTool.getLong("questionnaire.id");
            DynamicObjectCollection innerReviewGroups = innerTool.getDynamicObjectCollection("inner_reviewgroup");
            if (!HRCollUtil.isNotEmpty((Collection)innerReviewGroups)) continue;
            innerReviewGroupMap.put(questionnaireId, innerReviewGroups);
        }
        return innerReviewGroupMap;
    }

    private Map<Long, DynamicObjectCollection> getOuterReviewGroupMap(DynamicObject reviewTool) {
        HashMap<Long, DynamicObjectCollection> outerReviewGroupMap = new HashMap<Long, DynamicObjectCollection>(16);
        DynamicObjectCollection entryEntityOuter = reviewTool.getDynamicObjectCollection("entryentity_outer");
        for (DynamicObject outerTool : entryEntityOuter) {
            long reviewToolSchemeId = outerTool.getLong("outer_tool.id");
            DynamicObjectCollection outerReviewGroups = outerTool.getDynamicObjectCollection("outer_reviewgroup");
            if (!HRCollUtil.isNotEmpty((Collection)outerReviewGroups)) continue;
            outerReviewGroupMap.put(reviewToolSchemeId, outerReviewGroups);
        }
        return outerReviewGroupMap;
    }

    private void setInnerReviewGroup(DynamicObject reviewTool, Map<Long, DynamicObjectCollection> innerReviewGroupMap) {
        DynamicObjectCollection entryEntityInner = reviewTool.getDynamicObjectCollection("entryentity_inner");
        for (DynamicObject innerTool : entryEntityInner) {
            DynamicObjectCollection innerReviewGroup = innerTool.getDynamicObjectCollection("inner_reviewgroup");
            long questionnaireId = innerTool.getLong("questionnaire.id");
            DynamicObjectCollection reviewGroups = innerReviewGroupMap.get(questionnaireId);
            if (!HRCollUtil.isNotEmpty((Collection)reviewGroups)) continue;
            for (DynamicObject reviewGroup : reviewGroups) {
                DynamicObject reviewGroupObj = innerReviewGroup.addNew();
                reviewGroupObj.set("fbasedataid", reviewGroup.get("fbasedataid"));
                reviewGroupObj.set("fbasedataid_id", reviewGroup.get("fbasedataid_id"));
            }
        }
    }

    private void setOuterReviewGroup(DynamicObject reviewTool, Map<Long, DynamicObjectCollection> outerReviewGroupMap) {
        DynamicObjectCollection entryEntityOuter = reviewTool.getDynamicObjectCollection("entryentity_outer");
        for (DynamicObject outerTool : entryEntityOuter) {
            DynamicObjectCollection outerReviewGroups = outerTool.getDynamicObjectCollection("outer_reviewgroup");
            long reviewToolSchemeId = outerTool.getLong("outer_tool.id");
            DynamicObjectCollection reviewGroups = outerReviewGroupMap.get(reviewToolSchemeId);
            if (!HRCollUtil.isNotEmpty((Collection)reviewGroups)) continue;
            for (DynamicObject reviewGroup : reviewGroups) {
                DynamicObject reviewGroupObj = outerReviewGroups.addNew();
                reviewGroupObj.set("fbasedataid", reviewGroup.get("fbasedataid"));
                reviewGroupObj.set("fbasedataid_id", reviewGroup.get("fbasedataid_id"));
            }
        }
    }
}

