/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.domain.perscope;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.application.ext.ScheduleServiceHelper;
import kd.tdc.oatr.bussiness.queryservice.ReviewPersonQueryService;
import kd.tdc.oatr.common.bo.ReviewPersonSerchInfo;
import kd.tdc.tdcs.common.util.LogicExpressionParserUtils;

public class ReviewPersonScopeConfigService {
    private static final Log LOG = LogFactory.getLog(ReviewPersonScopeConfigService.class);
    private static final HRBaseServiceHelper BASE_SERVICE_HELPER = new HRBaseServiceHelper("oatr_personscopemapping");

    public DynamicObject[] listScopeConfigData() {
        return BASE_SERVICE_HELPER.queryOriginalArray("metadataname,fieldname,fieldmetadataname,basefieldfilterconf,basefieldext", new QFilter[]{new QFilter("number", "is not null", (Object)"")}, "number asc");
    }

    public DynamicObject[] getReviewPersons(List<QFilter> qFilters, QFilter qFilter, DynamicObject[] scopeConfigData, String taskId) {
        String qFilterStr = qFilter.toString();
        List<ReviewPersonSerchInfo> reviewPersonSerchInfos = this.getReviewPersonSearchInfos(qFilters, scopeConfigData, taskId);
        String parseSqlStr = ReviewPersonScopeConfigService.getParseSqlStr(reviewPersonSerchInfos, qFilterStr, 0);
        try {
            List filterParses = LogicExpressionParserUtils.parse((String)parseSqlStr, (String)"AND", (String)"OR");
            List<Long> personIds = ReviewPersonScopeConfigService.reviewPersonIdCalculate(filterParses, reviewPersonSerchInfos);
            return ReviewPersonQueryService.getTalentFileByPersonIds(personIds);
        }
        catch (Exception exception) {
            LOG.error("ReviewPersonScopeConfigService.getReviewPersons error: ", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u76d8\u70b9\u4eba\u5458\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ReviewPersonScopeConfigService_0", (String)"tdc-oatr-business", (Object[])new Object[0]));
        }
    }

    public static List<Long> reviewPersonIdCalculate(List<List<String>> filterParses, List<ReviewPersonSerchInfo> reviewPersonSerchInfos) {
        List<Long> personIdsCalculate = new ArrayList<Long>(16);
        for (int i = 0; i < filterParses.size(); ++i) {
            List<Long> personIdsAnd = ReviewPersonScopeConfigService.personIdCalculateAnd(filterParses.get(i), reviewPersonSerchInfos);
            personIdsCalculate = ReviewPersonScopeConfigService.personIdCalculateOr(personIdsCalculate, personIdsAnd);
        }
        return personIdsCalculate;
    }

    public static List<Long> personIdCalculateAnd(List<String> filterParse, List<ReviewPersonSerchInfo> reviewPersonSerchInfos) {
        List<Long> personIdsCalculateAnd = ReviewPersonScopeConfigService.getPersonIdsByKey(filterParse.get(0), reviewPersonSerchInfos);
        for (int n = 1; n < filterParse.size(); ++n) {
            String qFilterkey = filterParse.get(n);
            List<Long> personIds = ReviewPersonScopeConfigService.getPersonIdsByKey(qFilterkey, reviewPersonSerchInfos);
            personIdsCalculateAnd.retainAll(personIds);
        }
        return personIdsCalculateAnd;
    }

    public static List<Long> personIdCalculateOr(List<Long> aList, List<Long> bList) {
        for (int i = 0; i < bList.size(); ++i) {
            if (aList.contains(bList.get(i))) continue;
            aList.add(bList.get(i));
        }
        return aList;
    }

    public List<ReviewPersonSerchInfo> getReviewPersonSearchInfos(List<QFilter> qFilters, DynamicObject[] scopeConfigData) {
        return this.getReviewPersonSearchInfos(qFilters, scopeConfigData, "");
    }

    private List<ReviewPersonSerchInfo> getReviewPersonSearchInfos(List<QFilter> qFilters, DynamicObject[] scopeConfigData, String taskId) {
        int qFiltersSize = qFilters.size();
        ArrayList<ReviewPersonSerchInfo> reviewPersonSearchInfos = new ArrayList<ReviewPersonSerchInfo>(qFiltersSize);
        for (int i = 0; i < qFiltersSize; ++i) {
            ReviewPersonSerchInfo searchInfo = new ReviewPersonSerchInfo();
            String keyBuff = "T" + i;
            searchInfo.setQfilterKey(keyBuff);
            searchInfo.setQfilter(qFilters.get(i));
            String fieldName = qFilters.get(i).getProperty();
            String metaDataName = ReviewPersonScopeConfigService.getMetaDataNameByFieldName(fieldName, scopeConfigData);
            searchInfo.setMetaDataName(metaDataName);
            reviewPersonSearchInfos.add(searchInfo);
            DynamicObject[] searchDataInfos = ReviewPersonQueryService.getReviewPersonDOs(metaDataName, qFilters.get(i));
            if (searchDataInfos != null) {
                searchInfo.setSearchDataInfos(searchDataInfos);
                searchInfo.setPersonIds(ReviewPersonScopeConfigService.getPersonIdsByDataInfo(searchDataInfos));
            }
            if (HRStringUtils.isBlank((CharSequence)taskId)) continue;
            int percentageOfProcess = (i + 1) * 100 / qFiltersSize;
            ScheduleServiceHelper.feedbackProgress(taskId, percentageOfProcess);
        }
        return reviewPersonSearchInfos;
    }

    public static List<Long> getPersonIdsByDataInfo(DynamicObject[] searchDataInfos) {
        ArrayList<Long> personIds = new ArrayList<Long>(searchDataInfos.length);
        for (int i = 0; i < searchDataInfos.length; ++i) {
            Long personId = searchDataInfos[i].getLong("person.id");
            personIds.add(personId);
        }
        return personIds;
    }

    public static List<Long> getPersonIdsByKey(String key, List<ReviewPersonSerchInfo> reviewPersonSerchInfos) {
        List<Long> personIds = new ArrayList<Long>(16);
        for (int i = 0; i < reviewPersonSerchInfos.size(); ++i) {
            if (!key.equals(reviewPersonSerchInfos.get(i).getQfilterKey()) || reviewPersonSerchInfos.get(i).getPersonIds() == null) continue;
            personIds = reviewPersonSerchInfos.get(i).getPersonIds();
        }
        return personIds;
    }

    public static String getMetaDataNameByFieldName(String fieldName, DynamicObject[] scopeConfigData) {
        if (fieldName.contains(".")) {
            fieldName = fieldName.substring(0, fieldName.indexOf("."));
        }
        String metaDataName = "";
        for (int i = 0; i < scopeConfigData.length; ++i) {
            String configDataFieldName = scopeConfigData[i].getString("fieldmetadataname");
            if (!fieldName.equals(configDataFieldName)) continue;
            metaDataName = scopeConfigData[i].getString("metadataname");
        }
        return metaDataName;
    }

    public static String getParseSqlStr(List<ReviewPersonSerchInfo> reviewPersonSerchInfos, String qFilterStr, int parseType) {
        for (int i = 0; i < reviewPersonSerchInfos.size(); ++i) {
            String sqlStr = reviewPersonSerchInfos.get(i).getQfilter().toString();
            String sqlKeyStr = reviewPersonSerchInfos.get(i).getQfilterKey();
            qFilterStr = parseType == 0 ? qFilterStr.replace(sqlStr, sqlKeyStr) : qFilterStr.replace(sqlKeyStr, sqlStr);
        }
        return qFilterStr;
    }
}

