/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.domain.reviewgroup;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;

public class ReviewGroupService {
    private static final HRBaseServiceHelper REVIEW_GROUP_HELPER = new HRBaseServiceHelper("oatr_reviewgroup");

    public int count(QFilter[] filters) {
        return REVIEW_GROUP_HELPER.count("oatr_reviewgroup", filters);
    }

    public DynamicObject[] listReviewGroup(List<Long> groupIds) {
        QFilter idFilter = new QFilter("id", "in", groupIds);
        return REVIEW_GROUP_HELPER.query("id,reviewactivity,entryentity.collaborator,entryentity.collaborator.number,entryentity.colstatus", new QFilter[]{idFilter});
    }

    public void saveReviewGroup(DynamicObject[] groupData) {
        if (HRArrayUtils.isEmpty((Object[])groupData)) {
            return;
        }
        REVIEW_GROUP_HELPER.save(groupData);
    }

    public void initOneGroup(Object activityId) {
        DynamicObject reviewGroupObj = REVIEW_GROUP_HELPER.generateEmptyDynamicObject();
        reviewGroupObj.set("reviewactivity", activityId);
        reviewGroupObj.set("sortnum", (Object)1);
        reviewGroupObj.set("enable", (Object)"1");
        reviewGroupObj.set("status", (Object)"C");
        reviewGroupObj.set("name", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u76d8\u70b9\u7ec4", (String)"ReviewGroupService_0", (String)"tdc-oatr-business"));
        reviewGroupObj.set("number", (Object)"default");
        reviewGroupObj.set("description", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u751f\u6210\u7684\u76d8\u70b9\u7ec4\uff0c\u76d8\u70b9\u6d3b\u52a8\u4e0b\u5bf9\u8c61\u4f7f\u7528\u5de5\u5177\u4e00\u81f4\u65f6\u4f7f\u7528\u3002", (String)"ReviewGroupService_1", (String)"tdc-oatr-business"));
        REVIEW_GROUP_HELPER.saveOne(reviewGroupObj);
    }

    public boolean isExists(Object pkValue) {
        return REVIEW_GROUP_HELPER.isExists(pkValue);
    }

    public boolean isExists(QFilter[] qFilters) {
        return REVIEW_GROUP_HELPER.isExists(qFilters);
    }

    public DynamicObject[] listReviewGroupByActivity(Object activityId) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", activityId);
        return REVIEW_GROUP_HELPER.queryOriginalArray("id,reviewactivity,entryentity.collaborator,entryentity.collaborator.number collaborator.number", new QFilter[]{activityFilter});
    }

    public DynamicObject queryDefaultReviewGroup(Object activityId) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", activityId);
        QFilter groupFilter = new QFilter("number", "=", (Object)"default");
        return REVIEW_GROUP_HELPER.queryOne(new QFilter[]{activityFilter, groupFilter});
    }

    public DynamicObject[] listReviewGroupByGroup(List<Long> groupIds) {
        QFilter idFilter = new QFilter("id", "in", groupIds);
        return REVIEW_GROUP_HELPER.queryOriginalArray("id,reviewactivity,entryentity.collaborator,entryentity.collaborator.number collaborator.number,entryentity.collaborator.name collaborator.name", new QFilter[]{idFilter});
    }

    public DynamicObject[] listReviewGroupByCollId(Object activityId) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", activityId);
        return REVIEW_GROUP_HELPER.queryOriginalArray("id,reviewactivity,entryentity.collaborator,entryentity.colstatus,entryentity.adminorg,entryentity.position,entryentity.job,entryentity.std_position", new QFilter[]{activityFilter});
    }

    public DynamicObject getReviewGroupById(Object id) {
        QFilter idFilter = new QFilter("id", "=", id);
        return REVIEW_GROUP_HELPER.queryOriginalOne("id,name,number", new QFilter[]{idFilter});
    }

    public DynamicObject getReviewGroupByColId(Object activityId, Object id) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", activityId);
        QFilter idFilter = new QFilter("entryentity.id", "=", id);
        return REVIEW_GROUP_HELPER.queryOriginalOne("id,name,number,reviewactivity,entryentity.collaborator,entryentity.collaborator.name", new QFilter[]{idFilter, activityFilter});
    }

    public DynamicObject[] getReviewGroupByActivityId(Object activityId) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", activityId);
        return REVIEW_GROUP_HELPER.queryOriginalArray("id,entryentity.collaborator", new QFilter[]{activityFilter});
    }

    public DynamicObject[] getReviewGroupByBosUser(Object activityId, long bosUserid) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", activityId);
        QFilter collaboratorFilter = new QFilter("entryentity.collaborator", "=", (Object)bosUserid);
        return REVIEW_GROUP_HELPER.queryOriginalArray("id,name,number,reviewactivity,entryentity.collaborator", new QFilter[]{collaboratorFilter, activityFilter});
    }

    public Map<Long, List<Long>> listReviewGroupCollaboratorMap(List<Long> reviewGroupIds) {
        DynamicObject[] reviewGroupObj = this.listReviewGroupByGroup(reviewGroupIds);
        return Arrays.stream(reviewGroupObj).collect(Collectors.groupingBy(obj -> obj.getLong("id"), Collectors.mapping(obj -> obj.getLong("entryentity.collaborator"), Collectors.toList())));
    }

    public List<String> listReviewGroupCollaboratorName(Long reviewGroupId) {
        DynamicObject[] reviewGroupObj = this.listReviewGroupByGroup(Collections.singletonList(reviewGroupId));
        return Arrays.stream(reviewGroupObj).map(obj -> obj.getString("collaborator.name")).collect(Collectors.toList());
    }

    public boolean hasPermCollaborator(List<Long> collaborationIds) {
        long currUserId = RequestContext.get().getCurrUserId();
        return !CollectionUtils.isEmpty(collaborationIds) && collaborationIds.contains(currUserId);
    }

    public boolean hasPermCollaborator(long groupId) {
        Map<Long, List<Long>> reviewGroupCollaborationIdMap = this.listReviewGroupCollaboratorMap(Lists.newArrayList((Object[])new Long[]{groupId}));
        List<Long> collaborationIds = reviewGroupCollaborationIdMap.get(groupId);
        return this.hasPermCollaborator(collaborationIds);
    }
}

