/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.domain.reviewobjct;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewTalentMapConfigApplicationService;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;
import kd.tdc.oatr.common.utils.PropUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class ReviewObjectService {
    private static final HRBaseServiceHelper REVIEW_OBJECT_HELPER = new HRBaseServiceHelper("oatr_reviewobject");
    private static final Log LOG = LogFactory.getLog(ReviewObjectService.class);

    public List<DynamicObject> generatorEmptyObjs(int size) {
        ArrayList emptyReviewObjects = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            emptyReviewObjects.add(REVIEW_OBJECT_HELPER.generateEmptyDynamicObject());
        }
        return emptyReviewObjects;
    }

    public void save(List<DynamicObject> emptyReviewObjects) {
        REVIEW_OBJECT_HELPER.save(emptyReviewObjects.toArray(new DynamicObject[0]));
    }

    public void save(DynamicObject[] reviewObjects) {
        REVIEW_OBJECT_HELPER.save(reviewObjects);
    }

    public void delete(List<DynamicObject> emptyReviewObjects) {
        Object[] deleteIds = emptyReviewObjects.stream().map(DataEntityBase::getPkValue).toArray(Object[]::new);
        REVIEW_OBJECT_HELPER.delete(deleteIds);
    }

    public boolean isExists(QFilter[] filters) {
        return REVIEW_OBJECT_HELPER.isExists(filters);
    }

    public DynamicObject[] getReviewObjByActivityId(long activityId) {
        return REVIEW_OBJECT_HELPER.query("entryentity_eval,evaltool", new QFilter("reviewactivity", "=", (Object)activityId).toArray());
    }

    public DynamicObject[] getReviewObjectByActivityId(long activityId) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", (Object)activityId);
        return REVIEW_OBJECT_HELPER.query("talentfile,id,entryentity_outer,reviewgroup,entryentity_dimension,entryentity_mapbefore,errormsgentry,errormsgentry.errormsgtype,errormsgentry.errormsgcontent", new QFilter[]{activityFilter});
    }

    public DynamicObject[] listJoinedReviewObjects(long activityId) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", (Object)activityId);
        QFilter reviewGroupFilter = new QFilter("reviewgroup.id", "!=", (Object)0L);
        return REVIEW_OBJECT_HELPER.query("reviewgroup,talentfile,number", new QFilter[]{activityFilter, reviewGroupFilter});
    }

    public int countJoinedReviewObjects(long activityId) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", (Object)activityId);
        QFilter reviewGroupFilter = new QFilter("reviewgroup.id", "!=", (Object)0L);
        return REVIEW_OBJECT_HELPER.count(REVIEW_OBJECT_HELPER.getEntityName(), new QFilter[]{activityFilter, reviewGroupFilter});
    }

    public DynamicObject[] listJoinedReviewObjectsByTalentFileIds(long activityId, List<Long> talentFileIds) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", (Object)activityId);
        QFilter talentFileIdFilter = new QFilter("talentfile.id", "in", talentFileIds);
        QFilter reviewGroupFilter = new QFilter("reviewgroup.id", "!=", (Object)0L);
        return REVIEW_OBJECT_HELPER.query("name,number,reviewgroup,talentfile", new QFilter[]{activityFilter, talentFileIdFilter, reviewGroupFilter});
    }

    public DynamicObject[] listNotJoinedReviewObjects(long activityId) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", (Object)activityId);
        QFilter reviewGroupFilter = new QFilter("reviewgroup.id", "=", (Object)0L);
        return REVIEW_OBJECT_HELPER.query("talentfile", new QFilter[]{activityFilter, reviewGroupFilter});
    }

    public DynamicObject[] listReviewObjectsByTalentFileIds(List<Long> talentFileIds, long activityId) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", (Object)activityId);
        QFilter talentFileFilter = new QFilter("talentfile.id", "in", talentFileIds);
        return REVIEW_OBJECT_HELPER.loadDynamicObjectArray("oatr_reviewobject", new QFilter[]{activityFilter, talentFileFilter});
    }

    public DynamicObject[] listJoinedReviewObjectsByActivityId(long activityId) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "in", (Object)activityId);
        QFilter reviewGroupFilter = new QFilter("reviewgroup.id", "!=", (Object)0L);
        return REVIEW_OBJECT_HELPER.loadDynamicObjectArray("oatr_reviewobject", new QFilter[]{activityFilter, reviewGroupFilter});
    }

    public DynamicObject[] getJoinedReviewObjectsByActivityIds(List<Long> activityIds) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "in", activityIds);
        QFilter reviewGroupFilter = new QFilter("reviewgroup.id", "!=", (Object)0L);
        return REVIEW_OBJECT_HELPER.query("reviewactivity,reviewactivity.activitystatus,adminorg,reviewstatus,reviewgroup", new QFilter[]{activityFilter, reviewGroupFilter});
    }

    public DynamicObject[] listReviewObject(List<Long> reviewObjIds) {
        QFilter activityFilter = new QFilter("id", "in", reviewObjIds);
        return REVIEW_OBJECT_HELPER.query("talentfile,id,supereval,reviewgroup,reviewstatus", new QFilter[]{activityFilter});
    }

    public DynamicObject[] listReviewObjectMapData(List<Long> reviewObjIds) {
        QFilter activityFilter = new QFilter("id", "in", reviewObjIds);
        return REVIEW_OBJECT_HELPER.query("id,reviewstatus,entryentity_map,entryentity_map.mapkey,entryentity_map.mapvalue,entryentity_mapbefore,entryentity_map.mapbeforekey,entryentity_map.calibratesession", new QFilter[]{activityFilter});
    }

    public Map<Long, Boolean> listReviewObjectIsDelete(List<Long> reviewObjIds) {
        Object[] reviewObjects = this.listReviewObject(reviewObjIds);
        if (ArrayUtils.isEmpty((Object[])reviewObjects)) {
            return Collections.emptyMap();
        }
        return Arrays.stream(reviewObjects).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getLong("reviewgroup.id") == 0L));
    }

    public DynamicObject getReviewObject(long id) {
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        return REVIEW_OBJECT_HELPER.queryOne("reviewgroup.id", new QFilter[]{idFilter});
    }

    public void setReviewObjectAbnormalInfo(Long personId, LocaleString abnormalInfo, String abnormaType) {
        ArrayList<String> queryStatus = new ArrayList<String>(2);
        queryStatus.add("B");
        queryStatus.add("C");
        queryStatus.add("D");
        QFilter activityFilter = new QFilter("reviewstatus", "in", queryStatus);
        QFilter reviewGroupFilter = new QFilter("personboid", "=", (Object)personId);
        DynamicObject[] reviewObjectDOs = REVIEW_OBJECT_HELPER.query("id,talentfile,errormsgentry,errormsgentry.errormsgtype,errormsgentry.errormsgcontent", new QFilter[]{activityFilter, reviewGroupFilter});
        ArrayList updateErrMsgObjs = Lists.newArrayList();
        for (DynamicObject markErrorMsgObj : reviewObjectDOs) {
            DynamicObjectCollection errorMsgEntry = markErrorMsgObj.getDynamicObjectCollection("errormsgentry");
            boolean present = errorMsgEntry.stream().anyMatch(obj -> obj.getString("errormsgtype").equals(abnormaType));
            if (present) continue;
            DynamicObject msgEntry = errorMsgEntry.addNew();
            msgEntry.set("errormsgtype", (Object)abnormaType);
            msgEntry.set("errormsgcontent", (Object)abnormalInfo);
            updateErrMsgObjs.add(markErrorMsgObj);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateErrMsgObjs)) {
            REVIEW_OBJECT_HELPER.save(updateErrMsgObjs.toArray(new DynamicObject[0]));
        }
    }

    public void deleteNotJoinedObj(long activityId) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", (Object)activityId);
        QFilter groupFilter = new QFilter("reviewgroup.id", "=", (Object)0L);
        REVIEW_OBJECT_HELPER.deleteByFilter(new QFilter[]{activityFilter, groupFilter});
    }

    public Map<Long, Long> getReviewObjectNumByActivity(List<Long> activityIds) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "in", activityIds);
        QFilter groupFilter = new QFilter("reviewgroup.id", "!=", (Object)0L);
        DynamicObject[] objs = REVIEW_OBJECT_HELPER.queryOriginalArray("id,reviewactivity.id", new QFilter[]{activityFilter, groupFilter});
        return Arrays.stream(objs).collect(Collectors.groupingBy(obj -> obj.getLong("reviewactivity.id"), Collectors.counting()));
    }

    public void resetReviewObjMapBeforePos(List<DynamicObject> reviewObjectList, DynamicObject reviewActivity) {
        if (CollectionUtils.isEmpty(reviewObjectList) || reviewActivity == null) {
            LOG.warn("resetReviewObjMapBeforePos param error");
            return;
        }
        long reviewActivityId = reviewActivity.getLong("id");
        Map<String, Map<Long, Object>> personDimensionData = reviewObjectList.stream().collect(Collectors.toMap(reviewObjDO -> reviewObjDO.getString("id"), reviewObjDO -> reviewObjDO.getDynamicObjectCollection("entryentity_dimension").stream().collect(Collectors.toMap(dimRow -> dimRow.getLong(PropUtils.getIdDot((String)"dimension")), dimRow -> dimRow.get("dimensionvalue"), (V1, V2) -> V1)), (V1, V2) -> V1));
        ReviewTalentMapConfigApplicationService mapConfigService = ServiceFactory.getService(ReviewTalentMapConfigApplicationService.class);
        Map<String, Map<Long, String>> talentMapGridPosition = mapConfigService.getTalentMapGridPosition(personDimensionData, reviewActivityId);
        LOG.info("resetReviewObjMapBeforePos,personDimensionData:{}, reviewActivityId:{},talentMapGridPosition:{}", new Object[]{personDimensionData, reviewActivityId, talentMapGridPosition});
        for (DynamicObject reviewObjectDO : reviewObjectList) {
            DynamicObjectCollection mapBeforeEntry = reviewObjectDO.getDynamicObjectCollection("entryentity_mapbefore");
            mapBeforeEntry.clear();
            Map<Long, String> positionInfo = talentMapGridPosition.get(reviewObjectDO.getString("id"));
            if (kd.bos.orm.util.CollectionUtils.isEmpty(positionInfo)) continue;
            positionInfo.forEach((mapId, positionValue) -> {
                if (HRStringUtils.isEmpty((String)positionValue)) {
                    return;
                }
                DynamicObject mapBeforeRow = mapBeforeEntry.addNew();
                mapBeforeRow.set("mapbeforekey", mapId);
                mapBeforeRow.set("mapbeforevalue", positionValue);
            });
        }
    }

    public void updateCalibrateResult(List<Long> reviewObjIds, Map<Long, String> calibrateResultData, String mapIdKey, long sessionId) {
        Object[] reviewObjectMapData = this.listReviewObjectMapData(reviewObjIds);
        if (ArrayUtils.isEmpty((Object[])reviewObjectMapData)) {
            return;
        }
        block0: for (Object reviewObject : reviewObjectMapData) {
            String reviewStatus = reviewObject.getString("reviewstatus");
            if (HRStringUtils.equals((String)reviewStatus, (String)ObjectStatusEnum.GOING_UNCHECK.getCode())) {
                reviewObject.set("reviewstatus", (Object)ObjectStatusEnum.GOING_CHECK.getCode());
            }
            DynamicObjectCollection entryEntityMap = reviewObject.getDynamicObjectCollection("entryentity_map");
            Optional<DynamicObject> isExistsMap = entryEntityMap.stream().filter(entry -> HRStringUtils.equals((String)mapIdKey, (String)entry.getString("mapkey"))).findFirst();
            String calibrateResult = calibrateResultData.get(reviewObject.getLong("id"));
            if (isExistsMap.isPresent()) {
                for (DynamicObject entryMap : entryEntityMap) {
                    String mapKey = entryMap.getString("mapkey");
                    if (!HRStringUtils.equals((String)mapKey, (String)mapIdKey)) continue;
                    if (!HRStringUtils.isNotEmpty((String)calibrateResult)) continue block0;
                    entryMap.set("mapvalue", (Object)calibrateResult);
                    entryMap.set("calibratesession", (Object)sessionId);
                    continue block0;
                }
                continue;
            }
            DynamicObject entityNew = entryEntityMap.addNew();
            entityNew.set("mapkey", (Object)mapIdKey);
            entityNew.set("mapvalue", (Object)calibrateResult);
            entityNew.set("calibratesession", (Object)sessionId);
        }
        REVIEW_OBJECT_HELPER.update((DynamicObject[])reviewObjectMapData);
    }

    public void updateReserveTalentNameByPersonId(String name, Long personId) {
        QFilter idQFilter = new QFilter("person.id", "=", (Object)personId);
        QFilter diffNameQFilter = new QFilter("name", "!=", (Object)name);
        DynamicObject[] result = REVIEW_OBJECT_HELPER.query("id,person.id,name", new QFilter[]{idQFilter, diffNameQFilter});
        if (result.length > 0) {
            Arrays.stream(result).forEach(p -> p.set("name", (Object)name));
            REVIEW_OBJECT_HELPER.save(result);
        }
    }

    public void updateReserveTalentNumberByPersonId(String number, Long personId) {
        QFilter idQFilter = new QFilter("person.id", "=", (Object)personId);
        QFilter diffNumberQFilter = new QFilter("number", "!=", (Object)number);
        DynamicObject[] result = REVIEW_OBJECT_HELPER.query("id,person.id,number", new QFilter[]{idQFilter, diffNumberQFilter});
        if (result.length > 0) {
            Arrays.stream(result).forEach(p -> p.set("number", (Object)number));
            REVIEW_OBJECT_HELPER.save(result);
        }
    }
}

