/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.domain.reviewobjct;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectSnapshotService;
import kd.tdc.oatr.bussiness.domain.vid.UpdateVidDto;
import kd.tdc.oatr.bussiness.domain.vid.VidPropType;
import kd.tdc.oatr.bussiness.domain.vid.service.UpdateHistoryVidService;

public class ReviewObjectSnapshotServiceImpl
implements ReviewObjectSnapshotService {
    private static final HRBaseServiceHelper REPOSITORY = new HRBaseServiceHelper("oatr_reviewobject");
    private static final Map<VidPropType, List<String>> PROP_MAPPING = Maps.newHashMapWithExpectedSize((int)5);

    @Override
    public void personInfoSnapshot(DynamicObject[] reviewActivityDOArr) {
        if (reviewActivityDOArr == null || reviewActivityDOArr.length == 0) {
            return;
        }
        List activityIdList = Arrays.stream(reviewActivityDOArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        QFilter idQF = new QFilter("reviewactivity", "in", activityIdList);
        DynamicObject[] reviewObjs = REPOSITORY.query("company,adminorg,position,stdposition,job", new QFilter[]{idQF});
        if (reviewObjs == null || reviewObjs.length == 0) {
            return;
        }
        UpdateVidDto updateVidDto = new UpdateVidDto();
        updateVidDto.setDynamicObjectList(Arrays.asList(reviewObjs));
        updateVidDto.setPropMapping(PROP_MAPPING);
        UpdateHistoryVidService.getInstance().updateHistoryVid(updateVidDto);
        REPOSITORY.save(reviewObjs);
    }

    static {
        PROP_MAPPING.put(VidPropType.ADMIN_ORG, Lists.newArrayList((Object[])new String[]{"company", "adminorg"}));
        PROP_MAPPING.put(VidPropType.JOB, Collections.singletonList("job"));
        PROP_MAPPING.put(VidPropType.POSITION, Collections.singletonList("position"));
        PROP_MAPPING.put(VidPropType.STAND_POSITION, Collections.singletonList("stdposition"));
    }
}

