/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.domain.reviewplan;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ReviewPlanService {
    private static final HRBaseServiceHelper REVIEW_PLAN_HELPER = new HRBaseServiceHelper("oatr_reviewplans");

    public void updatePlanActivityNumOfRef(Map<DynamicObject, Integer> updateActivityReviewPlanNumOfRef) {
        updateActivityReviewPlanNumOfRef.forEach((dynamicObject, updateNum) -> {
            Object pkValue = dynamicObject.getPkValue();
            String lockKey = String.valueOf(pkValue);
            DLock dLock = DLock.create((String)lockKey, (String)"review activity template num of ref update");
            if (!dLock.tryLock(10000L)) {
                dLock.unlock();
                dLock.close();
                throw new KDBizException("save review activity fail");
            }
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    DynamicObject curObj = REVIEW_PLAN_HELPER.queryOne(dynamicObject.getPkValue());
                    int activityNumOfRef = curObj.getInt("activitynum");
                    curObj.set("activitynum", (Object)(activityNumOfRef + updateNum));
                    REVIEW_PLAN_HELPER.saveOne(curObj);
                }
                catch (Exception exception) {
                    txHandle.markRollback();
                    throw exception;
                }
            }
            catch (Exception exception) {
                throw new KDBizException((Throwable)exception, new ErrorCode("", "save review activity fail"), new Object[0]);
            }
            finally {
                dLock.unlock();
                dLock.close();
            }
        });
    }
}

