/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.queryservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class OnlineCalibrationQueryService {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("oatr_onlinecalibration");

    public DynamicObject[] getOnlineCalibrationOriginalData(Long calibrateSessionId) {
        QFilter sessionIdFilter = new QFilter("calibratesession", "=", (Object)calibrateSessionId);
        return SERVICE_HELPER.queryOriginalArray("id,person.id,person.number,person.name,person.headsculpture,calibrateresult,calibratereason,calibratebefore,reviewactivity.id,reviewactivity.name,reviewactivity.number,reviewobject.id,calibratesession.id,calibratesession.name,calibratesession.number", new QFilter[]{sessionIdFilter});
    }

    public DynamicObject[] listOnlineCalibrationOriginalData(List<Long> pkIds) {
        QFilter idFilter = new QFilter("id", "in", pkIds);
        return SERVICE_HELPER.queryOriginalArray("id,person.id,person.number,person.name,person.headsculpture,calibrateresult,calibratereason,calibratebefore,reviewactivity.id,reviewactivity.name,reviewactivity.number,reviewobject.id,calibratesession.id,calibratesession.name,calibratesession.number", new QFilter[]{idFilter});
    }

    public DynamicObject[] listOnlineCalibrationReviewObjId(List<Long> pkIds) {
        QFilter idFilter = new QFilter("id", "in", pkIds);
        return SERVICE_HELPER.queryOriginalArray("id,reviewobject.id", new QFilter[]{idFilter});
    }

    public DynamicObject getOnlineCalibration(Long pkId) {
        QFilter idFilter = new QFilter("id", "in", (Object)pkId);
        return SERVICE_HELPER.queryOriginalOne("id,reviewobject.id,person.id,employee.id,calibrateresult,calibratereason,calibratebefore", new QFilter[]{idFilter});
    }

    public boolean isOnlinePersonExists(Long calSessionId, Long personId) {
        QFilter sessionFilter = new QFilter("calibratesession.id", "=", (Object)calSessionId);
        QFilter personFilter = new QFilter("person.id", "=", (Object)personId);
        return SERVICE_HELPER.isExists(new QFilter[]{sessionFilter, personFilter});
    }

    public DynamicObject[] listOnlineCalibrationByReviewObject(List<Long> reviewObjectIds, List<Long> sessionIds) {
        QFilter idFilter = new QFilter("reviewobject", "in", reviewObjectIds);
        QFilter sessionFilter = new QFilter("calibratesession", "in", sessionIds);
        return SERVICE_HELPER.queryOriginalArray("id,person.id,person.number,person.name,person.headsculpture,calibrateresult,calibratereason,calibratebefore,reviewactivity.id,reviewactivity.name,reviewactivity.number,reviewobject.id,calibratesession.id,calibratesession.name,calibratesession.number,calibratesession.modifytime", new QFilter[]{idFilter, sessionFilter});
    }

    public Map<Long, Integer> queryCalibrationSessionAdjustNum(List<Long> sessionIds) {
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>(sessionIds.size());
        QFilter sessionFilter = new QFilter("calibratesession", "in", sessionIds);
        DataSet dataSet = SERVICE_HELPER.queryDataSet(this.getClass().getName(), "id,calibratesession,calibrateresult,calibratebefore", new QFilter[]{sessionFilter});
        if (dataSet.isEmpty()) {
            return resultMap;
        }
        dataSet = dataSet.filter(new FilterFunction(){
            private static final long serialVersionUID = 152330357246737052L;

            public boolean test(Row row) {
                String calibrateBefore = row.getString("calibratebefore");
                String calibrateResult = row.getString("calibrateresult");
                return HRStringUtils.isNotEmpty((String)calibrateResult) && !HRStringUtils.equals((String)calibrateBefore, (String)calibrateResult);
            }
        });
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"calibratesession"});
        groupbyDataSet = groupbyDataSet.count("count");
        DataSet dataSetResult = groupbyDataSet.finish();
        for (Row row : dataSetResult) {
            Long sessionId = row.getLong("calibratesession");
            Integer count = row.getInteger("count");
            resultMap.put(sessionId, count);
        }
        dataSet.close();
        dataSetResult.close();
        return resultMap;
    }
}

