/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.queryservice;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.tdc.oatr.bussiness.domain.invoke.InvokeHandler;
import kd.tdc.oatr.bussiness.domain.invoke.InvokeParam;
import org.apache.commons.collections4.MapUtils;

public class PersonAboutQueryService {
    private static final Log log = LogFactory.getLog(PersonAboutQueryService.class);

    public Map<Long, DynamicObject> getPersonInfo(List<Long> personIds) {
        HRBaseServiceHelper hrpiPerson = new HRBaseServiceHelper("hrpi_person");
        QFilter isCurFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] persons = hrpiPerson.queryOriginalArray("id,boid", new QFilter[]{new QFilter("id", "in", personIds), isCurFilter});
        return Arrays.stream(persons).collect(Collectors.toMap(obj -> obj.getLong("id"), Function.identity(), (v1, v2) -> v1));
    }

    public Map<Long, List<Map<String, Object>>> getDirectSuperior(List<Long> personIds) {
        if (CollectionUtils.isEmpty(personIds)) {
            return new HashMap<Long, List<Map<String, Object>>>(0);
        }
        HashMap superiorInfo = Maps.newHashMapWithExpectedSize((int)personIds.size());
        int batchNum = 500;
        int size = personIds.size();
        int queryTimes = size / batchNum + 1;
        int fromIdx = 0;
        int toIdx = Math.min(batchNum, size);
        for (int i = 0; i < queryTimes; ++i) {
            List<Long> subPersonIds = personIds.subList(fromIdx, toIdx);
            Map subSuperiorInfo = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIWorkRoleService", (String)"getDirectSuperior", (Object[])new Object[]{subPersonIds});
            superiorInfo.putAll(subSuperiorInfo);
            fromIdx = toIdx;
            toIdx = Math.min(toIdx + batchNum, size);
        }
        if (CollectionUtils.isEmpty((Map)superiorInfo)) {
            log.info("IHRPIWorkRoleService#getDirectSuperior return null");
            return Maps.newHashMap();
        }
        return superiorInfo;
    }

    public List<Map<String, Object>> getCardFields(List<Long> ermanFileIds) {
        List maps = (List)HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{ermanFileIds});
        if (CollectionUtils.isEmpty((Collection)maps)) {
            throw new KDBizException("IHSPMService#getCardFields return null");
        }
        return maps;
    }

    public Map<Long, DynamicObject> listPrimaryErmanFile(List<Long> personIds) {
        Map ermanFilesMap = (Map)HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"listPrimaryErmanFile", (Object[])new Object[]{personIds});
        if (CollectionUtils.isEmpty((Map)ermanFilesMap)) {
            log.info("generatorNotJoinedReviewObject_listPrimaryErmanFile is empty, params is {}", personIds);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4eba\u5458\u6863\u6848\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonAboutQueryService_0", (String)"tdc-oatr-business", (Object[])new Object[0]));
        }
        return ermanFilesMap;
    }

    public Map<String, Object> getUserByPersonIds(List<Long> personIds) {
        HashMap<String, List<Long>> queryMap = new HashMap<String, List<Long>>(4);
        queryMap.put("person", personIds);
        return (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{queryMap});
    }

    public Map<Long, Long> getUserPersonMap(List<Long> personIds) {
        Map<String, Object> userRet = this.getUserByPersonIds(personIds);
        Boolean success = (Boolean)userRet.get("success");
        if (success.booleanValue()) {
            Map data = (Map)userRet.get("data");
            return data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entrySet -> {
                Map value = (Map)entrySet.getValue();
                if (MapUtils.isNotEmpty((Map)value)) {
                    return (Long)value.get("user");
                }
                return 0L;
            }, (k1, k2) -> k1));
        }
        log.info("IHRPIPersonService#getUserIdByPersonInfo return fail: {}", personIds);
        return Collections.emptyMap();
    }

    public List<Map<String, Object>> listBatchEmployeeByPerson(List<Long> personIds, QFilter qFilter, String attachEntityName) {
        InvokeParam invokeParam = new InvokeParam("hrmp", "hrpi", "IHRPIEmployeeService", "listBatchEmployeeByPerson");
        return (List)InvokeHandler.getInstance().invokeService(invokeParam, personIds, qFilter, attachEntityName);
    }

    public Map<Long, Boolean> getPersonInAndQuit(List<Long> personIds) {
        List<Map<String, Object>> employeeInfos = this.listBatchEmployeeByPerson(personIds, null, "hrpi_empentrel");
        if (CollectionUtils.isEmpty(employeeInfos)) {
            return Collections.emptyMap();
        }
        return employeeInfos.stream().collect(Collectors.toMap(emp -> (Long)emp.get("person_id"), emp -> (Long)emp.get("labrelstatusprd_id") == 1020L, (k1, k2) -> k1));
    }
}

