/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.queryservice;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ext.PermissionExternalService;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;

public class ReviewActivityQueryService {
    private static final HRBaseServiceHelper REVIEW_ACTIVITY_HELPER = new HRBaseServiceHelper("oatr_reviewactivity");
    private static final PermissionExternalService permissionExternalService = ServiceFactory.getService(PermissionExternalService.class);
    private static final String ALGO_KEY = "kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService";
    private static final Log LOG = LogFactory.getLog(ReviewActivityQueryService.class);

    public boolean getReviewActivityEnd(Object activityId) {
        DynamicObject reviewActivity = this.getReviewActivity(activityId);
        if (reviewActivity == null) {
            return false;
        }
        String activityStatus = reviewActivity.getString("activitystatus");
        return ActivityStatusEnum.END.getCode().equals(activityStatus) || ActivityStatusEnum.STOP.getCode().equals(activityStatus);
    }

    public boolean getReviewActivityIng(DynamicObject activity) {
        String activityStatus = activity.getString("activitystatus");
        return ActivityStatusEnum.WAIT_START.getCode().equals(activityStatus) || ActivityStatusEnum.GOING.getCode().equals(activityStatus);
    }

    public boolean getReviewActivityEnd(DynamicObject reviewActivity) {
        String activityStatus = reviewActivity.getString("activitystatus");
        return ActivityStatusEnum.END.getCode().equals(activityStatus) || ActivityStatusEnum.STOP.getCode().equals(activityStatus);
    }

    public DynamicObject getReviewActivity(Object activityId) {
        return REVIEW_ACTIVITY_HELPER.queryOne("number,name,activitystatus,perscopefilter_tag,startdate,enddate,description,collaboratornum,reviewtype,createorg,adminorgentry.adminorgvid,adminorgentry.includesub", new QFilter[]{new QFilter("id", "=", activityId)});
    }

    public DynamicObject[] queryReviewActivity() {
        return REVIEW_ACTIVITY_HELPER.loadDynamicObjectArray(new QFilter[0]);
    }

    public DynamicObject[] queryReviewActivity(List<Long> idList) {
        QFilter idFilter = new QFilter("id", "in", idList);
        return REVIEW_ACTIVITY_HELPER.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    public int countReviewActivity() {
        return this.countReviewActivity(null);
    }

    public int countReviewActivity(QFilter[] filters) {
        return REVIEW_ACTIVITY_HELPER.count(REVIEW_ACTIVITY_HELPER.getEntityName(), filters);
    }

    public DataSet queryDataSet(String field, QFilter[] filters, String orderBy, int limit) {
        return REVIEW_ACTIVITY_HELPER.queryDataSet(ALGO_KEY, field, filters, orderBy, limit);
    }

    public boolean isExists(Object pk) {
        return REVIEW_ACTIVITY_HELPER.isExists(pk);
    }

    public DynamicObjectCollection listReviewActivity(List<Long> activityIds) {
        int maxDBQuerySize;
        DynamicObjectCollection reviewActivities = new DynamicObjectCollection();
        int size = activityIds.size();
        if (size <= (maxDBQuerySize = 500000)) {
            DynamicObject[] activities = this.queryReviewActivityById(activityIds);
            reviewActivities.addAll(Arrays.asList(activities));
            return reviewActivities;
        }
        int batch = size / maxDBQuerySize + 1;
        for (int i = 0; i < batch; ++i) {
            int fromIndex = i * maxDBQuerySize;
            int toIndex = Math.min(i * maxDBQuerySize + maxDBQuerySize, size);
            List<Long> subActivityIds = activityIds.subList(fromIndex, toIndex);
            DynamicObject[] subReviewActivities = this.queryReviewActivityById(subActivityIds);
            reviewActivities.addAll(Arrays.asList(subReviewActivities));
        }
        return reviewActivities;
    }

    private DynamicObject[] queryReviewActivityById(List<Long> activityIds) {
        QFilter idFilter = new QFilter("id", "in", activityIds);
        return REVIEW_ACTIVITY_HELPER.query("id,number,name,finishtime,activitystatus,reviewtype.number,reviewtype.name,talentmapentry,talentmapentry.xaxisdim,talentmapentry.yaxisdim,talentmapentry.talentmapconfig_tag", new QFilter[]{idFilter});
    }

    public DynamicObject[] getReviewObjectWithPerm(Object activityId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewobject");
        QFilter activityQF = new QFilter("reviewactivity", "=", activityId);
        HasPermOrgResult permOrgResult = permissionExternalService.getAllPermOrgs("oatr_reviewobject", "47150e89000000ac");
        QFilter talentFileOrgQF = null;
        if (!permOrgResult.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgResult.getHasPermOrgs();
            talentFileOrgQF = new QFilter("talentfile.org", "in", (Object)hasPermOrgs);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(activityQF);
        if (talentFileOrgQF != null) {
            filters.add(talentFileOrgQF);
        }
        DynamicObject[] dynamicObjects = serviceHelper.query("name,number,reviewstatus,reviewgroup,reviewactivity", filters.toArray(new QFilter[0]));
        List<Long> reviewObjectIdList = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        LOG.info("getReviewObjectWithPerm.reviewObject:{}", reviewObjectIdList);
        Map<Long, Boolean> dataPermResult = this.getDataPermResult(reviewObjectIdList);
        if (CollectionUtils.isEmpty(dataPermResult)) {
            return dynamicObjects;
        }
        return (DynamicObject[])Arrays.stream(dynamicObjects).filter(dy -> (Boolean)dataPermResult.get(dy.getLong("id"))).toArray(DynamicObject[]::new);
    }

    private Map<Long, Boolean> getDataPermResult(List<Long> pkValueList) {
        Map result = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSDataPermissionService", (String)"matchDataRule", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "32J2T2KEXE6T", "oatr_reviewobject", "47150e89000000ac", new QFilter[]{new QFilter("id", "in", pkValueList)}, Maps.newHashMapWithExpectedSize((int)1)});
        LOG.info("getDataPermResult.param:{}   result:{}", pkValueList, (Object)result);
        return result;
    }
}

