/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.queryservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ReviewObjectQueryService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("oatr_reviewobject");

    public DynamicObject[] getReviewObjectEntity(List<Long> pkIds) {
        QFilter idQFilter = new QFilter("id", "in", pkIds);
        return HELPER.query("entryentity_eval,entryentity_eval.evaltool,reviewgroup,entryentity_eval.evaluationitem,entryentity_eval.evalvalue,entryentity_mapbefore,entryentity_dimeval.evaldim,entryentity_dimeval.dimevalitem,entryentity_dimeval.dimevalvalue,entryentity_mapbefore.mapbeforekey,entryentity_mapbefore.mapbeforevalue,entryentity_dimension,entryentity_dimension.dimension,entryentity_dimension.dimensionvalue,entryentity_dimension.dimorigvalue,entryentity_map,entryentity_map.mapkey,entryentity_map.mapvalue,reviewgroup.id,errormsgentry.errormsgcontent", new QFilter[]{idQFilter});
    }

    public DynamicObject[] getReviewObjectData(Long activityId, List<Long> personIds) {
        QFilter activityIdQFilter = new QFilter("reviewactivity.id", "=", (Object)activityId);
        QFilter personIdQFilter = new QFilter("personboid", "in", personIds);
        return HELPER.query("id,person.id,personboid,reviewstatus,company,company.number,company.name,adminorg,adminorg.number,adminorg.name,pospattern,position,position.number,position.name,stdposition,stdposition.number,stdposition.name,job,job.number,job.name,supereval,entryentity_dimension,entryentity_dimension.dimension,entryentity_dimension.dimensionvalue", new QFilter[]{activityIdQFilter, personIdQFilter});
    }

    public DynamicObject[] getReviewObjectData(List<Long> pkIds) {
        QFilter idQFilter = new QFilter("id", "in", pkIds);
        return HELPER.query("id,person,personboid,reviewstatus,supereval,talentfile.employee,company,company.number,company.name,adminorg,adminorg.number,adminorg.name,pospattern,position,position.number,position.name,stdposition,stdposition.number,stdposition.name,job,job.number,job.name,entryentity_mapbefore,entryentity_mapbefore.mapbeforekey,entryentity_mapbefore.mapbeforevalue,entryentity_map,entryentity_map.mapkey,entryentity_map.mapvalue,entryentity_dimension,entryentity_dimension.dimension,entryentity_dimension.dimensionvalue", new QFilter[]{idQFilter});
    }

    public DynamicObject[] getReviewObjectData(Long activityId) {
        QFilter activityIdQFilter = new QFilter("reviewactivity.id", "=", (Object)activityId);
        return HELPER.query("id,person.id,personboid,reviewstatus,talentfile", new QFilter[]{activityIdQFilter});
    }

    public List<Long> getReviewObjectReviewGroup(List<Long> pkIds) {
        QFilter idQFilter = new QFilter("id", "in", pkIds);
        DynamicObject[] reviewObjs = HELPER.queryOriginalArray("id,person,personboid,reviewstatus,reviewgroup.id", new QFilter[]{idQFilter});
        return Arrays.stream(reviewObjs).map(reviewObj -> reviewObj.getLong("reviewgroup.id")).distinct().collect(Collectors.toList());
    }

    public DynamicObject[] listReviewObjectData(List<Long> activityIds) {
        int maxDBQuerySize;
        int size = activityIds.size();
        if (size <= (maxDBQuerySize = 500000)) {
            return this.getReviewObjects(activityIds);
        }
        ArrayList reviewObjects = Lists.newArrayListWithExpectedSize((int)10);
        int batch = size / maxDBQuerySize + 1;
        for (int i = 0; i < batch; ++i) {
            int fromIndex = i * maxDBQuerySize;
            int toIndex = Math.min(i * maxDBQuerySize + maxDBQuerySize, size);
            List<Long> subActivityIds = activityIds.subList(fromIndex, toIndex);
            DynamicObject[] subReviewObjects = this.getReviewObjects(subActivityIds);
            reviewObjects.addAll(Arrays.asList(subReviewObjects));
        }
        return reviewObjects.toArray(new DynamicObject[0]);
    }

    private DynamicObject[] getReviewObjects(List<Long> activityIds) {
        QFilter activityIdQFilter = new QFilter("reviewactivity.id", "in", activityIds);
        return HELPER.query("id,person,reviewactivity,reviewstatus,supereval,talentfile,talentfile.employee,entryentity_map,entryentity_map.mapkey,entryentity_map.mapvalue,entryentity_map.calibratesession,entryentity_mapbefore,entryentity_mapbefore.mapbeforekey,entryentity_mapbefore.mapbeforevalue,entryentity_mapres,entryentity_mapres.mapkeyres,entryentity_mapres.mapvalueres,entryentity_mapres.calibratesessionres", new QFilter[]{activityIdQFilter});
    }

    public DynamicObject[] listReviewObjectDataWithFilter(List<Long> pkIds, List<QFilter> filters) {
        QFilter idQFilter = new QFilter("id", "in", pkIds);
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)(filters.size() + 1));
        filterList.add(idQFilter);
        filterList.addAll(filters);
        return HELPER.query("id,person,personboid,reviewstatus,talentfile", filterList.toArray(new QFilter[0]));
    }

    public DynamicObject[] listReviewObjectIdWithFilter(QFilter[] filters) {
        return HELPER.query("id", filters);
    }
}

