/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.queryservice;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.queryservice.PersonAboutQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewEmpEvalQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewSuperiorEvalQueryService;
import kd.tdc.oatr.common.utils.JsonUtils;
import kd.tdc.tdcs.common.util.UrlBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ReviewQuestionService {
    private static final Log log = LogFactory.getLog(ReviewQuestionService.class);
    private final ReviewEmpEvalQueryService empService = ServiceFactory.getService(ReviewEmpEvalQueryService.class);
    private final ReviewSuperiorEvalQueryService superiorService = ServiceFactory.getService(ReviewSuperiorEvalQueryService.class);
    private final PersonAboutQueryService personAboutQueryService = ServiceFactory.getService(PersonAboutQueryService.class);

    public void terminateQuestionByTerminal(List<Long> reviewObjIds) {
        this.terminateQuestion(reviewObjIds, ResManager.loadKDString((String)"\u57fa\u4e8e\u7ec8\u6b62\u76d8\u70b9\u6267\u884c\u95ee\u5377\u7ec8\u6b62", (String)"ReviewQuestionService_3", (String)"tdc-oatr-business", (Object[])new Object[0]));
    }

    public void terminateQuestionByDelete(List<Long> reviewObjIds) {
        this.terminateQuestion(reviewObjIds, ResManager.loadKDString((String)"\u57fa\u4e8e\u76d8\u70b9\u5bf9\u8c61\u5220\u9664\u6267\u884c\u95ee\u5377\u7ec8\u6b62", (String)"ReviewQuestionService_0", (String)"tdc-oatr-business", (Object[])new Object[0]));
    }

    public void terminateQuestionByPerson(Map<Long, Set<Long>> evalMap) {
        if (MapUtils.isNotEmpty(evalMap)) {
            Set<Long> reviewObjIds = evalMap.keySet();
            ArrayList<Long> reviewObjIdList = new ArrayList<Long>(reviewObjIds);
            DynamicObject[] superiorQuestion = this.superiorService.listToBeSubmittedQuestionByObject(reviewObjIdList);
            ArrayList terminateQuestion = Lists.newArrayList();
            for (DynamicObject question : superiorQuestion) {
                long evalId = question.getLong("evaluator.id");
                long reviewObjId = question.getLong("reviewobject.id");
                Set<Long> evalIds = evalMap.get(reviewObjId);
                if (!CollectionUtils.isNotEmpty(evalIds) || !evalIds.contains(evalId)) continue;
                terminateQuestion.add(question);
            }
            if (CollectionUtils.isNotEmpty((Collection)terminateQuestion)) {
                this.terminateQuestion(superiorQuestion, ResManager.loadKDString((String)"\u57fa\u4e8e\u4fee\u6539\u8bc4\u4ef7\u4eba\u6267\u884c\u95ee\u5377\u7ec8\u6b62", (String)"ReviewQuestionService_2", (String)"tdc-oatr-business", (Object[])new Object[0]));
                this.superiorService.save(terminateQuestion.toArray(new DynamicObject[0]));
                this.retractMessage(terminateQuestion.toArray(new DynamicObject[0]));
            }
        }
    }

    public void terminateQuestion(List<Long> reviewObjIds, String terminateDesc) {
        this.terminateEmpQuestion(reviewObjIds, terminateDesc);
        this.terminateSuperiorQuestion(reviewObjIds, terminateDesc);
    }

    public void terminateEmpQuestion(List<Long> reviewObjIds, String terminateDesc) {
        DynamicObject[] empQuestion = this.empService.listToBeSubmittedQuestionByObject(reviewObjIds);
        this.terminateQuestion(empQuestion, terminateDesc);
        this.empService.save(empQuestion);
        this.retractMessage(empQuestion);
    }

    public void terminateSuperiorQuestion(List<Long> reviewObjIds, String terminateDesc) {
        DynamicObject[] superiorQuestion = this.superiorService.listToBeSubmittedQuestionByObject(reviewObjIds);
        this.terminateQuestion(superiorQuestion, terminateDesc);
        this.superiorService.save(superiorQuestion);
        this.retractMessage(superiorQuestion);
    }

    public void terminateQuestion(DynamicObject[] terminalQuestion, String terminateDesc) {
        for (DynamicObject dynamicObject : terminalQuestion) {
            dynamicObject.set("evalstatus", (Object)"C");
            dynamicObject.set("terminatedesc", (Object)terminateDesc);
        }
    }

    public void retractMessage(DynamicObject[] terminalQuestion) {
        List<Long> messageIds = Arrays.stream(terminalQuestion).map(obj -> obj.getLong("messageid")).collect(Collectors.toList());
        log.info("ReviewQuestionService.retractMessage: msgIds={}", messageIds);
        messageIds.forEach(MessageCenterServiceHelper::retractMessage);
    }

    public void sendEmpQuestionMessage(DynamicObject[] dataEntities, OperateOption option) {
        String variableValue = option.getVariableValue("evalObjIds", null);
        if (variableValue != null) {
            List reviewEvalObjIds = (List)JsonUtils.toObject((String)variableValue, (TypeReference)new TypeReference<List<Long>>(){});
            DynamicObject[] evalObjs = this.empService.listToBeSubmittedQuestion(new QFilter[]{new QFilter("id", "in", (Object)reviewEvalObjIds)});
            int i = 0;
            for (DynamicObject evalObj : evalObjs) {
                long receiverUserId = evalObj.getLong("evaluator_id");
                if (receiverUserId == 0L) continue;
                String title = String.format(ResManager.loadKDString((String)"%s\u7684\u5458\u5de5\u804c\u4e1a\u53d1\u5c55\u610f\u5411\u95ee\u5377", (String)"ReviewActivityApplicationService_1", (String)"tdc-oatr-business", (Object[])new Object[0]), dataEntities[i].getString("name"));
                String tag = ResManager.loadKDString((String)"\u5458\u5de5\u76d8\u70b9\u95ee\u5377", (String)"ReviewActivityApplicationService_2", (String)"tdc-oatr-business", (Object[])new Object[0]);
                String content = ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u4efd\u5458\u5de5\u804c\u4e1a\u53d1\u5c55\u610f\u5411\u95ee\u5377\u5f85\u586b\u5199\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"ReviewActivityApplicationService_3", (String)"tdc-oatr-business", (Object[])new Object[0]);
                String contentSelfUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "oatr_employeeeval").setParameter("pkId", String.valueOf(evalObj.get("id"))).builder();
                long messageId = this.sendMessage(title, tag, content, Lists.newArrayList((Object[])new Long[]{receiverUserId}), "oatr_employeeeval", contentSelfUrl);
                evalObj.set("messageid", (Object)messageId);
                ++i;
            }
            this.empService.save(evalObjs);
        }
    }

    public void sendSuperiorQuestionMessage(DynamicObject[] dataEntities, Map<Long, Set<Long>> selectSuperiorMap, long activityId, OperateOption option) {
        String variableValue = option.getVariableValue("evalObjIds", null);
        if (variableValue != null) {
            List reviewEvalObjIds = (List)JsonUtils.toObject((String)variableValue, (TypeReference)new TypeReference<List<Long>>(){});
            DynamicObject[] evalObjs = this.superiorService.listToBeSubmittedQuestion(new QFilter[]{new QFilter("id", "in", (Object)reviewEvalObjIds)});
            Map reviewObjMap = Arrays.stream(dataEntities).collect(Collectors.toMap(obj -> obj.getLong("id"), Function.identity()));
            List<Long> superiorPersonIds = selectSuperiorMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            Map<Long, Long> userPersonMap = this.personAboutQueryService.getUserPersonMap(superiorPersonIds);
            for (DynamicObject evalObj : evalObjs) {
                long reviewObjId = evalObj.getLong("reviewobject_id");
                long evaluator = evalObj.getLong("evaluator_id");
                Long receiverUserId = userPersonMap.get(evaluator);
                if (Objects.isNull(receiverUserId)) continue;
                String title = String.format(ResManager.loadKDString((String)"%s\u7684\u7ecf\u7406\u4eba\u7efc\u5408\u8bc4\u4ef7\u95ee\u5377", (String)"ReviewActivityApplicationService_4", (String)"tdc-oatr-business", (Object[])new Object[0]), ((DynamicObject)reviewObjMap.get(reviewObjId)).getString("reviewactivity.name"));
                String tag = ResManager.loadKDString((String)"\u4e0a\u7ea7\u76d8\u70b9\u95ee\u5377", (String)"ReviewActivityApplicationService_5", (String)"tdc-oatr-business", (Object[])new Object[0]);
                String content = ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u4efd\u7ecf\u7406\u4eba\u7efc\u5408\u8bc4\u4ef7\u95ee\u5377\u5f85\u586b\u5199\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"ReviewActivityApplicationService_6", (String)"tdc-oatr-business", (Object[])new Object[0]);
                String contentSelfUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "oatr_superiorevalaggre").setParameter("questionId", String.valueOf(evalObj.get("id"))).setParameter("activityId", String.valueOf(activityId)).setParameter("personId", String.valueOf(evaluator)).builder();
                long messageId = this.sendMessage(title, tag, content, Lists.newArrayList((Object[])new Long[]{receiverUserId}), "oatr_superioreval", contentSelfUrl);
                evalObj.set("messageid", (Object)messageId);
            }
            this.superiorService.save(evalObjs);
        }
    }

    public long sendMessage(String title, String tag, String content, List<Long> receiverId, String entityNumber, String url) {
        log.info("ReviewQuestionService.sendMessage: receiverId={},entityNumber={}", receiverId, (Object)entityNumber);
        MessageInfo message = new MessageInfo();
        message.setType("message");
        message.setTitle(title);
        message.setTag(tag);
        message.setUserIds(receiverId);
        message.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
        message.setEntityNumber(entityNumber);
        message.setContentUrl(url);
        message.setContent(content);
        long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        log.info("ReviewQuestionService.sendMessage: send msg success, msgId={}", (Object)msgId);
        return msgId;
    }
}

