/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.queryservice;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ReviewSuperiorEvalQueryService {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("oatr_superioreval");

    public Map<Long, Set<DynamicObject>> getReviewObjectLastQuestion(List<Long> reviewObjIds) {
        DynamicObject[] reviewToolByGroupId = this.getReviewToolByGroupId(reviewObjIds);
        return Arrays.stream(reviewToolByGroupId).collect(Collectors.groupingBy(obj -> obj.getLong("reviewobject.id"), HashMap::new, Collectors.toCollection(() -> new TreeSet((a, b) -> b.getDate("modifytime").compareTo(a.getDate("modifytime"))))));
    }

    public Map<Long, Map<Long, Set<DynamicObject>>> getReviewObjectEvalLastQuestion(List<Long> reviewObjIds) {
        DynamicObject[] reviewToolByGroupId = this.getReviewToolByGroupId(reviewObjIds);
        return Arrays.stream(reviewToolByGroupId).collect(Collectors.groupingBy(obj -> obj.getLong("reviewobject.id"), HashMap::new, Collectors.groupingBy(obj -> obj.getLong("evaluator.id"), HashMap::new, Collectors.toCollection(() -> new TreeSet((a, b) -> b.getDate("modifytime").compareTo(a.getDate("modifytime")))))));
    }

    public DynamicObject[] getReviewToolByGroupId(List<Long> reviewObjIds) {
        QFilter qFilter = new QFilter("reviewobject.id", "in", reviewObjIds);
        return SERVICE_HELPER.query("reviewobject,question,evalstatus,modifytime,evaluator.name", new QFilter[]{qFilter});
    }

    public Map<Long, Long> getReviewObjectQuestionNum(List<Long> reviewObjIds) {
        DynamicObject[] reviewToolByGroupId = this.getReviewToolByGroupId(reviewObjIds);
        return Arrays.stream(reviewToolByGroupId).collect(Collectors.groupingBy(obj -> obj.getLong("reviewobject.id"), Collectors.counting()));
    }

    public DynamicObject[] generatorEvalObjs(int size) {
        DynamicObject[] evalObjs = new DynamicObject[size];
        for (int i = 0; i < size; ++i) {
            evalObjs[i] = SERVICE_HELPER.generateEmptyDynamicObject();
        }
        return evalObjs;
    }

    public void save(DynamicObject[] dataEntities) {
        SERVICE_HELPER.save(dataEntities);
    }

    public DynamicObject[] listToBeSubmittedQuestionByObject(List<Long> reviewObjIds) {
        QFilter objFilter = new QFilter("reviewobject.id", "in", reviewObjIds);
        QFilter statusFilter = new QFilter("evalstatus", "=", (Object)"A");
        return this.listToBeSubmittedQuestion(new QFilter[]{objFilter, statusFilter});
    }

    public DynamicObject[] listToBeSubmittedQuestionByActivityAndUser(long activityId, long userId) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", (Object)activityId);
        QFilter userFilter = new QFilter("evaluator.id", "=", (Object)userId);
        QFilter statusFilter = new QFilter("evalstatus", "=", (Object)"A");
        return this.listToBeSubmittedQuestion(new QFilter[]{activityFilter, userFilter, statusFilter});
    }

    public DynamicObject[] listToBeSubmittedQuestion(QFilter[] qFilters) {
        return SERVICE_HELPER.query("reviewobject,evaluator,evalstatus,messageid,terminatedesc", qFilters);
    }

    public DynamicObject[] listQuestionByActivity(Object activityId, Object personId) {
        QFilter activityFilter = new QFilter("reviewactivity.id", "=", (Object)Long.parseLong(String.valueOf(activityId)));
        QFilter questionStatusFilter = new QFilter("evalstatus", "!=", (Object)"C");
        QFilter userFilter = new QFilter("evaluator.id", "=", (Object)Long.parseLong(String.valueOf(personId)));
        return SERVICE_HELPER.queryOriginalArray("reviewobject.name reviewobject_name,id,evalstatus", new QFilter[]{activityFilter, userFilter, questionStatusFilter}, "reviewobject.number,billno");
    }

    public DynamicObject getQuestionById(Object id) {
        return SERVICE_HELPER.queryOne("id,evalstatus", new QFilter[]{new QFilter("id", "=", id)});
    }
}

