/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.queryservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.domain.reviewgroup.ReviewToolDomainService;

public class ReviewToolQueryService {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("oatr_reviewtool");
    private static final HRBaseServiceHelper INNER_TOOL_HELPER = new HRBaseServiceHelper("oatr_innertoolentity");
    private static final HRBaseServiceHelper OUTER_TOOL_HELPER = new HRBaseServiceHelper("oatr_outertoolentity");
    private final ReviewToolDomainService toolDomainService = ServiceFactory.getService(ReviewToolDomainService.class);

    public DynamicObject getReviewToolByPkId(Object pkId) {
        return SERVICE_HELPER.queryOne(pkId);
    }

    public DynamicObject getReviewToolByActivityId(long activityId) {
        QFilter groupFilter = new QFilter("reviewactivity.id", "=", (Object)activityId);
        return SERVICE_HELPER.queryOne("id,entryentity_inner.questionnaire,entryentity_inner.inner_reviewgroup,entryentity_outer.outer_tool,entryentity_outer.evaluationitem,entryentity_outer.outer_reviewgroup", new QFilter[]{groupFilter});
    }

    public Long queryReviewToolId(long activityId) {
        DynamicObject dynamicObject = SERVICE_HELPER.queryOriginalOne("id", new QFilter("reviewactivity", "=", (Object)activityId));
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getLong("id");
    }

    public Map<Long, List<Long>> getReviewToolOfReviewGroup(long activityId) {
        DynamicObjectCollection outerTools;
        DynamicObject reviewTool = this.getReviewToolByActivityId(activityId);
        HashMap reviewToolOfGroup = Maps.newHashMap();
        if (reviewTool == null) {
            return reviewToolOfGroup;
        }
        DynamicObjectCollection innerTools = reviewTool.getDynamicObjectCollection("entryentity_inner");
        if (innerTools != null && innerTools.size() != 0) {
            for (DynamicObject innerTool : innerTools) {
                DynamicObjectCollection innerReviewGroup = innerTool.getDynamicObjectCollection("inner_reviewgroup");
                if (innerReviewGroup == null || innerReviewGroup.size() == 0) continue;
                for (DynamicObject reviewGroup : innerReviewGroup) {
                    reviewToolOfGroup.computeIfAbsent(reviewGroup.getLong("fbasedataid.id"), k -> Lists.newArrayList()).add(innerTool.getLong("id"));
                }
            }
        }
        if ((outerTools = reviewTool.getDynamicObjectCollection("entryentity_outer")) != null && outerTools.size() != 0) {
            for (DynamicObject outerTool : outerTools) {
                DynamicObjectCollection outerReviewGroup = outerTool.getDynamicObjectCollection("outer_reviewgroup");
                if (outerReviewGroup == null || outerReviewGroup.size() == 0) continue;
                for (DynamicObject reviewGroup : outerReviewGroup) {
                    reviewToolOfGroup.computeIfAbsent(reviewGroup.getLong("fbasedataid.id"), k -> Lists.newArrayList()).add(outerTool.getLong("id"));
                }
            }
        }
        return reviewToolOfGroup;
    }

    public Map<Long, DynamicObject> getReviewInnerTool(List<Long> pkIds) {
        DynamicObject[] dynamicObjects = INNER_TOOL_HELPER.loadDynamicObjectArray(pkIds.toArray(new Object[0]));
        if (dynamicObjects != null && dynamicObjects.length != 0) {
            return Arrays.stream(dynamicObjects).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
        }
        return Maps.newHashMap();
    }

    public Map<Long, DynamicObject> getReviewOuterTool(List<Long> pkIds) {
        DynamicObject[] dynamicObjects = OUTER_TOOL_HELPER.loadDynamicObjectArray(pkIds.toArray(new Object[0]));
        if (dynamicObjects != null && dynamicObjects.length != 0) {
            return Arrays.stream(dynamicObjects).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
        }
        return Maps.newHashMap();
    }
}

