/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;

public class InitReviewResultTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ReviewActivityApplicationService.class);
    private final ReviewActivityApplicationService reviewApplicationService = ServiceFactory.getService(ReviewActivityApplicationService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.updateReviewActivityFinishTime();
        this.syncReviewResult();
    }

    private void syncReviewResult() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewactivity");
        QFilter statusFilter = new QFilter("activitystatus", "=", (Object)"C");
        Object[] activities = serviceHelper.query("id", new QFilter[]{statusFilter});
        if (HRArrayUtils.isEmpty((Object[])activities)) {
            log.info("InitReviewResultTask activity is empty.");
            return;
        }
        List<Long> activityIds = Arrays.stream(activities).map(activity -> activity.getLong("id")).collect(Collectors.toList());
        log.info("InitReviewResultTask param: activityIds = {}", activityIds);
        this.reviewApplicationService.syncReviewResult(activityIds);
    }

    private void updateReviewActivityFinishTime() {
        DynamicObject[] reviewObjects;
        long reviewObjId;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewactivity");
        QFilter actStatusFilter = new QFilter("activitystatus", "=", (Object)"C");
        QFilter finishTimeFilter = new QFilter("finishtime", "is null", null);
        Object[] activities = serviceHelper.query("id,finishtime,modifytime", new QFilter[]{actStatusFilter, finishTimeFilter});
        if (HRArrayUtils.isEmpty((Object[])activities)) {
            return;
        }
        ArrayList updateActivities = Lists.newArrayListWithExpectedSize((int)activities.length);
        for (Object activity : activities) {
            Date finishTime = activity.getDate("finishtime");
            if (finishTime != null) continue;
            activity.set("finishtime", (Object)activity.getDate("modifytime"));
            updateActivities.add(activity);
        }
        serviceHelper.update(updateActivities.toArray(new DynamicObject[0]));
        serviceHelper = new HRBaseServiceHelper("oatr_calibratesession");
        QFilter statusFilter = new QFilter("calibratestatus", "=", (Object)"C");
        DynamicObject[] sessionObjs = serviceHelper.query("number,reviewactivity,talentmap", new QFilter[]{statusFilter});
        List sessionIds = Arrays.stream(sessionObjs).map(sessionObj -> sessionObj.getLong("id")).collect(Collectors.toList());
        Map<Long, String> talentMapKeyMap = Arrays.stream(sessionObjs).collect(Collectors.toMap(sessionObj -> sessionObj.getLong("id"), sessionObj -> sessionObj.getString("talentmap"), (v1, v2) -> v1));
        HRBaseServiceHelper onlineServiceHelper = new HRBaseServiceHelper("oatr_onlinecalibration");
        QFilter sessionFilter = new QFilter("calibratesession", "in", sessionIds);
        DynamicObject[] onlineObjs = onlineServiceHelper.query("reviewactivity,calibratesession,reviewobject,modifytime", new QFilter[]{sessionFilter});
        HashMap sessionIdMap = Maps.newHashMapWithExpectedSize((int)onlineObjs.length);
        HashMap sessionIdDateMap = Maps.newHashMapWithExpectedSize((int)onlineObjs.length);
        for (DynamicObject onlineObj2 : onlineObjs) {
            Date modifyTime = onlineObj2.getDate("modifytime");
            long actId = onlineObj2.getLong("reviewactivity.id");
            long sessionId = onlineObj2.getLong("calibratesession.id");
            String mapKey = talentMapKeyMap.get(sessionId);
            reviewObjId = onlineObj2.getLong("reviewobject.id");
            String key = actId + mapKey + reviewObjId;
            Long time = (Long)sessionIdDateMap.get(key);
            if (time != null && time > modifyTime.getTime()) continue;
            sessionIdDateMap.put(key, modifyTime.getTime());
            sessionIdMap.put(key, sessionId);
        }
        List reviewObjectIds = Arrays.stream(onlineObjs).map(onlineObj -> onlineObj.getLong("reviewobject.id")).distinct().collect(Collectors.toList());
        HRBaseServiceHelper objectServiceHelper = new HRBaseServiceHelper("oatr_reviewobject");
        QFilter idFilter = new QFilter("id", "in", reviewObjectIds);
        for (DynamicObject reviewObject : reviewObjects = objectServiceHelper.query("id,reviewactivity,reviewstatus,talentfile,talentfile.employee,entryentity_map,entryentity_map.mapkey,entryentity_map.mapvalue,entryentity_map.calibratesession", new QFilter[]{idFilter})) {
            long actId = reviewObject.getLong("reviewactivity.id");
            reviewObjId = reviewObject.getLong("id");
            DynamicObjectCollection entryEntityMap = reviewObject.getDynamicObjectCollection("entryentity_map");
            for (DynamicObject entry : entryEntityMap) {
                long sId = entry.getLong("calibratesession.id");
                if (sId != 0L) continue;
                String mapKey = entry.getString("mapkey");
                String key = actId + mapKey + reviewObjId;
                Long sessionId = (Long)sessionIdMap.get(key);
                entry.set("calibratesession", (Object)sessionId);
            }
        }
        objectServiceHelper.update(reviewObjects);
    }
}

