/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.task;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;

public class UpdateBaseDataCtrlStrategyTask
extends AbstractTask {
    private final Log LOGGER = LogFactory.getLog(UpdateBaseDataCtrlStrategyTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean isEvalItemSuccess = this.updateEvaluationItem();
        boolean isEvalSchemeSuccess = this.updateEvaluationScheme();
        boolean isToolSuccess = this.updateReviewToolScheme();
        if (isEvalItemSuccess && isEvalSchemeSuccess && isToolSuccess) {
            this.disableTask();
            this.LOGGER.info("UpdateBaseDataCtrlStrategyTask: disableTask");
        }
    }

    private boolean updateEvaluationItem() {
        return this.updateCtrlBaseData("oatr_evaluationitem");
    }

    private boolean updateEvaluationScheme() {
        return this.updateCtrlBaseData("oatr_evaluationscheme");
    }

    private boolean updateReviewToolScheme() {
        return this.updateCtrlBaseData("oatr_reviewtoolscheme");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateCtrlBaseData(String entityName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter orgFilter = new QFilter("org", "=", (Object)0L).or(new QFilter("org", "is null", null));
        int count = serviceHelper.count(serviceHelper.getEntityName(), new QFilter[]{orgFilter});
        int BATCH_MAXIMUM = 10000;
        int batchNum = count / BATCH_MAXIMUM + 1;
        this.LOGGER.info("UpdateBaseDataCtrlStrategyTask#updateCtrlBaseData: {}, count is {}, batchNum is {}", new Object[]{entityName, count, batchNum});
        long maxId = 0L;
        TXHandle tx = TX.required((String)"UpdateBaseDataCtrlStrategyTask.updateCtrlBaseData.tx");
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        Date currentDate = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        try {
            for (int i = 0; i < batchNum; ++i) {
                QFilter idFilter = new QFilter("id", ">", (Object)maxId);
                DynamicObject[] baseDataObjs = serviceHelper.query("id,ctrlstrategy,createorg,org,useorg,srccreateorg,modifier,modifytime", new QFilter[]{idFilter, orgFilter}, "id asc", BATCH_MAXIMUM);
                if (baseDataObjs.length == 0) continue;
                for (DynamicObject baseDataObj : baseDataObjs) {
                    baseDataObj.set("ctrlstrategy", (Object)"5");
                    baseDataObj.set("createorg", (Object)rootOrgId);
                    baseDataObj.set("org", (Object)rootOrgId);
                    baseDataObj.set("useorg", (Object)rootOrgId);
                    baseDataObj.set("srccreateorg", (Object)rootOrgId);
                    baseDataObj.set("modifier", (Object)currUserId);
                    baseDataObj.set("modifytime", (Object)currentDate);
                }
                maxId = HRDyObjectPropUtil.getId((DynamicObject)baseDataObjs[baseDataObjs.length - 1]);
                serviceHelper.save(baseDataObjs);
            }
        }
        catch (Exception exception) {
            this.LOGGER.error("UpdateBaseDataCtrlStrategyTask#updateCtrlBaseData {} exception", (Object)entityName, (Object)exception);
            tx.markRollback();
            boolean bl = false;
            return bl;
        }
        finally {
            tx.close();
        }
        return true;
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

