/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.activity.ReviewActivityService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;

public class UpdateReviewAdminorgTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(ReviewActivityApplicationService.class);
    private static final int BATCH_MAXIMUM = 10000;
    public static final String ALGO_KEY = "kd.tdc.oatr.bussiness.task.UpdateReviewAdminorgTask";
    private final ReviewActivityQueryService activityQueryService = ServiceFactory.getService(ReviewActivityQueryService.class);
    private final ReviewActivityService activityService = ServiceFactory.getService(ReviewActivityService.class);
    private final ReviewActivityApplicationService reviewApplicationService = ServiceFactory.getService(ReviewActivityApplicationService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean isPlanUpdateSuccess = this.updateReviewPlans();
        boolean isActivityUpdateSuccess = this.updateReviewActivity();
        boolean isReviewObjUpdateSuccess = this.updateReviewObject();
        boolean isFinalReviewResultSuccess = this.updateReviewResultFinal();
        if (isPlanUpdateSuccess && isActivityUpdateSuccess && isReviewObjUpdateSuccess && isFinalReviewResultSuccess) {
            this.disableTask();
        }
    }

    private boolean updateReviewPlans() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewplans");
        int countPlan = serviceHelper.count(serviceHelper.getEntityName(), new QFilter[0]);
        int updateAllSize = 0;
        int batchNum = countPlan / 10000 + 1;
        LOGGER.info("UpdateReviewAdminorgTask.updateReviewPlans: {}, batchNum is {}", (Object)countPlan, (Object)batchNum);
        ArrayList<Long> ids = new ArrayList<Long>(Math.min(10000, countPlan));
        long maxId = 0L;
        int batchIndex = 0;
        DataSet dataSet = null;
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        TXHandle tx = TX.required((String)"UpdateReviewAdminorgTask.updateReviewPlans");
        try {
            for (int i = 0; i < batchNum; ++i) {
                batchIndex = i;
                QFilter idFilter = new QFilter("id", ">", (Object)maxId);
                dataSet = serviceHelper.queryDataSet(ALGO_KEY, "id", new QFilter[]{idFilter}, "id asc ", 10000);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long id = row.getLong("id");
                    ids.add(id);
                    maxId = Math.max(id, maxId);
                }
                int dealCount = 0;
                DynamicObject[] reviewPlansAll = serviceHelper.loadDynamicObjectArray(ids.toArray());
                if (reviewPlansAll == null || reviewPlansAll.length == 0) {
                    boolean bl = true;
                    return bl;
                }
                ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>(10000);
                boolean isModify = false;
                for (DynamicObject reviewPlans : reviewPlansAll) {
                    ++dealCount;
                    DynamicObjectCollection adminorgEntry = reviewPlans.getDynamicObjectCollection("adminorgentry");
                    if (HRCollUtil.isEmpty((Collection)adminorgEntry)) {
                        DynamicObject adminorgRow = adminorgEntry.addNew();
                        adminorgRow.set("adminorgvid", (Object)rootOrgId);
                        adminorgRow.set("adminorgincludesub", (Object)true);
                        isModify = true;
                    }
                    if (!isModify) continue;
                    updateDataList.add(reviewPlans);
                }
                if (!updateDataList.isEmpty()) {
                    serviceHelper.save(updateDataList.toArray(new DynamicObject[0]));
                    int size = updateDataList.size();
                    updateAllSize += size;
                    LOGGER.info("UpdateReviewAdminorgTask.updateReviewPlans#({}/{})reviewplans save successfully! updateData size : {}", new Object[]{i, batchNum, size});
                    List updateIds = updateDataList.stream().map(data -> data.getString("id")).collect(Collectors.toList());
                    LOGGER.info("UpdateReviewAdminorgTask.updateReviewPlans#({}/{})reviewplans save successfully! updateDataId are : {}", new Object[]{i, batchNum, SerializationUtils.toJsonString(updateIds)});
                } else {
                    LOGGER.info("UpdateReviewAdminorgTask.updateReviewPlans#({}/{})reviewplans no data to be update", (Object)i, (Object)batchNum);
                }
                LOGGER.info("UpdateReviewAdminorgTask.updateReviewPlans#process reviewplans: {} / {}", (Object)dealCount, (Object)countPlan);
            }
        }
        catch (Exception exp) {
            LOGGER.error("UpdateReviewAdminorgTask.updateReviewPlans#fail by reviewplans! batch number is ({}/{})", (Object)batchIndex, (Object)batchNum);
            LOGGER.error("UpdateReviewAdminorgTask.updateReviewPlans#fail by reviewplans! exception", (Throwable)exp);
            tx.markRollback();
            throw exp;
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            tx.close();
        }
        LOGGER.info("UpdateReviewAdminorgTask.updateReviewPlans#reviewplans updateAllSize : {}", (Object)updateAllSize);
        return true;
    }

    private boolean updateReviewActivity() {
        int countActivity = this.activityQueryService.countReviewActivity();
        int updateAllSize = 0;
        int batchNum = countActivity / 10000 + 1;
        LOGGER.info("UpdateReviewAdminorgTask.updateReviewActivity: {}, batchNum is {}", (Object)countActivity, (Object)batchNum);
        ArrayList<Long> ids = new ArrayList<Long>(Math.min(10000, countActivity));
        long maxId = 0L;
        int batchIndex = 0;
        DataSet dataSet = null;
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        TXHandle tx = TX.required((String)"UpdateReviewAdminorgTask.updateReviewActivity");
        try {
            for (int i = 0; i < batchNum; ++i) {
                batchIndex = i;
                QFilter idFilter = new QFilter("id", ">", (Object)maxId);
                dataSet = this.activityQueryService.queryDataSet("id", new QFilter[]{idFilter}, "id asc ", 10000);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long id = row.getLong("id");
                    ids.add(id);
                    maxId = Math.max(id, maxId);
                }
                int dealCount = 0;
                DynamicObject[] reviewActivityAll = this.activityQueryService.queryReviewActivity(ids);
                if (reviewActivityAll == null || reviewActivityAll.length == 0) {
                    boolean bl = true;
                    return bl;
                }
                ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>(10000);
                boolean isModify = false;
                for (DynamicObject reviewActivity : reviewActivityAll) {
                    DynamicObjectCollection adminorgEntry;
                    ++dealCount;
                    DynamicObject adminorg = reviewActivity.getDynamicObject("adminorg");
                    if (HRObjectUtils.isEmpty((Object)adminorg)) {
                        reviewActivity.set("adminorg", (Object)rootOrgId);
                        isModify = true;
                    }
                    if (HRCollUtil.isEmpty((Collection)(adminorgEntry = reviewActivity.getDynamicObjectCollection("adminorgentry")))) {
                        DynamicObject adminorgRow = adminorgEntry.addNew();
                        adminorgRow.set("adminorgvid", (Object)rootOrgId);
                        adminorgRow.set("includesub", (Object)true);
                        isModify = true;
                    }
                    if (!isModify) continue;
                    updateDataList.add(reviewActivity);
                }
                if (!updateDataList.isEmpty()) {
                    this.activityService.save(updateDataList.toArray(new DynamicObject[0]));
                    int size = updateDataList.size();
                    updateAllSize += size;
                    LOGGER.info("UpdateReviewAdminorgTask.updateReviewActivity#({}/{})activity save successfully! updateData size : {}", new Object[]{i, batchNum, size});
                    List updateIds = updateDataList.stream().map(data -> data.getString("id")).collect(Collectors.toList());
                    LOGGER.info("UpdateReviewAdminorgTask.updateReviewActivity#({}/{})activity save successfully! updateDataId are : {}", new Object[]{i, batchNum, SerializationUtils.toJsonString(updateIds)});
                } else {
                    LOGGER.info("UpdateReviewAdminorgTask.updateReviewActivity#({}/{})activity no data to be update", (Object)i, (Object)batchNum);
                }
                LOGGER.info("UpdateReviewAdminorgTask.updateReviewActivity#process activity: {} / {}", (Object)dealCount, (Object)countActivity);
            }
        }
        catch (Exception exp) {
            LOGGER.error("UpdateReviewAdminorgTask.updateReviewActivity#fail by activity! batch number is ({}/{})", (Object)batchIndex, (Object)batchNum);
            LOGGER.error("UpdateReviewAdminorgTask.updateReviewActivity#fail by activity! exception", (Throwable)exp);
            tx.markRollback();
            throw exp;
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            tx.close();
        }
        LOGGER.info("UpdateReviewAdminorgTask.updateReviewActivity#activity updateAllSize : {}", (Object)updateAllSize);
        return true;
    }

    private boolean updateReviewObject() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewobject");
        int countReviewObj = serviceHelper.count(serviceHelper.getEntityName(), new QFilter[0]);
        int updateAllSize = 0;
        int batchNum = countReviewObj / 10000 + 1;
        LOGGER.info("UpdateReviewAdminorgTask.updateReviewObject: {}, batchNum is {}", (Object)countReviewObj, (Object)batchNum);
        ArrayList<Long> ids = new ArrayList<Long>(Math.min(10000, countReviewObj));
        long maxId = 0L;
        int pageIndex = 0;
        DataSet dataSet = null;
        TXHandle tx = TX.required((String)"UpdateReviewAdminorgTask.updateReviewObject");
        try {
            for (int i = 0; i < batchNum; ++i) {
                pageIndex = i;
                QFilter idFilter = new QFilter("id", ">", (Object)maxId);
                dataSet = serviceHelper.queryDataSet(ALGO_KEY, "id", new QFilter[]{idFilter}, "id asc ", 10000);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long id = row.getLong("id");
                    ids.add(id);
                    maxId = Math.max(id, maxId);
                }
                int dealCount = 0;
                DynamicObject[] reviewObjectAll = serviceHelper.loadDynamicObjectArray(ids.toArray());
                if (reviewObjectAll == null || reviewObjectAll.length == 0) {
                    boolean bl = true;
                    return bl;
                }
                ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>(10000);
                for (DynamicObject reviewObject : reviewObjectAll) {
                    ++dealCount;
                    DynamicObjectCollection errorMsgEntry = reviewObject.getDynamicObjectCollection("errormsgentry");
                    if (HRCollUtil.isEmpty((Collection)errorMsgEntry)) continue;
                    boolean isModify = false;
                    for (DynamicObject entry : errorMsgEntry) {
                        String errorMsg;
                        String errorMsgType = entry.getString("errormsgtype");
                        if (HRStringUtils.isEmpty((String)errorMsgType) || HRStringUtils.isNotEmpty((String)(errorMsg = entry.getString("errormsgcontent")))) continue;
                        if ("objNotPersonScope".equals(errorMsgType)) {
                            entry.set("errormsgcontent", (Object)ResManager.getLocaleString((String)"\u4e0d\u518d\u7b26\u5408\u76d8\u70b9\u4eba\u5458\u9002\u7528\u8303\u56f4", (String)"ReviewActivityApplicationService_0", (String)"tdc-oatr-business"));
                        } else if ("quit".equals(errorMsgType)) {
                            entry.set("errormsgcontent", (Object)ResManager.getLocaleString((String)"\u5df2\u79bb\u804c", (String)"CommUserQuitService_6", (String)"tdc-oatr-mservice"));
                        } else if ("transfer".equals(errorMsgType)) {
                            entry.set("errormsgcontent", (Object)ResManager.getLocaleString((String)"\u5df2\u8c03\u52a8", (String)"CommUserTransferService_6", (String)"tdc-oatr-mservice"));
                        } else {
                            String errormsgtxt = entry.getString("errormsgtxt");
                            LocaleString localeString = new LocaleString(errormsgtxt);
                            entry.set("errormsgcontent", (Object)localeString);
                        }
                        isModify = true;
                    }
                    if (!isModify) continue;
                    updateDataList.add(reviewObject);
                }
                if (!updateDataList.isEmpty()) {
                    serviceHelper.save(updateDataList.toArray(new DynamicObject[0]));
                    int size = updateDataList.size();
                    updateAllSize += size;
                    LOGGER.info("UpdateReviewAdminorgTask.updateReviewObject#({}/{})reviewobject save successfully! updateData size : {}", new Object[]{i, batchNum, size});
                    List updateIds = updateDataList.stream().map(data -> data.getString("id")).collect(Collectors.toList());
                    LOGGER.info("UpdateReviewAdminorgTask.updateReviewObject#({}/{})reviewobject save successfully! updateDataId are : {}", new Object[]{i, batchNum, SerializationUtils.toJsonString(updateIds)});
                } else {
                    LOGGER.info("UpdateReviewAdminorgTask.updateReviewObject#({}/{})reviewobject no data to be update", (Object)i, (Object)batchNum);
                }
                LOGGER.info("UpdateReviewAdminorgTask.updateReviewObject#process reviewobject: {} / {}", (Object)dealCount, (Object)countReviewObj);
            }
        }
        catch (Exception exp) {
            LOGGER.error("UpdateReviewAdminorgTask.updateReviewObject#fail by reviewobject! batch number is ({}/{})", (Object)pageIndex, (Object)batchNum);
            LOGGER.error("UpdateReviewAdminorgTask.updateReviewObject#fail by reviewobject! exception", (Throwable)exp);
            tx.markRollback();
            throw exp;
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            tx.close();
        }
        LOGGER.info("UpdateReviewAdminorgTask.updateReviewObject#reviewobject updateAllSize : {}", (Object)updateAllSize);
        return true;
    }

    private boolean updateReviewResultFinal() {
        QFilter statusFilter = new QFilter("activitystatus", "=", (Object)ActivityStatusEnum.END.getCode());
        int countActivity = this.activityQueryService.countReviewActivity(new QFilter[]{statusFilter});
        int batchNum = countActivity / 10000 + 1;
        LOGGER.info("UpdateReviewAdminorgTask.updateReviewResultFinal: {}, batchNum is {}", (Object)countActivity, (Object)batchNum);
        ArrayList<Long> ids = new ArrayList<Long>(Math.min(10000, countActivity));
        long maxId = 0L;
        int batchIndex = 0;
        DataSet dataSet = null;
        TXHandle tx = TX.required((String)"UpdateReviewAdminorgTask.updateReviewResultFinal");
        try {
            for (int i = 0; i < batchNum; ++i) {
                batchIndex = i;
                QFilter idFilter = new QFilter("id", ">", (Object)maxId);
                dataSet = this.activityQueryService.queryDataSet("id", new QFilter[]{idFilter, statusFilter}, "id asc ", 10000);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long id = row.getLong("id");
                    ids.add(id);
                    maxId = Math.max(id, maxId);
                }
                this.reviewApplicationService.updateReviewObjReviewResult(ids);
                LOGGER.info("UpdateReviewAdminorgTask.updateReviewObject#({}/{})reviewobject save successfully!", (Object)i, (Object)batchNum);
            }
        }
        catch (Exception exp) {
            LOGGER.error("UpdateReviewAdminorgTask.updateReviewObject#({}/{})reviewobject save fail", (Object)batchIndex, (Object)batchNum);
            LOGGER.error("UpdateReviewAdminorgTask.updateReviewResultFinal#fail by activity! exception", (Throwable)exp);
            tx.markRollback();
            throw exp;
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            tx.close();
        }
        LOGGER.info("UpdateReviewAdminorgTask.updateReviewResultFinal# update success");
        return true;
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)kd.bos.service.ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

