/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.task;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;

public class UpdateReviewPersonNumTask
extends AbstractTask {
    private final Log LOGGER = LogFactory.getLog(UpdateReviewPersonNumTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean isSuccess = this.updateActivityReviewPersonNum();
        if (isSuccess) {
            this.disableTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateActivityReviewPersonNum() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("oatr_reviewactivity");
        QFilter filter = new QFilter("reviewpernum", "=", (Object)0L).or(new QFilter("reviewpernum", "is null", null));
        int count = serviceHelper.count(serviceHelper.getEntityName(), new QFilter[]{filter});
        int BATCH_MAXIMUM = 5000;
        int batchNum = count / BATCH_MAXIMUM + 1;
        this.LOGGER.info("UpdateReviewPersonNumTask#updateActivityReviewPersonNum: count is {}, batchNum is {}", (Object)count, (Object)batchNum);
        long maxId = 0L;
        try (TXHandle tx = TX.required((String)"UpdateReviewPersonNumTask.updateActivityReviewPersonNum.tx");){
            for (int i = 0; i < batchNum; ++i) {
                QFilter idFilter = new QFilter("id", ">", (Object)maxId);
                DynamicObject[] reviewActivityObjs = serviceHelper.query("id,reviewpernum", new QFilter[]{idFilter, filter}, "id asc", BATCH_MAXIMUM);
                if (reviewActivityObjs.length == 0) continue;
                List activityIds = Arrays.stream(reviewActivityObjs).map(activity -> activity.getLong("id")).collect(Collectors.toList());
                QFilter activityFilter = new QFilter("reviewactivity.id", "in", activityIds);
                QFilter reviewGroupFilter = new QFilter("reviewgroup.id", "!=", (Object)0L);
                HRBaseServiceHelper reviewObjHelper = new HRBaseServiceHelper("oatr_reviewobject");
                Object[] reviewObjs = reviewObjHelper.query("id,reviewactivity", new QFilter[]{activityFilter, reviewGroupFilter});
                if (HRArrayUtils.isEmpty((Object[])reviewObjs)) continue;
                Map<Long, List<DynamicObject>> reviewObjGroups = Arrays.stream(reviewObjs).collect(Collectors.groupingBy(reviewObj -> reviewObj.getLong("reviewactivity.id")));
                for (DynamicObject reviewActivity : reviewActivityObjs) {
                    Long activityId = reviewActivity.getLong("id");
                    List<DynamicObject> reviewObjDys = reviewObjGroups.get(activityId);
                    if (!HRCollUtil.isNotEmpty(reviewObjDys)) continue;
                    reviewActivity.set("reviewpernum", (Object)reviewObjDys.size());
                }
                maxId = HRDyObjectPropUtil.getId((DynamicObject)reviewActivityObjs[reviewActivityObjs.length - 1]);
                serviceHelper.save(reviewActivityObjs);
            }
        }
        return true;
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

