/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.bussiness.task;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.activity.ReviewActivityService;
import kd.tdc.oatr.bussiness.domain.activitytpl.ReviewActivityTemplateService;
import kd.tdc.oatr.bussiness.domain.calibrate.CalibrateSessionService;
import kd.tdc.oatr.bussiness.queryservice.CalibrateSessionQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityTplQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewDimensionQueryService;
import kd.tdc.oatr.common.bo.gridtemplate.GridBlockInfo;
import kd.tdc.oatr.common.bo.gridtemplate.GridConfigInfo;
import kd.tdc.oatr.common.bo.talentmap.AxisInfo;
import kd.tdc.oatr.common.bo.talentmap.CommonComboInfo;
import kd.tdc.oatr.common.bo.talentmap.DefaultMapInfo;
import kd.tdc.oatr.common.bo.talentmap.GridTemplateInfo;
import kd.tdc.oatr.common.bo.talentmap.PersonCardDimInfo;
import kd.tdc.oatr.common.bo.talentmap.ReferStrategyInfo;
import kd.tdc.oatr.common.bo.talentmap.TalentMapConfigInfo;
import kd.tdc.oatr.common.constants.enums.TalentMapStrategyEnum;

public class UpdateTalentMapTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(ReviewActivityApplicationService.class);
    private static final int BATCH_MAXIMUM = 10000;
    private final ReviewActivityQueryService activityQueryService = ServiceFactory.getService(ReviewActivityQueryService.class);
    private final ReviewActivityTplQueryService activityTplQueryService = ServiceFactory.getService(ReviewActivityTplQueryService.class);
    private final ReviewDimensionQueryService reviewDimensionQueryService = ServiceFactory.getService(ReviewDimensionQueryService.class);
    private final ReviewActivityService activityService = ServiceFactory.getService(ReviewActivityService.class);
    private final ReviewActivityTemplateService activityTplService = ServiceFactory.getService(ReviewActivityTemplateService.class);
    private final CalibrateSessionQueryService calSessionQueryService = ServiceFactory.getService(CalibrateSessionQueryService.class);
    private final CalibrateSessionService calibrateSessionService = ServiceFactory.getService(CalibrateSessionService.class);
    private final Map<Long, DynamicObject> dimensionData = new HashMap<Long, DynamicObject>(16);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean isActivitySuccess = this.updateActivity();
        boolean isActTplSuccess = this.updateActivityTpl();
        boolean isSessionSuccess = this.updateSession();
        boolean isReviewResultSuccess = this.updateReviewResult();
        if (isActivitySuccess && isActTplSuccess && isSessionSuccess && isReviewResultSuccess) {
            this.disableTask();
        }
    }

    private boolean updateReviewResult() {
        HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("tdcs_reviewresult");
        int countReviewResult = SERVICE_HELPER.count(SERVICE_HELPER.getEntityName(), new QFilter[0]);
        int updateAllSize = 0;
        int batchNum = countReviewResult / 10000 + 1;
        LOGGER.info("UpdateTalentMapTask#countReviewResult: {}, batchNum is {}", (Object)countReviewResult, (Object)batchNum);
        ArrayList<Long> idList = new ArrayList<Long>(Math.min(10000, countReviewResult));
        long maxId = 0L;
        int batchIndex = 0;
        DataSet dataSet = null;
        int dealCount = 0;
        TXHandle actTplTXHandle = TX.required((String)"UpdateTalentMapTask.reviewResultTXHandle");
        try {
            for (int i = 0; i < batchNum; ++i) {
                batchIndex = i;
                QFilter idFilter = new QFilter("id", ">", (Object)maxId);
                dataSet = SERVICE_HELPER.queryDataSet("UpdateTalentMapTask.updateReviewResult", "id", new QFilter[]{idFilter}, "id asc ", 10000);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long id = row.getLong("id");
                    idList.add(id);
                    maxId = Math.max(id, maxId);
                }
                QFilter filter = new QFilter("id", "in", idList);
                DynamicObject[] reviewResultObjs = SERVICE_HELPER.query("id,xdimname,ydimname,positionnumber,gridmap_tag", new QFilter[]{filter});
                if (reviewResultObjs == null || reviewResultObjs.length == 0) {
                    boolean bl = true;
                    return bl;
                }
                ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>(10000);
                for (DynamicObject reviewResult : reviewResultObjs) {
                    ++dealCount;
                    String mapConfigStr = reviewResult.getString("gridmap_tag");
                    if (HRStringUtils.isEmpty((String)mapConfigStr)) continue;
                    Map oldMapConfigMap = (Map)SerializationUtils.fromJsonString((String)mapConfigStr, Map.class);
                    if (oldMapConfigMap.containsKey("defaultMap")) {
                        LOGGER.info("UpdateTalentMapTask#reviewResult id: {}, no need to update.", (Object)HRDyObjectPropUtil.getId((DynamicObject)reviewResult));
                        continue;
                    }
                    Map<String, Object> updateParams = this.getUpdateParamsFromReviewResult();
                    TalentMapConfigInfo talentMapConfigInfo = this.updateOldMapDataToNewMapData(mapConfigStr, updateParams);
                    updateDataList.add(reviewResult);
                    reviewResult.set("gridmap_tag", (Object)SerializationUtils.toJsonString((Object)talentMapConfigInfo));
                }
                if (!updateDataList.isEmpty()) {
                    SERVICE_HELPER.save(updateDataList.toArray(new DynamicObject[0]));
                    int size = updateDataList.size();
                    updateAllSize += size;
                    LOGGER.info("UpdateTalentMapTask#({}/{})reviewResult save successfully! updateData size : {}", new Object[]{i, batchNum, size});
                    List updateIds = updateDataList.stream().map(data -> data.getString("id")).collect(Collectors.toList());
                    LOGGER.info("UpdateTalentMapTask#({}/{})reviewResult save successfully! updateDataId are : {}", new Object[]{i, batchNum, SerializationUtils.toJsonString(updateIds)});
                    continue;
                }
                LOGGER.info("UpdateTalentMapTask#({}/{})reviewResult no data to be update", (Object)i, (Object)batchNum);
            }
        }
        catch (Exception exp) {
            LOGGER.error("UpdateTalentMapTask#fail by reviewResult! batch number is ({}/{})", (Object)batchIndex, (Object)batchNum);
            LOGGER.error("UpdateTalentMapTask#fail by reviewResult! exception", (Throwable)exp);
            actTplTXHandle.markRollback();
            throw exp;
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            actTplTXHandle.close();
            LOGGER.info("UpdateTalentMapTask#process actTpl: {} / {}", (Object)dealCount, (Object)countReviewResult);
        }
        LOGGER.info("UpdateTalentMapTask#reviewResult updateAllSize : {}", (Object)updateAllSize);
        return true;
    }

    private boolean updateSession() {
        int countCalibrateSession = this.calSessionQueryService.countCalibrateSession();
        int updateAllSize = 0;
        int batchNum = countCalibrateSession / 10000 + 1;
        LOGGER.info("UpdateTalentMapTask#countCalibrateSession: {}, batchNum is {}", (Object)countCalibrateSession, (Object)batchNum);
        ArrayList<Long> idList = new ArrayList<Long>(Math.min(10000, countCalibrateSession));
        long maxId = 0L;
        int batchIndex = 0;
        DataSet dataSet = null;
        int dealCount = 0;
        TXHandle actTplTXHandle = TX.required((String)"UpdateTalentMapTask.sessionTXHandle");
        try {
            for (int i = 0; i < batchNum; ++i) {
                batchIndex = i;
                QFilter idFilter = new QFilter("id", ">", (Object)maxId);
                dataSet = this.calSessionQueryService.queryDataSet("id", new QFilter[]{idFilter}, "id asc ", 10000);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long id = row.getLong("id");
                    idList.add(id);
                    maxId = Math.max(id, maxId);
                }
                DynamicObject[] calibrateSessionObjs = this.calSessionQueryService.listCalibrateSession(idList);
                if (calibrateSessionObjs == null || calibrateSessionObjs.length == 0) {
                    boolean id = true;
                    return id;
                }
                ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>(10000);
                for (DynamicObject calibrateSession : calibrateSessionObjs) {
                    Map oldMapConfigMap;
                    ++dealCount;
                    String mapConfigStr = calibrateSession.getString("talentmapconfig_tag");
                    if (HRStringUtils.isEmpty((String)mapConfigStr) || (oldMapConfigMap = (Map)SerializationUtils.fromJsonString((String)mapConfigStr, Map.class)).containsKey("defaultMap")) continue;
                    Map<String, Object> updateParams = this.getUpdateParamsFromCalibrateSession(calibrateSession);
                    TalentMapConfigInfo talentMapConfigInfo = this.updateOldMapDataToNewMapData(mapConfigStr, updateParams);
                    updateDataList.add(calibrateSession);
                    calibrateSession.set("talentmapconfig_tag", (Object)SerializationUtils.toJsonString((Object)talentMapConfigInfo));
                }
                if (!updateDataList.isEmpty()) {
                    this.calibrateSessionService.save(updateDataList.toArray(new DynamicObject[0]));
                    int size = updateDataList.size();
                    updateAllSize += size;
                    LOGGER.info("UpdateTalentMapTask#({}/{})updateCalibrateSession save successfully! updateData size : {}", new Object[]{i, batchNum, size});
                    List updateIds = updateDataList.stream().map(data -> data.getString("id")).collect(Collectors.toList());
                    LOGGER.info("UpdateTalentMapTask#({}/{})updateCalibrateSession save successfully! updateDataId are : {}", new Object[]{i, batchNum, SerializationUtils.toJsonString(updateIds)});
                    continue;
                }
                LOGGER.info("UpdateTalentMapTask#({}/{})updateCalibrateSession no data to be update", (Object)i, (Object)batchNum);
            }
        }
        catch (Exception exp) {
            LOGGER.error("UpdateTalentMapTask#fail by updateCalibrateSession! batch number is ({}/{})", (Object)batchIndex, (Object)batchNum);
            LOGGER.error("UpdateTalentMapTask#fail by updateCalibrateSession! exception", (Throwable)exp);
            actTplTXHandle.markRollback();
            throw exp;
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            actTplTXHandle.close();
            LOGGER.info("UpdateTalentMapTask#process actTpl: {} / {}", (Object)dealCount, (Object)countCalibrateSession);
        }
        LOGGER.info("UpdateTalentMapTask#updateCalibrateSession updateAllSize : {}", (Object)updateAllSize);
        return true;
    }

    private boolean updateActivityTpl() {
        int countActivityTpl = this.activityTplQueryService.countReviewActTpl();
        int updateAllSize = 0;
        int batchNumTpl = countActivityTpl / 10000 + 1;
        LOGGER.info("UpdateTalentMapTask#countActivityTpl: {}, batchNum is {}", (Object)countActivityTpl, (Object)batchNumTpl);
        ArrayList<Long> idsTpl = new ArrayList<Long>(Math.min(10000, countActivityTpl));
        long maxIdTpl = 0L;
        int batchIndex = 0;
        DataSet dataSet = null;
        int dealCount = 0;
        TXHandle actTplTXHandle = TX.required((String)"UpdateTalentMapTask.actTplTXHandle");
        try {
            for (int i = 0; i < batchNumTpl; ++i) {
                batchIndex = i;
                QFilter idFilter = new QFilter("id", ">", (Object)maxIdTpl);
                dataSet = this.activityTplQueryService.queryDataSet("id", new QFilter[]{idFilter}, "id asc ", 10000);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long id = row.getLong("id");
                    idsTpl.add(id);
                    maxIdTpl = Math.max(id, maxIdTpl);
                }
                DynamicObject[] reviewActTplAll = this.activityTplQueryService.queryReviewActTpl(idsTpl);
                if (reviewActTplAll == null || reviewActTplAll.length == 0) {
                    boolean id = true;
                    return id;
                }
                ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>(10000);
                for (DynamicObject reviewActTpl : reviewActTplAll) {
                    boolean isUpdate;
                    ++dealCount;
                    DynamicObjectCollection talentMapEntry = reviewActTpl.getDynamicObjectCollection("talentmapentry");
                    if (talentMapEntry == null || talentMapEntry.size() == 0 || !(isUpdate = this.dealTalentMapEntry("oatr_reviewactivitytpl", talentMapEntry))) continue;
                    updateDataList.add(reviewActTpl);
                }
                if (!updateDataList.isEmpty()) {
                    this.activityTplService.save(reviewActTplAll);
                    int size = updateDataList.size();
                    updateAllSize += size;
                    LOGGER.info("UpdateTalentMapTask#({}/{})actTpl save successfully! updateData size : {}", new Object[]{i, batchNumTpl, size});
                    List updateIds = updateDataList.stream().map(data -> data.getString("id")).collect(Collectors.toList());
                    LOGGER.info("UpdateTalentMapTask#({}/{})actTpl save successfully! updateDataId are : {}", new Object[]{i, batchNumTpl, SerializationUtils.toJsonString(updateIds)});
                    continue;
                }
                LOGGER.info("UpdateTalentMapTask#({}/{})actTpl no data to be update", (Object)i, (Object)batchNumTpl);
            }
        }
        catch (Exception exp) {
            LOGGER.error("UpdateTalentMapTask#fail by actTpl! batch number is ({}/{})", (Object)batchIndex, (Object)batchNumTpl);
            LOGGER.error("UpdateTalentMapTask#fail by actTpl! exception", (Throwable)exp);
            actTplTXHandle.markRollback();
            throw exp;
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            actTplTXHandle.close();
            LOGGER.info("UpdateTalentMapTask#process actTpl: {} / {}", (Object)dealCount, (Object)countActivityTpl);
        }
        LOGGER.info("UpdateTalentMapTask#actTpl updateAllSize : {}", (Object)updateAllSize);
        return true;
    }

    private boolean updateActivity() {
        int countActivity = this.activityQueryService.countReviewActivity();
        int updateAllSize = 0;
        int batchNum = countActivity / 10000 + 1;
        LOGGER.info("UpdateTalentMapTask#countReviewActivity: {}, batchNum is {}", (Object)countActivity, (Object)batchNum);
        ArrayList<Long> ids = new ArrayList<Long>(Math.min(10000, countActivity));
        long maxId = 0L;
        int batchIndex = 0;
        DataSet dataSet = null;
        int dealCount = 0;
        TXHandle activityTXHandle = TX.required((String)"UpdateTalentMapTask.activityTXHandle");
        try {
            for (int i = 0; i < batchNum; ++i) {
                batchIndex = i;
                QFilter idFilter = new QFilter("id", ">", (Object)maxId);
                dataSet = this.activityQueryService.queryDataSet("id", new QFilter[]{idFilter}, "id asc ", 10000);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long id = row.getLong("id");
                    ids.add(id);
                    maxId = Math.max(id, maxId);
                }
                DynamicObject[] reviewActivityAll = this.activityQueryService.queryReviewActivity(ids);
                if (reviewActivityAll == null || reviewActivityAll.length == 0) {
                    boolean id = true;
                    return id;
                }
                ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>(10000);
                for (DynamicObject reviewActivity : reviewActivityAll) {
                    boolean isUpdate;
                    ++dealCount;
                    DynamicObjectCollection talentMapEntry = reviewActivity.getDynamicObjectCollection("talentmapentry");
                    if (talentMapEntry == null || talentMapEntry.size() == 0 || !(isUpdate = this.dealTalentMapEntry("oatr_reviewactivity", talentMapEntry))) continue;
                    updateDataList.add(reviewActivity);
                }
                if (!updateDataList.isEmpty()) {
                    this.activityService.save(updateDataList.toArray(new DynamicObject[0]));
                    int size = updateDataList.size();
                    updateAllSize += size;
                    LOGGER.info("UpdateTalentMapTask#({}/{})activity save successfully! updateData size : {}", new Object[]{i, batchNum, size});
                    List updateIds = updateDataList.stream().map(data -> data.getString("id")).collect(Collectors.toList());
                    LOGGER.info("UpdateTalentMapTask#({}/{})activity save successfully! updateDataId are : {}", new Object[]{i, batchNum, SerializationUtils.toJsonString(updateIds)});
                    continue;
                }
                LOGGER.info("UpdateTalentMapTask#({}/{})activity no data to be update", (Object)i, (Object)batchNum);
            }
        }
        catch (Exception exp) {
            LOGGER.error("UpdateTalentMapTask#fail by activity! batch number is ({}/{})", (Object)batchIndex, (Object)batchNum);
            LOGGER.error("UpdateTalentMapTask#fail by activity! exception", (Throwable)exp);
            activityTXHandle.markRollback();
            throw exp;
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            activityTXHandle.close();
            LOGGER.info("UpdateTalentMapTask#process activity: {}/{}", (Object)dealCount, (Object)countActivity);
        }
        LOGGER.info("UpdateTalentMapTask#activity updateAllSize : {}", (Object)updateAllSize);
        return true;
    }

    private boolean dealTalentMapEntry(String entityId, DynamicObjectCollection talentMapEntry) {
        boolean isUpdate = false;
        for (DynamicObject talentMap : talentMapEntry) {
            Map oldMapConfigMap;
            String mapConfigStr = talentMap.getString("talentmapconfig_tag");
            if (HRStringUtils.isEmpty((String)mapConfigStr) || (oldMapConfigMap = (Map)SerializationUtils.fromJsonString((String)mapConfigStr, Map.class)).containsKey("defaultMap")) continue;
            Map<String, Object> updateParams = this.getUpdateParamsFromTalentMap(entityId, talentMap);
            TalentMapConfigInfo talentMapConfigInfo = this.updateOldMapDataToNewMapData(mapConfigStr, updateParams);
            if (!isUpdate) {
                isUpdate = true;
            }
            talentMap.set("talentmapconfig_tag", (Object)SerializationUtils.toJsonString((Object)talentMapConfigInfo));
        }
        return isUpdate;
    }

    private Map<String, Object> getUpdateParamsFromTalentMap(String entityId, DynamicObject talentMap) {
        HashMap updateParams = Maps.newHashMapWithExpectedSize((int)16);
        boolean isDefaultMap = talentMap.getBoolean("isdefaultmap");
        boolean isDefaultMapLock = talentMap.getBoolean("isdefaultmaplock");
        updateParams.put("isdefaultmap", isDefaultMap);
        updateParams.put("isdefaultmaplock", isDefaultMapLock);
        String referStrategy = talentMap.getString("referstrategy");
        boolean isVisible = this.isFromTemplate(entityId);
        updateParams.put("referstrategy", referStrategy);
        updateParams.put("referStrategyVisible", isVisible);
        DynamicObject gridTemplate = talentMap.getDynamicObject("gridtemplate");
        boolean isGridTemplateLock = talentMap.getBoolean("isgridtemplatelock");
        String gridTplId = HRDyObjectPropUtil.getString((DynamicObject)gridTemplate, (String)"id");
        String gridName = HRDyObjectPropUtil.getName((DynamicObject)gridTemplate);
        updateParams.put("gridTplId", HRStringUtils.isEmpty((String)gridTplId) ? "" : gridTplId);
        updateParams.put("gridTplName", HRStringUtils.isEmpty((String)gridName) ? "" : gridName);
        updateParams.put("isgridtemplatelock", isGridTemplateLock);
        DynamicObjectCollection perCardDims = talentMap.getDynamicObjectCollection("percarddim");
        if (CollectionUtils.isEmpty((Collection)perCardDims)) {
            updateParams.put("perCardDimsId", new ArrayList(0));
        } else {
            List perCardDimIds = perCardDims.stream().map(perCardDim -> perCardDim.getLong("fbasedataid_id")).collect(Collectors.toList());
            updateParams.put("perCardDimsId", perCardDimIds);
        }
        boolean isPerCardDimLock = talentMap.getBoolean("ispercarddimlock");
        updateParams.put("ispercarddimlock", isPerCardDimLock);
        DynamicObject xAxisDim = talentMap.getDynamicObject("xaxisdim");
        DynamicObject yAxisDim = talentMap.getDynamicObject("yaxisdim");
        updateParams.put("xaxisdim", xAxisDim == null ? "" : xAxisDim.getString("id"));
        updateParams.put("yaxisdim", yAxisDim == null ? "" : yAxisDim.getString("id"));
        return updateParams;
    }

    private Map<String, Object> getUpdateParamsFromCalibrateSession(DynamicObject calibrateSession) {
        HashMap updateParams = Maps.newHashMapWithExpectedSize((int)16);
        updateParams.put("isdefaultmap", false);
        updateParams.put("isdefaultmaplock", false);
        updateParams.put("referstrategy", TalentMapStrategyEnum.ADJUST_ALL.getNumber());
        updateParams.put("referStrategyVisible", false);
        updateParams.put("gridTplId", "");
        updateParams.put("gridTplName", "");
        updateParams.put("isgridtemplatelock", false);
        DynamicObjectCollection perCardDims = calibrateSession.getDynamicObjectCollection("percarddim");
        if (CollectionUtils.isEmpty((Collection)perCardDims)) {
            updateParams.put("perCardDimsId", new ArrayList(0));
        } else {
            List perCardDimIds = perCardDims.stream().map(perCardDim -> perCardDim.getLong("fbasedataid_id")).collect(Collectors.toList());
            updateParams.put("perCardDimsId", perCardDimIds);
        }
        updateParams.put("ispercarddimlock", false);
        DynamicObject xAxisDim = calibrateSession.getDynamicObject("xaxisdim");
        DynamicObject yAxisDim = calibrateSession.getDynamicObject("yaxisdim");
        updateParams.put("xaxisdim", xAxisDim == null ? "" : xAxisDim.getString("id"));
        updateParams.put("yaxisdim", yAxisDim == null ? "" : yAxisDim.getString("id"));
        return updateParams;
    }

    private Map<String, Object> getUpdateParamsFromReviewResult() {
        HashMap updateParams = Maps.newHashMapWithExpectedSize((int)16);
        updateParams.put("isdefaultmap", false);
        updateParams.put("isdefaultmaplock", false);
        updateParams.put("referstrategy", TalentMapStrategyEnum.ADJUST_ALL.getNumber());
        updateParams.put("referStrategyVisible", false);
        updateParams.put("gridTplId", "");
        updateParams.put("gridTplName", "");
        updateParams.put("isgridtemplatelock", false);
        updateParams.put("perCardDimsId", new ArrayList(0));
        updateParams.put("ispercarddimlock", false);
        updateParams.put("xaxisdim", "");
        updateParams.put("yaxisdim", "");
        return updateParams;
    }

    private TalentMapConfigInfo updateOldMapDataToNewMapData(String oldMapConfigStr, Map<String, Object> updateParams) {
        if (HRStringUtils.isEmpty((String)oldMapConfigStr)) {
            return null;
        }
        TalentMapConfigInfo newMapConfigInfo = (TalentMapConfigInfo)SerializationUtils.fromJsonString((String)oldMapConfigStr, TalentMapConfigInfo.class);
        this.setDefaultMap(newMapConfigInfo, updateParams);
        this.setReferStrategy(newMapConfigInfo, updateParams);
        this.setGridTemplateInfo(newMapConfigInfo, updateParams);
        this.setPerCardDimInfo(newMapConfigInfo, updateParams);
        this.setAxisNameAndValue(newMapConfigInfo, updateParams);
        this.setGridCustomNumber(newMapConfigInfo);
        return newMapConfigInfo;
    }

    private void setDefaultMap(TalentMapConfigInfo newMapConfigInfo, Map<String, Object> updateParams) {
        boolean isDefaultMap = (Boolean)updateParams.getOrDefault("isdefaultmap", false);
        boolean isDefaultMapLock = (Boolean)updateParams.getOrDefault("isdefaultmaplock", false);
        DefaultMapInfo defaultMapInfo = new DefaultMapInfo();
        defaultMapInfo.setValue(isDefaultMap);
        defaultMapInfo.setLock(isDefaultMapLock);
        newMapConfigInfo.setDefaultMap(defaultMapInfo);
    }

    private void setReferStrategy(TalentMapConfigInfo newMapConfigInfo, Map<String, Object> updateParams) {
        String referStrategy = (String)updateParams.getOrDefault("referstrategy", TalentMapStrategyEnum.ADJUST_ALL.getNumber());
        boolean isLockIconVisible = HRStringUtils.equals((String)referStrategy, (String)TalentMapStrategyEnum.ADJUST_UNLOCK.getNumber());
        boolean isVisible = (Boolean)updateParams.getOrDefault("referStrategyVisible", false);
        newMapConfigInfo.setLockIconVisible(isLockIconVisible);
        ReferStrategyInfo referStrategyInfo = new ReferStrategyInfo();
        referStrategyInfo.setNumber(HRStringUtils.isEmpty((String)referStrategy) ? "" : referStrategy);
        referStrategyInfo.setName(TalentMapStrategyEnum.getValueByNumber((String)referStrategy));
        referStrategyInfo.setVisible(isVisible);
        referStrategyInfo.setHelpText(ResManager.loadKDString((String)"\u5141\u8bb8\u8c03\u6574\uff1a\u6d3b\u52a8\u5f15\u7528\u540e\uff0c\u53ef\u57fa\u4e8e\u6a21\u677f\u81ea\u7531\u8c03\u6574\u53c2\u6570\u3002\r\n\u4ec5\u53ef\u8c03\u6574\u672a\u9501\u5b9a\u6761\u4ef6\uff1a\u6d3b\u52a8\u5f15\u7528\u540e\uff0c\u4ec5\u53ef\u57fa\u4e8e\u6a21\u677f\u8c03\u6574\u672a\u9501\u5b9a\u53c2\u6570\u3002\r\n\u4e0d\u5141\u8bb8\u8c03\u6574\uff1a\u6d3b\u52a8\u5b8c\u5168\u5f15\u7528\u6a21\u677f\u914d\u7f6e\uff0c\u4e0d\u53ef\u8c03\u6574\u3002", (String)"ReviewTalentMapPlugin_8", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        TalentMapStrategyEnum[] strategyEnums = TalentMapStrategyEnum.values();
        CommonComboInfo[] strategyTypeInfos = new CommonComboInfo[strategyEnums.length];
        for (int i = 0; i < strategyEnums.length; ++i) {
            TalentMapStrategyEnum strategyEnum = strategyEnums[i];
            CommonComboInfo strategyInfo = new CommonComboInfo();
            strategyInfo.setValue(strategyEnum.getNumber());
            strategyInfo.setName(strategyEnum.getValue());
            strategyTypeInfos[i] = strategyInfo;
        }
        referStrategyInfo.setStrategyTypeInfos(strategyTypeInfos);
        newMapConfigInfo.setReferStrategy(referStrategyInfo);
    }

    private void setGridTemplateInfo(TalentMapConfigInfo newMapConfigInfo, Map<String, Object> updateParams) {
        String tplId = (String)updateParams.getOrDefault("gridTplId", "");
        String tplName = (String)updateParams.getOrDefault("gridTplName", "");
        boolean isGridTemplateLock = (Boolean)updateParams.getOrDefault("isgridtemplatelock", false);
        GridTemplateInfo gridTemplateInfo = new GridTemplateInfo();
        gridTemplateInfo.setId(tplId);
        gridTemplateInfo.setName(tplName);
        gridTemplateInfo.setLock(isGridTemplateLock);
        newMapConfigInfo.setGridTemplate(gridTemplateInfo);
    }

    private void setPerCardDimInfo(TalentMapConfigInfo newMapConfigInfo, Map<String, Object> updateParams) {
        List perCardDimsIdList = updateParams.getOrDefault("perCardDimsId", new ArrayList());
        boolean isPerCardDimLock = (Boolean)updateParams.getOrDefault("ispercarddimlock", false);
        PersonCardDimInfo personCardDimInfo = new PersonCardDimInfo();
        CommonComboInfo[] dimensions = new CommonComboInfo[]{};
        if (!CollectionUtils.isEmpty((Collection)perCardDimsIdList)) {
            dimensions = new CommonComboInfo[perCardDimsIdList.size()];
            Set<Long> existsDimIds = this.dimensionData.keySet();
            perCardDimsIdList.removeAll(existsDimIds);
            List<DynamicObject> perCardDimObjs = this.reviewDimensionQueryService.getReviewDimensions(perCardDimsIdList);
            for (DynamicObject perCardDimObj : perCardDimObjs) {
                this.dimensionData.put(perCardDimObj.getLong("id"), perCardDimObj);
            }
            for (int i = 0; i < perCardDimsIdList.size(); ++i) {
                DynamicObject perCardDim = this.dimensionData.get(perCardDimsIdList.get(i));
                if (perCardDim == null) continue;
                CommonComboInfo perDimension = new CommonComboInfo();
                perDimension.setValue(String.valueOf(HRDyObjectPropUtil.getId((DynamicObject)perCardDim)));
                perDimension.setName(HRDyObjectPropUtil.getName((DynamicObject)perCardDim));
                dimensions[i] = perDimension;
            }
        }
        personCardDimInfo.setDimensions(dimensions);
        personCardDimInfo.setLock(isPerCardDimLock);
        personCardDimInfo.setHelpText(ResManager.loadKDString((String)"\u5176\u4ed6\u7ef4\u5ea6\u5c06\u4f5c\u4e3a\u6807\u7b7e\u5448\u73b0\u5728\u6821\u51c6\u4eba\u5458\u5361\u7247\u3002", (String)"ReviewTalentMapPlugin_9", (String)"tdc-oatr-formplugin", (Object[])new Object[0]));
        newMapConfigInfo.setPerCardDim(personCardDimInfo);
    }

    private void setAxisNameAndValue(TalentMapConfigInfo newMapConfigInfo, Map<String, Object> updateParams) {
        AxisInfo xAxisInfo = newMapConfigInfo.getxAxisInfo();
        String xAxisDimId = (String)updateParams.getOrDefault("xaxisdim", "");
        xAxisInfo.setId(xAxisDimId);
        xAxisInfo.setAxisInfos(new CommonComboInfo[0]);
        AxisInfo yAxisInfo = newMapConfigInfo.getyAxisInfo();
        String yAxisDimId = (String)updateParams.getOrDefault("yaxisdim", "");
        yAxisInfo.setId(yAxisDimId);
        yAxisInfo.setAxisInfos(new CommonComboInfo[0]);
    }

    private void setGridCustomNumber(TalentMapConfigInfo newMapConfigInfo) {
        GridConfigInfo gridData = newMapConfigInfo.getGridData();
        if (gridData != null) {
            List gridBlocks = gridData.getGridBlocks();
            if (CollectionUtils.isEmpty((Collection)gridBlocks)) {
                return;
            }
            for (GridBlockInfo gridBlock : gridBlocks) {
                if (!HRStringUtils.isEmpty((String)gridBlock.getCustomNumber())) continue;
                gridBlock.setCustomNumber(gridBlock.getNumber());
            }
        }
    }

    private boolean isFromTemplate(String entityId) {
        return HRStringUtils.equals((String)entityId, (String)"oatr_reviewactivitytpl");
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)kd.bos.service.ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

