/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.activity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.domain.activitytpl.ReviewActivityTemplateService;
import kd.tdc.oatr.bussiness.domain.reviewplan.ReviewPlanService;
import kd.tdc.oatr.opplugin.validate.activity.ReviewActivityDeleteValidator;

public class ReviewActivityDeleteOp
extends HRDataBaseOp {
    private final ReviewActivityTemplateService reviewActivityTplService = (ReviewActivityTemplateService)ServiceFactory.getService(ReviewActivityTemplateService.class);
    private final ReviewPlanService reviewPlanService = (ReviewPlanService)ServiceFactory.getService(ReviewPlanService.class);
    private static final HRBaseServiceHelper REVIEWGROUP_REPOSITORY = new HRBaseServiceHelper("oatr_reviewgroup");
    private static final HRBaseServiceHelper REVIEWTOOL_REPOSITORY = new HRBaseServiceHelper("oatr_reviewtool");
    private static final HRBaseServiceHelper REVIEWOBJECTHELPER = new HRBaseServiceHelper("oatr_reviewobject");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Lists.newArrayList((Object[])new String[]{"activitystatus", "reviewplan", "activitytemplate"}));
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.getOption().setVariableValue("ignorerefentityids", "oatr_colreviewgroup,oatr_reviewgroup,oatr_reviewtool,oatr_reviewobjectf7");
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReviewActivityDeleteValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        HashMap tplActivityNumOfRef = Maps.newHashMapWithExpectedSize((int)4);
        HashMap planActivityNumOfRef = Maps.newHashMapWithExpectedSize((int)4);
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject reviewPlan;
            DynamicObject activityTemplate = dataEntity.getDynamicObject("activityTemplate");
            if (activityTemplate != null) {
                if (!tplActivityNumOfRef.containsKey(activityTemplate)) {
                    tplActivityNumOfRef.put(activityTemplate, -1);
                } else {
                    Integer refNum = (Integer)tplActivityNumOfRef.get(activityTemplate);
                    tplActivityNumOfRef.put(activityTemplate, refNum - 1);
                }
            }
            if ((reviewPlan = dataEntity.getDynamicObject("reviewplan")) != null) {
                if (!planActivityNumOfRef.containsKey(reviewPlan)) {
                    planActivityNumOfRef.put(reviewPlan, -1);
                } else {
                    Integer refNum = (Integer)tplActivityNumOfRef.get(activityTemplate);
                    planActivityNumOfRef.put(reviewPlan, refNum - 1);
                }
            }
        });
        this.reviewActivityTplService.updateTemplateActivityNumOfRef((Map)tplActivityNumOfRef);
        this.reviewPlanService.updatePlanActivityNumOfRef((Map)planActivityNumOfRef);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        List activityIds = Arrays.stream(e.getDataEntities()).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
        REVIEWGROUP_REPOSITORY.deleteByFilter(new QFilter[]{new QFilter("reviewactivity.id", "in", activityIds)});
        REVIEWTOOL_REPOSITORY.deleteByFilter(new QFilter[]{new QFilter("reviewactivity.id", "in", activityIds)});
        REVIEWOBJECTHELPER.deleteByFilter(new QFilter[]{new QFilter("reviewactivity.id", "in", activityIds)});
    }
}

