/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.activity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.activitytpl.ReviewActivityTemplateService;
import kd.tdc.oatr.bussiness.domain.reviewplan.ReviewPlanService;
import kd.tdc.oatr.opplugin.validate.activity.ReviewActivityCreateOrgValidator;
import kd.tdc.oatr.opplugin.validate.activity.template.ReviewActivityTplTalMapValidator;

public class ReviewActivitySaveOp
extends HRDataBaseOp {
    private static final Log log = LogFactory.getLog(ReviewActivitySaveOp.class);
    private static final ReviewActivityApplicationService service = (ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Lists.newArrayList((Object[])new String[]{"createorg"}));
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReviewActivityTplTalMapValidator());
        e.addValidator((AbstractValidator)new ReviewActivityCreateOrgValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            service.saveReviewActivity(dataEntity, this.getOption());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject dataEntity = e.getDataEntities()[0];
        service.updateReviewObjMapBeforePos(dataEntity);
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        HashMap activityTplNumOfRefRollBack;
        Map activityTplNumOfRef;
        String variableValue;
        super.rollbackOperation(e);
        OperateOption option = this.getOption();
        if (option.containsVariable("update_num_flagactivitytemplate")) {
            variableValue = option.getVariableValue("update_num_flagactivitytemplate");
            activityTplNumOfRef = (Map)SerializationUtils.deSerializeFromBase64((String)variableValue);
            activityTplNumOfRefRollBack = Maps.newHashMapWithExpectedSize((int)activityTplNumOfRef.size());
            activityTplNumOfRef.forEach((key, val) -> activityTplNumOfRefRollBack.put(key, -val.intValue()));
            ((ReviewActivityTemplateService)ServiceFactory.getService(ReviewActivityTemplateService.class)).updateTemplateActivityNumOfRef((Map)activityTplNumOfRefRollBack);
        }
        if (option.containsVariable("update_num_flagreviewplan")) {
            variableValue = option.getVariableValue("update_num_flagreviewplan");
            activityTplNumOfRef = (Map)SerializationUtils.deSerializeFromBase64((String)variableValue);
            activityTplNumOfRefRollBack = Maps.newHashMapWithExpectedSize((int)activityTplNumOfRef.size());
            activityTplNumOfRef.forEach((key, val) -> activityTplNumOfRefRollBack.put(key, -val.intValue()));
            ((ReviewPlanService)ServiceFactory.getService(ReviewPlanService.class)).updatePlanActivityNumOfRef((Map)activityTplNumOfRefRollBack);
        }
    }
}

