/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.activity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.batchconfirm.activity.ReviewActivityBatchStartFormService;
import kd.tdc.oatr.bussiness.queryservice.EvaluationSchemeQueryService;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;
import kd.tdc.oatr.opplugin.validate.activity.ReviewActivityStartValidator;
import kd.tdc.oatr.opplugin.validate.activity.template.ReviewActivityTplTalMapValidator;

public class ReviewActivityStartOp
extends HRDataBaseOp {
    private final ReviewActivityBatchStartFormService startFormService = (ReviewActivityBatchStartFormService)ServiceFactory.getService(ReviewActivityBatchStartFormService.class);
    private static final HRBaseServiceHelper REVIEWOBJECTHELPER = new HRBaseServiceHelper("oatr_reviewobject");
    private final EvaluationSchemeQueryService evaluationSchemeQueryService = (EvaluationSchemeQueryService)ServiceFactory.getService(EvaluationSchemeQueryService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Lists.newArrayList((Object[])new String[]{"activitystatus", "talentmapentry", "talentmapentry.referstrategy", "talentmapentry.gridtemplate", "talentmapentry.xaxisdim", "talentmapentry.yaxisdim", "talentmapentry.talentmapconfig_tag", "dimesionentry", "dimesionentry.evaluationscheme", "dimesionentry.dimevaluation"}));
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReviewActivityStartValidator());
        e.addValidator((AbstractValidator)new ReviewActivityTplTalMapValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.startFormService.cancelOpBeforeExecuteOperationTransaction(e, (AbstractOperationServicePlugIn)this);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        long schemeId;
        super.beginOperationTransaction(beginOperationTransactionArgs);
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        HashSet<Long> evalSchemeIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject2 : dataEntities) {
            DynamicObjectCollection dimEntry = dynamicObject2.getDynamicObjectCollection("dimesionentry");
            for (DynamicObject entry : dimEntry) {
                schemeId = entry.getLong("evaluationscheme.id");
                evalSchemeIds.add(schemeId);
            }
        }
        ArrayList evalSchemeIdList = new ArrayList(evalSchemeIds);
        DynamicObject[] evaluationSchemes = this.evaluationSchemeQueryService.listEvaluationSchemes(evalSchemeIdList);
        HashMap evaluationIdMap = new HashMap(evaluationSchemes.length);
        for (DynamicObject evaluationScheme : evaluationSchemes) {
            long evaluationId;
            schemeId = evaluationScheme.getLong("id");
            ArrayList<Long> evaluationIds = (ArrayList<Long>)evaluationIdMap.get(schemeId);
            if (HRCollUtil.isEmpty((Collection)evaluationIds)) {
                evaluationIds = new ArrayList<Long>(10);
            }
            if ((evaluationId = evaluationScheme.getLong("entryentity.evaluationitem.id")) != 0L) {
                evaluationIds.add(evaluationId);
            }
            evaluationIdMap.put(schemeId, evaluationIds);
        }
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)16);
        Arrays.stream(dataEntities).forEach(dynamicObject -> {
            dynamicObject.set("activitystatus", (Object)ActivityStatusEnum.GOING.getCode());
            ids.add(dynamicObject.getLong("id"));
            DynamicObjectCollection dimEntry = dynamicObject.getDynamicObjectCollection("dimesionentry");
            for (DynamicObject entry : dimEntry) {
                long schemeId = entry.getLong("evaluationscheme.id");
                List evaluationIds = (List)evaluationIdMap.get(schemeId);
                if (!HRCollUtil.isNotEmpty((Collection)evaluationIds)) continue;
                DynamicObjectCollection dimEvaluation = entry.getDynamicObjectCollection("dimevaluation");
                for (Long evaluationId : evaluationIds) {
                    dimEvaluation.addNew().set("fbasedataid", (Object)evaluationId);
                }
            }
        });
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        QFilter reviewStatusQF = new QFilter("reviewstatus", "=", (Object)ObjectStatusEnum.WAIT_START.getCode());
        QFilter activityQF = new QFilter("reviewactivity", "in", (Object)arrayList);
        DynamicObject[] reviewObjs = REVIEWOBJECTHELPER.query("reviewstatus", new QFilter[]{reviewStatusQF, activityQF});
        Arrays.stream(reviewObjs).forEach(reviewObj -> reviewObj.set("reviewstatus", (Object)ObjectStatusEnum.GOING_UNCHECK.getCode()));
        REVIEWOBJECTHELPER.save(reviewObjs);
    }
}

