/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.activity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.batchconfirm.activity.ReviewActivityBatchStopFormService;
import kd.tdc.oatr.bussiness.domain.activity.ReviewActivityService;
import kd.tdc.oatr.bussiness.domain.collaborator.ReviewCollaboratorService;
import kd.tdc.oatr.bussiness.domain.collaborator.ReviewToolService;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectSnapshotService;
import kd.tdc.oatr.bussiness.queryservice.ReviewQuestionService;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;
import kd.tdc.oatr.opplugin.validate.activity.ReviewActivityStopValidator;

public class ReviewActivityStopOp
extends HRDataBaseOp {
    private final ReviewCollaboratorService reviewCollaboratorService = (ReviewCollaboratorService)ServiceFactory.getService(ReviewCollaboratorService.class);
    private final ReviewQuestionService questionService = (ReviewQuestionService)ServiceFactory.getService(ReviewQuestionService.class);
    private ReviewActivityBatchStopFormService stopFormService = (ReviewActivityBatchStopFormService)ServiceFactory.getService(ReviewActivityBatchStopFormService.class);
    private final ReviewToolService reviewToolService = (ReviewToolService)ServiceFactory.getService(ReviewToolService.class);
    private final ReviewObjectSnapshotService reviewObjectSnapshotService = (ReviewObjectSnapshotService)ServiceFactory.getService(ReviewObjectSnapshotService.class);
    private static final HRBaseServiceHelper REVIEWOBJECTHELPER = new HRBaseServiceHelper("oatr_reviewobject");
    private final ReviewActivityService reviewActService = (ReviewActivityService)ServiceFactory.getService(ReviewActivityService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Lists.newArrayList((Object[])new String[]{"activitystatus", "activitytemplate", "toolsctlstg"}));
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReviewActivityStopValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.stopFormService.cancelOpBeforeExecuteOperationTransaction(e, (AbstractOperationServicePlugIn)this);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)16);
        Arrays.stream(dataEntities).forEach(dynamicObject -> {
            dynamicObject.set("activitystatus", (Object)ActivityStatusEnum.STOP.getCode());
            ids.add(dynamicObject.getLong("id"));
        });
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        this.reviewCollaboratorService.personInfoSnapshot(dataEntities);
        this.reviewToolService.evaluationItemSnapshot(dataEntities);
        this.reviewObjectSnapshotService.personInfoSnapshot(dataEntities);
        ArrayList reviewStatusList = Lists.newArrayList((Object[])new String[]{ObjectStatusEnum.GOING_UNCHECK.getCode(), ObjectStatusEnum.GOING_CHECK.getCode(), ObjectStatusEnum.WAIT_START.getCode()});
        QFilter reviewStatusQF = new QFilter("reviewstatus", "in", (Object)reviewStatusList);
        QFilter activityQF = new QFilter("reviewactivity", "in", (Object)ids);
        DynamicObject[] reviewObjs = REVIEWOBJECTHELPER.query("reviewactivity,adminorg,reviewstatus", new QFilter[]{reviewStatusQF, activityQF});
        Arrays.stream(reviewObjs).forEach(reviewObj -> reviewObj.set("reviewstatus", (Object)ObjectStatusEnum.ACTIVITY_STOP.getCode()));
        List reviewObjIds = Arrays.stream(reviewObjs).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        this.questionService.terminateQuestionByTerminal(reviewObjIds);
        REVIEWOBJECTHELPER.save(reviewObjs);
        this.reviewActService.saveReviewObjAdminorgTree((List)ids);
    }
}

