/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.activity.calibrate;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.OnlineCalibrationApplicationService;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.common.utils.JsonUtils;
import kd.tdc.oatr.opplugin.validate.calibrate.CalibrateSaveValidator;

public class CalibrateSessionSaveOp
extends HRDataBaseOp {
    private static final Log log = LogFactory.getLog(CalibrateSessionSaveOp.class);
    private final OnlineCalibrationApplicationService calibrationApplicationService = (OnlineCalibrationApplicationService)ServiceFactory.getService(OnlineCalibrationApplicationService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("reviewactivity");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CalibrateSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject calibrateSessionObj = e.getDataEntities()[0];
        String reviewObjIdsStr = this.getOption().getVariableValue("reviewObjIds");
        String activityIdStr = this.getOption().getVariableValue("activityId");
        List reviewObjIds = (List)JsonUtils.toObject((String)reviewObjIdsStr, (TypeReference)new TypeReference<List<Long>>(){});
        calibrateSessionObj.set("calibratepersonnum", (Object)reviewObjIds.size());
        long calibrateSessionId = calibrateSessionObj.getLong("id");
        long activityId = Long.parseLong(activityIdStr);
        String talentMapId = this.getOption().getVariableValue("talentmap");
        this.calibrationApplicationService.syncOnlineCalibrationData(activityId, calibrateSessionId, reviewObjIds, talentMapId);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String activityId = this.getOption().getVariableValue("activityId");
        ((ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class)).recordCollaborationBusinessData(Long.parseLong(activityId));
    }
}

