/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.activity.reviewobj;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.impt.common.dto.ImportBillData;
import kd.sdk.tdc.oatr.reviewobject.IDimensionOriginalValueExtendService;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.common.utils.PropUtils;

public class ReviewObjImportDimResultSaveOp
extends HRDataBaseOp {
    private static final HRBaseServiceHelper REPOSITORY = new HRBaseServiceHelper("oatr_reviewobject");
    private static final HRBaseServiceHelper ACTIVITY_REPOSITORY = new HRBaseServiceHelper("oatr_reviewactivity");

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        super.beforeExecuteOperationTransaction(beforeOperationArgs);
        OperateOption option = this.getOption();
        String billDataStr = option.getVariableValue("billData");
        if (HRStringUtils.isEmpty((String)billDataStr)) {
            return;
        }
        String importType = option.getVariableValue("importtype");
        String activityId = option.getVariableValue("activityId");
        DynamicObject reviewActivityDO = ACTIVITY_REPOSITORY.queryOne((Object)activityId);
        List dimensionDOList = reviewActivityDO.getDynamicObjectCollection("dimesionentry").stream().map(dimDy -> dimDy.getDynamicObject("reviewdimension")).collect(Collectors.toList());
        DynamicObject[] reviewObjectDO = ReviewObjImportDimResultSaveOp.getReviewObjectDO(option, Arrays.stream(beforeOperationArgs.getDataEntities()).map(dy -> dy.getString("number")).collect(Collectors.toList()));
        List importBillDataList = JSONObject.parseArray((String)billDataStr, ImportBillData.class);
        beforeOperationArgs.getValidExtDataEntities().forEach(importExtDy -> {
            DynamicObject importDy = importExtDy.getDataEntity();
            Arrays.stream(reviewObjectDO).filter(dy -> HRStringUtils.equals((String)dy.getString("number"), (String)importDy.getString("number"))).findFirst().ifPresent(reviewObjDO -> importBillDataList.stream().filter(billData -> HRStringUtils.equals((String)reviewObjDO.getString("number"), (String)billData.getData().getJSONObject(REPOSITORY.getEntityName()).getString("number"))).findFirst().ifPresent(importBillData -> {
                JSONObject fieldJson = importBillData.getData().getJSONObject(REPOSITORY.getEntityName());
                DynamicObjectCollection dimensionEntry = reviewObjDO.getDynamicObjectCollection("entryentity_dimension");
                List existsDims = dimensionEntry.stream().map(dim -> dim.getString(PropUtils.getNumberDot((String)"dimension"))).collect(Collectors.toList());
                fieldJson.forEach((key, value) -> {
                    if (HRStringUtils.equals((String)importType, (String)"new")) {
                        this.addNewDimension(dimensionDOList, dimensionEntry, (String)key, value);
                    }
                    if (HRStringUtils.equals((String)importType, (String)"update")) {
                        this.updateDimension(dimensionEntry, (String)key, value);
                    }
                    if (HRStringUtils.equals((String)importType, (String)"updateandnew")) {
                        if (existsDims.contains(key)) {
                            this.updateDimension(dimensionEntry, (String)key, value);
                        } else {
                            this.addNewDimension(dimensionDOList, dimensionEntry, (String)key, value);
                        }
                    }
                    importExtDy.setDataEntity(reviewObjDO);
                });
            }));
        });
        List reviewObjectDOList = beforeOperationArgs.getValidExtDataEntities().stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        ((ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class)).resetReviewObjMapBeforePos(reviewObjectDOList, reviewActivityDO);
    }

    private void updateDimension(DynamicObjectCollection dimensionEntry, String key, Object value) {
        dimensionEntry.stream().filter(dim -> HRStringUtils.equals((String)key, (String)dim.getString(PropUtils.getNumberDot((String)"dimension")))).findFirst().ifPresent(dim -> {
            DynamicObject dimension = dim.getDynamicObject("dimension");
            dim.set("dimensionvalue", (Object)this.getTransformDimValue(dimension, value));
            dim.set("dimorigvalue", value);
        });
    }

    private void addNewDimension(List<DynamicObject> dimensionDOList, DynamicObjectCollection dimensionEntry, String key, Object value) {
        dimensionDOList.stream().filter(dim -> HRStringUtils.equals((String)key, (String)dim.getString("number"))).findFirst().ifPresent(dim -> {
            DynamicObject newDimensionRow = dimensionEntry.addNew();
            newDimensionRow.set("dimension", dim);
            newDimensionRow.set("dimensionvalue", (Object)this.getTransformDimValue((DynamicObject)dim, value));
            newDimensionRow.set("dimorigvalue", value);
        });
    }

    private String getTransformDimValue(DynamicObject dimension, Object value) {
        HashMap resultMap = new HashMap(1);
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, IDimensionOriginalValueExtendService.class, (String)"kd.sdk.tdc.oatr.reviewobject.IDimensionOriginalValueExtendService", null);
        pluginProxy.callReplaceIfPresent(plugin -> {
            String dimValue;
            if (plugin != null && (dimValue = plugin.dimValueConvertor(dimension, String.valueOf(value))) != null) {
                resultMap.put("dimValue", dimValue);
            }
            return null;
        });
        return resultMap.get("dimValue") == null ? String.valueOf(value) : (String)resultMap.get("dimValue");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        REPOSITORY.save(beginOperationTransactionArgs.getDataEntities());
        ((ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class)).recordCollaborationBusinessData(Long.parseLong(this.getOption().getVariableValue("activityId")));
    }

    private static DynamicObject[] getReviewObjectDO(OperateOption option, List<String> numberList) {
        String SELECT_PROP = String.join((CharSequence)",", "number,entryentity_dimension", "dimension", "dimensionvalue", "dimorigvalue", "mapbeforekey", "mapbeforename", "mapbeforevalue");
        QFilter activityQF = new QFilter("reviewactivity", "=", (Object)Long.parseLong(option.getVariableValue("activityId")));
        QFilter groupQF = new QFilter("reviewgroup", "in", (Object)JSONObject.parseArray((String)option.getVariableValue("groupId")).toJavaList(Long.class));
        QFilter numberQF = new QFilter("number", "in", numberList);
        QFilter statusQF = new QFilter("reviewstatus", "!=", (Object)"E");
        return REPOSITORY.query(SELECT_PROP, new QFilter[]{activityQF, groupQF, numberQF, statusQF});
    }
}

