/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.activity.reviewobj;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.impt.common.dto.ImportBillData;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.common.bo.ReviewImportFieldInfo;
import kd.tdc.oatr.common.utils.PropUtils;

public class ReviewObjImportEvalSaveOp
extends HRDataBaseOp {
    private static final HRBaseServiceHelper REPOSITORY = new HRBaseServiceHelper("oatr_reviewobject");

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        super.beforeExecuteOperationTransaction(beforeOperationArgs);
        OperateOption option = this.getOption();
        String billDataStr = option.getVariableValue("billData");
        if (HRStringUtils.isEmpty((String)billDataStr)) {
            return;
        }
        String importType = option.getVariableValue("importtype");
        List importBillDataList = JSONObject.parseArray((String)billDataStr, ImportBillData.class);
        List<String> numberList = Arrays.stream(beforeOperationArgs.getDataEntities()).map(dy -> dy.getString("number")).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = this.getReviewObjectDO(option, numberList);
        String fieldInfoStr = option.getVariableValue("fieldInfo");
        List fieldInfoList = JSONObject.parseArray((String)fieldInfoStr, ReviewImportFieldInfo.class);
        String activityId = option.getVariableValue("activityId");
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(activityId));
        HRBaseServiceHelper activityHelper = new HRBaseServiceHelper("oatr_reviewactivity");
        DynamicObject reviewActivity = activityHelper.queryOne("dimesionentry,dimesionentry.reviewdimension,dimesionentry.evaluationscheme,dimesionentry.dimevaluation", qFilter.toArray());
        beforeOperationArgs.getValidExtDataEntities().forEach(importExtDy -> {
            DynamicObject importDy = importExtDy.getDataEntity();
            String number = importDy.getString("number");
            Arrays.stream(dynamicObjects).filter(dy -> HRStringUtils.equals((String)number, (String)dy.getString("number"))).findFirst().ifPresent(dynamicObject -> importBillDataList.stream().filter(data -> HRStringUtils.equals((String)number, (String)data.getData().getJSONObject(dynamicObject.getDataEntityType().getName()).getString("number"))).findFirst().ifPresent(billData -> {
                List<String> hasImportedEvalNumberList = this.getHasImportedEvalNumberList((DynamicObject)dynamicObject);
                if (HRStringUtils.equals((String)importType, (String)"new")) {
                    hasImportedEvalNumberList.clear();
                    this.convertDataNew((DynamicObject)dynamicObject, (ImportBillData)billData, fieldInfoList, reviewActivity, hasImportedEvalNumberList);
                }
                if (HRStringUtils.equals((String)importType, (String)"update")) {
                    this.convertDataUpdate((DynamicObject)dynamicObject, (ImportBillData)billData);
                }
                if (HRStringUtils.equals((String)importType, (String)"updateandnew")) {
                    this.convertDataUpdate((DynamicObject)dynamicObject, (ImportBillData)billData);
                    this.convertDataNew((DynamicObject)dynamicObject, (ImportBillData)billData, fieldInfoList, reviewActivity, hasImportedEvalNumberList);
                }
                importExtDy.setDataEntity(dynamicObject);
            }));
        });
    }

    private List<String> getHasImportedEvalNumberList(DynamicObject dynamicObject) {
        DynamicObjectCollection evalEntryEntity = dynamicObject.getDynamicObjectCollection("entryentity_dimeval");
        return evalEntryEntity.stream().map(evalInfo -> {
            String evalDimId = evalInfo.getString(PropUtils.getIdDot((String)"evaldim"));
            String evaluationItem = evalInfo.getString("dimevalitem.number");
            return evalDimId + evaluationItem;
        }).collect(Collectors.toList());
    }

    private DynamicObject[] getReviewObjectDO(OperateOption option, List<String> numberList) {
        String SELECT_PROP = String.join((CharSequence)",", "entryentity_dimeval", "evaldim", "dimevalitem", "dimevalvalue");
        QFilter activityQF = new QFilter("reviewactivity", "=", (Object)Long.valueOf(option.getVariableValue("activityId")));
        QFilter groupQF = new QFilter("reviewgroup", "in", (Object)JSONObject.parseArray((String)option.getVariableValue("groupId")).toJavaList(Long.class));
        QFilter numberQF = new QFilter("number", "in", numberList);
        return REPOSITORY.query(SELECT_PROP, new QFilter[]{activityQF, groupQF, numberQF});
    }

    private void convertDataUpdate(DynamicObject dynamicObject, ImportBillData billData) {
        JSONObject jsonObject = billData.getData().getJSONObject(dynamicObject.getDataEntityType().getName());
        DynamicObjectCollection evalEntryEntity = dynamicObject.getDynamicObjectCollection("entryentity_dimeval");
        for (DynamicObject evalInfo : evalEntryEntity) {
            String evalValue;
            String dimId = evalInfo.getString(PropUtils.getIdDot((String)"evaldim"));
            DynamicObject evaluationItem = evalInfo.getDynamicObject("dimevalitem");
            JSONObject outToolNameJson = jsonObject.getJSONObject(dimId);
            if (CollectionUtils.isEmpty((Map)outToolNameJson) || !HRStringUtils.isNotEmpty((String)(evalValue = outToolNameJson.getString(evaluationItem.getString("number"))))) continue;
            evalInfo.set("dimevalvalue", (Object)evalValue);
        }
    }

    private void convertDataNew(DynamicObject dynamicObject, ImportBillData billData, List<ReviewImportFieldInfo> fieldInfoList, DynamicObject reviewActivity, List<String> hasImportedEvalNumberList) {
        DynamicObjectCollection evalEntryEntity = dynamicObject.getDynamicObjectCollection("entryentity_dimeval");
        for (ReviewImportFieldInfo reviewImportFieldInfo : fieldInfoList) {
            String value;
            JSONObject entityJson;
            JSONObject outToolJson;
            String dimId = (String)reviewImportFieldInfo.getKeyMap().get("dimId");
            String evaluationItemNum = (String)reviewImportFieldInfo.getKeyMap().get("evaluationItemNum");
            if (!hasImportedEvalNumberList.isEmpty() && hasImportedEvalNumberList.contains(dimId + evaluationItemNum) || CollectionUtils.isEmpty((Map)(outToolJson = (entityJson = billData.getData().getJSONObject("oatr_reviewobject")).getJSONObject(dimId))) || !HRStringUtils.isNotEmpty((String)(value = outToolJson.getString(evaluationItemNum)))) continue;
            reviewActivity.getDynamicObjectCollection("dimesionentry").stream().filter(entryRow -> HRStringUtils.equals((String)dimId, (String)entryRow.getString(PropUtils.getIdDot((String)"reviewdimension")))).findFirst().ifPresent(entryRow -> {
                DynamicObjectCollection evaluationItemColl = entryRow.getDynamicObjectCollection("dimevaluation");
                evaluationItemColl.stream().filter(item -> HRStringUtils.equals((String)evaluationItemNum, (String)item.getString(PropUtils.getNumberDot((String)"fbasedataid")))).findFirst().ifPresent(item -> {
                    DynamicObject newRow = evalEntryEntity.addNew();
                    newRow.set("evaldim", (Object)this.generateDyObj("oatr_reviewdimension", dimId));
                    newRow.set("dimevalitem", (Object)this.generateDyObj("oatr_evaluationitem", item.getLong("fbasedataid_id")));
                    newRow.set("dimevalvalue", (Object)value);
                });
            });
        }
    }

    private DynamicObject generateDyObj(String entityNumber, Object pkValue) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("id", pkValue);
        return dynamicObject;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        REPOSITORY.save(beginOperationTransactionArgs.getDataEntities());
        ((ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class)).recordCollaborationBusinessData(Long.parseLong(this.getOption().getVariableValue("activityId")));
    }
}

