/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.activity.reviewobj;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.activity.ReviewActivityService;
import kd.tdc.oatr.bussiness.queryservice.PersonAboutQueryService;
import kd.tdc.oatr.bussiness.queryservice.TalentFileQueryService;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;
import org.apache.commons.lang3.tuple.Pair;

public class ReviewObjImportSaveOp
extends HRDataBaseOp {
    private static final HRBaseServiceHelper REVIEWOBJECT_REPOSITORY = new HRBaseServiceHelper("oatr_reviewobject");
    private static final HRBaseServiceHelper REVIEW_ACTIVITY_HELPER = new HRBaseServiceHelper("oatr_reviewactivity");
    private static final HRBaseServiceHelper groupServiceHelper = new HRBaseServiceHelper("oatr_reviewgroup");
    private final ReviewActivityService reviewActService = (ReviewActivityService)ServiceFactory.getService(ReviewActivityService.class);
    private ReviewActivityApplicationService reviewActivityApplicationService = (ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        OperateOption option = this.getOption();
        String activityId = option.getVariableValue("activityId");
        DynamicObject activity = REVIEW_ACTIVITY_HELPER.queryOne("activitystatus", new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(activityId))});
        String activityStatus = activity.getString("activitystatus");
        String successDataStr = option.getVariableValue("successData");
        if (HRStringUtils.isEmpty((String)successDataStr)) {
            return;
        }
        List successData = SerializationUtils.fromJsonStringToList((String)successDataStr, JSONObject.class);
        Map<String, String> num2group = successData.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v.getJSONObject("reviewgroup").getString("number"), (k1, k2) -> k1));
        QFilter activityQF = new QFilter("reviewactivity", "=", (Object)Long.parseLong(activityId));
        DynamicObject[] groups = groupServiceHelper.query("number,id", new QFilter[]{activityQF});
        Map<String, Long> num2id = Arrays.stream(groups).collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLong("id"), (k1, k2) -> k1));
        String talentFilesStr = option.getVariableValue("talentFiles");
        if (HRStringUtils.isEmpty((String)talentFilesStr)) {
            return;
        }
        List<DynamicObject> dynamicObjects = Lists.newArrayListWithExpectedSize((int)successData.size());
        List talentFiles = SerializationUtils.fromJsonStringToList((String)talentFilesStr, Long.class);
        Pair talentFileRange = ((ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class)).listActivityTalentFilesByPersonScope(Long.parseLong(activityId));
        if (!((Boolean)talentFileRange.getKey()).booleanValue() && talentFiles.size() > 0) {
            DynamicObject[] talentFileList = ((TalentFileQueryService)ServiceFactory.getService(TalentFileQueryService.class)).listTalentFile(talentFiles);
            dynamicObjects = ((ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class)).generatorNotJoinedReviewObject(talentFileList, Long.valueOf(Long.parseLong(activityId)));
        } else {
            QFilter activityFilter = new QFilter("reviewactivity.id", "=", (Object)Long.parseLong(activityId));
            QFilter talentFileIdFilter = new QFilter("talentfile.id", "in", (Object)talentFiles);
            QFilter reviewGroupFilter = new QFilter("reviewgroup.id", "=", (Object)0L);
            DynamicObject[] notJoinedObj = REVIEWOBJECT_REPOSITORY.query("reviewgroup,reviewstatus,person,talentfile.iderrormsgentry,errormsgentry.errormsgtype,errormsgentry.errormsgcontent", new QFilter[]{activityFilter, talentFileIdFilter, reviewGroupFilter});
            List notJoinedFileIds = Arrays.stream(notJoinedObj).map(o -> o.getLong("talentfile.id")).collect(Collectors.toList());
            dynamicObjects.addAll(Arrays.asList(notJoinedObj));
            ArrayList newReviewObjFiles = Lists.newArrayListWithExpectedSize((int)talentFiles.size());
            for (Long fileId : talentFiles) {
                if (notJoinedFileIds.contains(fileId)) continue;
                newReviewObjFiles.add(fileId);
            }
            DynamicObject[] talentFileList = ((TalentFileQueryService)ServiceFactory.getService(TalentFileQueryService.class)).listTalentFile((List)newReviewObjFiles);
            List generateReviewObjs = ((ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class)).generatorNotJoinedReviewObject(talentFileList, Long.valueOf(Long.parseLong(activityId)));
            dynamicObjects.addAll(generateReviewObjs);
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            String num = dynamicObject.getString("number");
            dynamicObject.set("reviewgroup", (Object)num2id.get(num2group.get(num)));
            if (ActivityStatusEnum.WAIT_START.getCode().equals(activityStatus)) {
                dynamicObject.set("reviewstatus", (Object)ObjectStatusEnum.WAIT_START.getCode());
                continue;
            }
            dynamicObject.set("reviewstatus", (Object)ObjectStatusEnum.GOING_UNCHECK.getCode());
        }
        ReviewObjImportSaveOp.markQuitMsg(dynamicObjects);
        REVIEWOBJECT_REPOSITORY.save(dynamicObjects.toArray(new DynamicObject[0]));
    }

    private static void markQuitMsg(List<DynamicObject> joinedObjs) {
        List personIds = joinedObjs.stream().map(obj -> obj.getLong("person.id")).collect(Collectors.toList());
        Map personIsQuit = ((PersonAboutQueryService)ServiceFactory.getService(PersonAboutQueryService.class)).getPersonInAndQuit(personIds);
        for (DynamicObject joinedObj : joinedObjs) {
            DynamicObjectCollection errorMsgEntry;
            boolean hasErrorInfo;
            long personId = joinedObj.getLong("person.id");
            Boolean isQuit = (Boolean)personIsQuit.get(personId);
            if (!Objects.nonNull(isQuit) || !isQuit.booleanValue() || (hasErrorInfo = (errorMsgEntry = joinedObj.getDynamicObjectCollection("errormsgentry")).stream().anyMatch(obj -> "objNotPersonScope".equals(obj.getString("errormsgtype"))))) continue;
            DynamicObject msgEntry = new DynamicObject(errorMsgEntry.getDynamicObjectType());
            msgEntry.set("errormsgtype", (Object)"objNotPersonScope");
            msgEntry.set("errormsgcontent", (Object)ResManager.getLocaleString((String)"\u5df2\u79bb\u804c", (String)"CommUserQuitService_6", (String)"tdc-oatr-mservice"));
            errorMsgEntry.add((Object)msgEntry);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        OperateOption option = this.getOption();
        String activityId = option.getVariableValue("activityId");
        this.reviewActService.saveReviewObjAdminorgTree((List)Lists.newArrayList((Object[])new Long[]{Long.parseLong(activityId)}));
        ((ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class)).recordCollaborationBusinessData(Long.parseLong(activityId));
        this.reviewActivityApplicationService.updateReviewPersonNumber(Long.parseLong(activityId));
    }
}

