/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.activity.reviewobj;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.activity.ReviewActivityService;
import kd.tdc.oatr.bussiness.queryservice.ReviewQuestionService;
import kd.tdc.oatr.common.utils.JsonUtils;
import kd.tdc.oatr.opplugin.validate.reviewobj.ReviewObjectChangeEvaluatorValidator;
import kd.tdc.oatr.opplugin.validate.reviewobj.ReviewObjectReviewGroupPermValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReviewObjectChangeEvaluatorOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("reviewgroup");
        e.getFieldKeys().add("supereval");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReviewObjectReviewGroupPermValidator());
        e.addValidator((AbstractValidator)new ReviewObjectChangeEvaluatorValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        String opData = this.getOption().getVariableValue("op_pop_data", null);
        if (opData != null) {
            DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
            String newEvaluatorStr = this.getOption().getVariableValue("op_pop_data", null);
            if (StringUtils.isNotBlank((CharSequence)newEvaluatorStr)) {
                Map newEvaluatorMap = (Map)JsonUtils.toObject((String)newEvaluatorStr, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){});
                HashMap allOldEvalIds = Maps.newHashMapWithExpectedSize((int)16);
                for (DynamicObject dataEntity : dataEntities) {
                    long reviewObjectId = dataEntity.getLong("id");
                    List superiorPersonIds = (List)newEvaluatorMap.get(reviewObjectId);
                    DynamicObjectCollection superEvalCol = dataEntity.getDynamicObjectCollection("supereval");
                    Set oldEvalIds = superEvalCol.stream().map(obj -> obj.getLong("fbasedataid_id")).filter(personId -> superiorPersonIds == null || !superiorPersonIds.contains(personId)).collect(Collectors.toSet());
                    if (CollectionUtils.isNotEmpty(oldEvalIds)) {
                        allOldEvalIds.put(reviewObjectId, oldEvalIds);
                    }
                    if (CollectionUtils.isEmpty((Collection)superiorPersonIds)) continue;
                    superEvalCol.clear();
                    for (Long personId2 : superiorPersonIds) {
                        DynamicObject tempDyObj = new DynamicObject(superEvalCol.getDynamicObjectType());
                        tempDyObj.set("fbasedataid_id", (Object)personId2);
                        superEvalCol.add((Object)tempDyObj);
                    }
                }
                ((ReviewQuestionService)ServiceFactory.getService(ReviewQuestionService.class)).terminateQuestionByPerson((Map)allOldEvalIds);
                ((ReviewActivityService)ServiceFactory.getService(ReviewActivityService.class)).save(dataEntities);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String activityId = this.getOption().getVariableValue("reviewactivity");
        ((ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class)).recordCollaborationBusinessData(Long.parseLong(activityId));
    }
}

