/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.activity.reviewobj;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.reviewobjct.ReviewObjectService;
import kd.tdc.oatr.bussiness.queryservice.ReviewQuestionService;
import kd.tdc.oatr.bussiness.queryservice.ReviewToolQueryService;
import kd.tdc.oatr.opplugin.validate.reviewobj.ReviewObjectChangeGroupValidator;
import kd.tdc.oatr.opplugin.validate.reviewobj.ReviewObjectReviewGroupPermValidator;
import org.apache.commons.collections4.CollectionUtils;

public class ReviewObjectChangeGroupOp
extends HRDataBaseOp {
    private final ReviewObjectService reviewObjectService = (ReviewObjectService)ServiceFactory.getService(ReviewObjectService.class);
    private final ReviewToolQueryService reviewToolQueryService = (ReviewToolQueryService)ServiceFactory.getService(ReviewToolQueryService.class);
    private final ReviewQuestionService reviewQuestionService = (ReviewQuestionService)ServiceFactory.getService(ReviewQuestionService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("reviewgroup");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReviewObjectReviewGroupPermValidator());
        e.addValidator((AbstractValidator)new ReviewObjectChangeGroupValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        String afterReviewGroup = this.getOption().getVariableValue("after_reviewgroup");
        String activityId = this.getOption().getVariableValue("reviewactivity");
        DynamicObject reviewActivity = this.reviewToolQueryService.getReviewToolByActivityId(Long.parseLong(activityId));
        DynamicObjectCollection innerToolCol = reviewActivity.getDynamicObjectCollection("entryentity_inner");
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        List reviewObjIds = Arrays.stream(dataEntities).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        Map<Long, Set<Long>> groupToolMap = ReviewObjectChangeGroupOp.getGroupToolMap(innerToolCol);
        Set<Long> toolIds = groupToolMap.get(Long.parseLong(afterReviewGroup));
        if (CollectionUtils.isEmpty(toolIds)) {
            this.reviewQuestionService.terminateQuestion(reviewObjIds, ResManager.loadKDString((String)"\u57fa\u4e8e\u4fee\u6539\u76d8\u70b9\u7ec4\u6267\u884c\u95ee\u5377\u7ec8\u6b62", (String)"ReviewQuestionService_1", (String)"tdc-oatr-business", (Object[])new Object[0]));
        } else {
            if (!toolIds.contains(1010L)) {
                this.reviewQuestionService.terminateEmpQuestion(reviewObjIds, ResManager.loadKDString((String)"\u57fa\u4e8e\u4fee\u6539\u76d8\u70b9\u7ec4\u6267\u884c\u95ee\u5377\u7ec8\u6b62", (String)"ReviewQuestionService_1", (String)"tdc-oatr-business", (Object[])new Object[0]));
            }
            if (!toolIds.contains(1020L)) {
                this.reviewQuestionService.terminateSuperiorQuestion(reviewObjIds, ResManager.loadKDString((String)"\u57fa\u4e8e\u4fee\u6539\u76d8\u70b9\u7ec4\u6267\u884c\u95ee\u5377\u7ec8\u6b62", (String)"ReviewQuestionService_1", (String)"tdc-oatr-business", (Object[])new Object[0]));
            }
        }
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("reviewgroup", (Object)afterReviewGroup);
        }
        this.reviewObjectService.save(Arrays.asList(dataEntities));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String activityId = this.getOption().getVariableValue("reviewactivity");
        ((ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class)).recordCollaborationBusinessData(Long.parseLong(activityId));
    }

    private static Map<Long, Set<Long>> getGroupToolMap(DynamicObjectCollection innerToolCol) {
        HashMap groupToolMap = Maps.newHashMapWithExpectedSize((int)innerToolCol.size());
        for (DynamicObject toolEntry : innerToolCol) {
            DynamicObjectCollection groupCol = toolEntry.getDynamicObjectCollection("inner_reviewgroup");
            long questionId = toolEntry.getLong("questionnaire.id");
            for (DynamicObject dynamicObject : groupCol) {
                long groupId = dynamicObject.getLong("fbasedataid_id");
                Set tools = (Set)groupToolMap.get(groupId);
                if (CollectionUtils.isEmpty((Collection)tools)) {
                    tools = Sets.newHashSetWithExpectedSize((int)4);
                    tools.add(questionId);
                    groupToolMap.put(groupId, tools);
                    continue;
                }
                tools.add(questionId);
            }
        }
        return groupToolMap;
    }
}

