/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.activity.reviewobj;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.CalibrateSessionApplicationService;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.activity.ReviewActivityService;
import kd.tdc.oatr.bussiness.domain.calibrate.OnlineCalibrationDomainService;
import kd.tdc.oatr.bussiness.queryservice.ReviewActivityQueryService;
import kd.tdc.oatr.bussiness.queryservice.ReviewQuestionService;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;
import kd.tdc.oatr.opplugin.validate.reviewobj.ReviewObjectDeleteValidator;
import kd.tdc.oatr.opplugin.validate.reviewobj.ReviewObjectReviewGroupPermValidator;

public class ReviewObjectDeleteOp
extends HRDataBaseOp {
    private static final HRBaseServiceHelper REVIEWOBJ_HELPER = new HRBaseServiceHelper("oatr_reviewobject");
    private ReviewActivityApplicationService reviewActivityApplicationService = (ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class);
    private ReviewActivityQueryService reviewActivityQueryService = (ReviewActivityQueryService)ServiceFactory.getService(ReviewActivityQueryService.class);
    private ReviewQuestionService reviewQuestionService = (ReviewQuestionService)ServiceFactory.getService(ReviewQuestionService.class);
    private final ReviewActivityService reviewActService = (ReviewActivityService)ServiceFactory.getService(ReviewActivityService.class);
    private HRBaseServiceHelper ONLINECALIBRATION_HELPER = new HRBaseServiceHelper("oatr_onlinecalibration");
    private final CalibrateSessionApplicationService sessionApplicationService = (CalibrateSessionApplicationService)ServiceFactory.getService(CalibrateSessionApplicationService.class);
    private final OnlineCalibrationDomainService onlineCalibrationService = (OnlineCalibrationDomainService)ServiceFactory.getService(OnlineCalibrationDomainService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Lists.newArrayList((Object[])new String[]{"reviewgroup", "reviewactivity.activitystatus", "errormsgentry", "entryentity_eval", "entryentity_dimension", "entryentity_mapbefore", "entryentity_map", "reviewactivity.id", "reviewstatus"}));
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.getOption().setVariableValue("ignorerefentityids", "oatr_employeeeval,oatr_superioreval,oatr_onlinecalibration");
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReviewObjectDeleteValidator());
        e.addValidator((AbstractValidator)new ReviewObjectReviewGroupPermValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        Long activityId = dataEntities[0].getLong("reviewactivity.id");
        DynamicObject reviewActivity = this.reviewActivityQueryService.getReviewActivity((Object)activityId);
        String filterJson = reviewActivity.getString("perscopefilter_tag");
        if (this.reviewActivityApplicationService.activityConfigPersonScope(filterJson)) {
            beginOperationTransactionArgs.setCancelOperation(true);
            Arrays.stream(dataEntities).forEach(dataEntity -> {
                dataEntity.set("reviewgroup", null);
                dataEntity.set("reviewstatus", (Object)ObjectStatusEnum.UN_IN.getCode());
                dataEntity.getDynamicObjectCollection("errormsgentry").clear();
                dataEntity.getDynamicObjectCollection("entryentity_eval").clear();
                dataEntity.getDynamicObjectCollection("entryentity_dimension").clear();
                dataEntity.getDynamicObjectCollection("entryentity_mapbefore").clear();
                dataEntity.getDynamicObjectCollection("entryentity_map").clear();
            });
            REVIEWOBJ_HELPER.save(dataEntities);
        }
        List<Long> objIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
        this.reviewQuestionService.terminateQuestionByDelete(objIds);
        QFilter reviewObjectQF = new QFilter("reviewobject.id", "in", objIds);
        QFilter calibrateStatusQF = new QFilter("calibratesession.calibratestatus", "!=", (Object)CalibrateSessionStatusEnum.END.getCode());
        List<Long> calibrateIds = this.getCalibrateIds(activityId, objIds);
        this.ONLINECALIBRATION_HELPER.deleteByFilter(new QFilter[]{reviewObjectQF, calibrateStatusQF});
        this.sessionApplicationService.updateCalibrateSessionPersonNum(calibrateIds);
    }

    private List<Long> getCalibrateIds(Long activityId, List<Long> successIds) {
        DynamicObject[] onlineCalibrationsByObj = this.onlineCalibrationService.getOnlineCalibrationDataByReviewObjIds(activityId.longValue(), successIds);
        return Arrays.stream(onlineCalibrationsByObj).map(obj -> obj.getLong("calibratesession")).collect(Collectors.toList());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Long activityId = dataEntities[0].getLong("reviewactivity.id");
        this.reviewActService.saveReviewObjAdminorgTree((List)Lists.newArrayList((Object[])new Long[]{activityId}));
        ((ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class)).recordCollaborationBusinessData(activityId.longValue());
        this.reviewActivityApplicationService.updateReviewPersonNumber(activityId.longValue());
    }
}

