/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.activity.reviewobj;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.activity.ReviewActivityService;
import kd.tdc.oatr.bussiness.queryservice.PersonAboutQueryService;
import kd.tdc.oatr.opplugin.validate.reviewobj.ReviewObjectJoinValidator;
import kd.tdc.oatr.opplugin.validate.reviewobj.ReviewObjectReviewGroupPermValidator;

public class ReviewObjectJoinOp
extends HRDataBaseOp {
    private static final Log log = LogFactory.getLog(ReviewObjectJoinOp.class);
    private final ReviewActivityService reviewActivityService = (ReviewActivityService)ServiceFactory.getService(ReviewActivityService.class);
    private final ReviewActivityService reviewActService = (ReviewActivityService)ServiceFactory.getService(ReviewActivityService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("person");
        e.getFieldKeys().add("reviewgroup");
        e.getFieldKeys().add("talentfile");
        e.getFieldKeys().add("reviewstatus");
        e.getFieldKeys().add("person");
        e.getFieldKeys().add("evaltool");
        e.getFieldKeys().add("evaluationitem");
        e.getFieldKeys().add("errormsgentry");
        e.getFieldKeys().add("errormsgtype");
        e.getFieldKeys().add("errormsgcontent");
        e.getFieldKeys().add("reviewgroup");
        e.getFieldKeys().add("reviewactivity");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReviewObjectReviewGroupPermValidator());
        e.addValidator((AbstractValidator)new ReviewObjectJoinValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        OperateOption option = this.getOption();
        String groupIdStr = option.getVariableValue("reviewgroup");
        long groupId = Long.parseLong(groupIdStr);
        String activityIdStr = option.getVariableValue("reviewactivity");
        long activityId = Long.parseLong(activityIdStr);
        ReviewActivityApplicationService service = (ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class);
        DynamicObject reviewActivity = this.reviewActivityService.getReviewActivity((Object)activityId);
        String activityStatus = reviewActivity.getString("activitystatus");
        List<DynamicObject> joinedObjs = Arrays.asList(e.getDataEntities());
        ReviewObjectJoinOp.markQuitMsg(joinedObjs);
        service.reviewObjectChangeJoined(joinedObjs, Long.valueOf(groupId), activityStatus, Long.valueOf(activityId));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String activityIdStr = this.getOption().getVariableValue("reviewactivity");
        long activityId = Long.parseLong(activityIdStr);
        this.reviewActService.saveReviewObjAdminorgTree((List)Lists.newArrayList((Object[])new Long[]{activityId}));
    }

    private static void markQuitMsg(List<DynamicObject> joinedObjs) {
        List personIds = joinedObjs.stream().map(obj -> obj.getLong("person.id")).collect(Collectors.toList());
        Map personIsQuit = ((PersonAboutQueryService)ServiceFactory.getService(PersonAboutQueryService.class)).getPersonInAndQuit(personIds);
        for (DynamicObject joinedObj : joinedObjs) {
            DynamicObjectCollection errorMsgEntry;
            boolean hasErrorInfo;
            long personId = joinedObj.getLong("person.id");
            Boolean isQuit = (Boolean)personIsQuit.get(personId);
            if (!Objects.nonNull(isQuit) || !isQuit.booleanValue() || (hasErrorInfo = (errorMsgEntry = joinedObj.getDynamicObjectCollection("errormsgentry")).stream().anyMatch(obj -> "objNotPersonScope".equals(obj.getString("errormsgtype"))))) continue;
            DynamicObject msgEntry = new DynamicObject(errorMsgEntry.getDynamicObjectType());
            msgEntry.set("errormsgtype", (Object)"objNotPersonScope");
            msgEntry.set("errormsgcontent", (Object)ResManager.getLocaleString((String)"\u5df2\u79bb\u804c", (String)"CommUserQuitService_6", (String)"tdc-oatr-mservice"));
            errorMsgEntry.add((Object)msgEntry);
        }
    }
}

