/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.activity.reviewobj;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tdc.oatr.bussiness.ServiceFactory;
import kd.tdc.oatr.bussiness.application.CalibrateSessionApplicationService;
import kd.tdc.oatr.bussiness.application.ReviewActivityApplicationService;
import kd.tdc.oatr.bussiness.domain.calibrate.OnlineCalibrationDomainService;
import kd.tdc.oatr.bussiness.queryservice.ReviewQuestionService;
import kd.tdc.oatr.common.constants.enums.CalibrateSessionStatusEnum;
import kd.tdc.oatr.common.constants.enums.ObjectStatusEnum;
import kd.tdc.oatr.opplugin.validate.reviewobj.ReviewObjectReviewGroupPermValidator;
import kd.tdc.oatr.opplugin.validate.reviewobj.ReviewObjectStopValidator;

public class ReviewObjectStopOp
extends HRDataBaseOp {
    private static final HRBaseServiceHelper REVIEWOBJ_HELPER = new HRBaseServiceHelper("oatr_reviewobject");
    private ReviewQuestionService reviewQuestionService = (ReviewQuestionService)ServiceFactory.getService(ReviewQuestionService.class);
    private final CalibrateSessionApplicationService sessionApplicationService = (CalibrateSessionApplicationService)ServiceFactory.getService(CalibrateSessionApplicationService.class);
    private HRBaseServiceHelper ONLINECALIBRATION_HELPER = new HRBaseServiceHelper("oatr_onlinecalibration");
    private final OnlineCalibrationDomainService onlineCalibrationService = (OnlineCalibrationDomainService)ServiceFactory.getService(OnlineCalibrationDomainService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Lists.newArrayList((Object[])new String[]{"reviewactivity.activitystatus", "reviewstatus", "reviewgroup"}));
        e.setFieldKeys(fieldKeys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReviewObjectStopValidator());
        e.addValidator((AbstractValidator)new ReviewObjectReviewGroupPermValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        Arrays.stream(dataEntities).forEach(dataEntity -> dataEntity.set("reviewstatus", (Object)ObjectStatusEnum.STOP_REVIEW.getCode()));
        REVIEWOBJ_HELPER.save(dataEntities);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        long activityId = dataEntities[0].getLong("reviewactivity.id");
        ((ReviewActivityApplicationService)ServiceFactory.getService(ReviewActivityApplicationService.class)).recordCollaborationBusinessData(activityId);
        List<Long> successIds = Arrays.stream(dataEntities).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        this.reviewQuestionService.terminateQuestionByTerminal(successIds);
        QFilter reviewObjectQF = new QFilter("reviewobject.id", "in", successIds);
        QFilter calibrateStatusQF = new QFilter("calibratesession.calibratestatus", "!=", (Object)CalibrateSessionStatusEnum.END.getCode());
        List<Long> calibrateIds = this.getCalibrateIds(activityId, successIds);
        this.ONLINECALIBRATION_HELPER.deleteByFilter(new QFilter[]{reviewObjectQF, calibrateStatusQF});
        this.sessionApplicationService.updateCalibrateSessionPersonNum(calibrateIds);
    }

    private List<Long> getCalibrateIds(Long activityId, List<Long> successIds) {
        DynamicObject[] onlineCalibrationsByObj = this.onlineCalibrationService.getOnlineCalibrationDataByReviewObjIds(activityId.longValue(), successIds);
        return Arrays.stream(onlineCalibrationsByObj).map(obj -> obj.getLong("calibratesession")).collect(Collectors.toList());
    }
}

