/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.validate;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class EvaluationItemSaveValidator
extends HRDataBaseValidator {
    private static final String PAGE_CAPACITY_ITEM = "hbss_capacityitem";
    private static final String KEY_CAPACITY_ITEM = "capacityitem";

    public void validate() {
        super.validate();
        List<Object> itemIdList = this.getCapacityItemIdList();
        if (CollectionUtils.isEmpty(itemIdList)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(PAGE_CAPACITY_ITEM);
        QFilter qFilter = new QFilter("id", "in", itemIdList);
        DynamicObject[] capacityItemDOArr = serviceHelper.query("enable", qFilter.toArray());
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Object capacityItemObj = dynamicObject.get(KEY_CAPACITY_ITEM);
            if (Objects.isNull(capacityItemObj)) continue;
            long itemId = capacityItemObj instanceof DynamicObject ? ((DynamicObject)capacityItemObj).getLong("id") : Long.parseLong(capacityItemObj.toString());
            Optional<DynamicObject> optional = Arrays.stream(capacityItemDOArr).filter(dy -> itemId == dy.getLong("id")).findFirst();
            if (!optional.isPresent()) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u80fd\u529b\u7d20\u8d28\u9879\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\u3002", (String)"EvaluationItemSaveValidator_0", (String)"tdc-oatr-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject capacityItem = optional.get();
            if (HRStringUtils.equals((String)"1", (String)capacityItem.getString("enable"))) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u53ef\u5f15\u7528\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u53ef\u7528\u201d\u7684\u80fd\u529b\u7d20\u8d28\u9879\u3002", (String)"EvaluationItemSaveValidator_1", (String)"tdc-oatr-opplugin", (Object[])new Object[0]));
        }
    }

    private List<Object> getCapacityItemIdList() {
        return Arrays.stream(this.getDataEntities()).map(extendedDataEntity -> {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            Object capacityItemObj = dynamicObject.get(KEY_CAPACITY_ITEM);
            if (Objects.nonNull(capacityItemObj)) {
                if (capacityItemObj instanceof DynamicObject) {
                    return ((DynamicObject)capacityItemObj).getLong("id");
                }
                if (capacityItemObj instanceof Long) {
                    return capacityItemObj;
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

