/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.validate;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tdc.oatr.common.constants.enums.ActivityStatusEnum;
import kd.tdc.oatr.common.constants.enums.PlanStatusEnum;

public class ReviewPlanStopValidator
extends HRDataBaseValidator {
    private static final HRBaseServiceHelper REVIEWACTIVITY_REPOSITORY = new HRBaseServiceHelper("oatr_reviewactivity");

    public void validate() {
        super.validate();
        Arrays.stream(this.getDataEntities()).forEach(extendedDataEntity -> {
            DynamicObject[] activitys;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String planStatus = dataEntity.getString("planstatus");
            HashSet status = Sets.newHashSet((Object[])new String[]{PlanStatusEnum.GOING.getCode(), PlanStatusEnum.WAIT_START.getCode()});
            if (!status.contains(planStatus)) {
                String errorMsg = ResManager.loadKDString((String)"\u4ec5\u53ef\u7ec8\u6b62\u72b6\u6001\u4e3a\u201c\u8fdb\u884c\u4e2d\u201d\u3001\u201c\u5f85\u542f\u52a8\u201d\u7684\u76d8\u70b9\u8ba1\u5212\u3002", (String)"ReviewPlanStopValidator_0", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, errorMsg);
            }
            QFilter reviewPlanQFilter = new QFilter("reviewplan.id", "=", (Object)dataEntity.getLong("id"));
            for (DynamicObject activity : activitys = REVIEWACTIVITY_REPOSITORY.query("activitystatus", new QFilter[]{reviewPlanQFilter})) {
                if (HRStringUtils.equals((String)activity.getString("activitystatus"), (String)ActivityStatusEnum.WAIT_START.getCode()) || HRStringUtils.equals((String)activity.getString("activitystatus"), (String)ActivityStatusEnum.STOP.getCode())) continue;
                String errorMsg = ResManager.loadKDString((String)"\u76d8\u70b9\u8ba1\u5212\u4e0b\u6240\u6709\u6d3b\u52a8\u72b6\u6001\u5747\u4e3a\u201c\u5f85\u542f\u52a8\u201d\u3001\u201c\u5df2\u7ec8\u6b62\u201d\u624d\u80fd\u7ec8\u6b62\u3002", (String)"ReviewPlanStopValidator_1", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, errorMsg);
                break;
            }
        });
    }
}

