/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.oatr.opplugin.validate.activity.template;

import java.util.Arrays;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class ReviewActivityTplDeleteValidator
extends HRDataBaseValidator {
    private static final HRBaseServiceHelper REVIEWGROUP_REPOSITORY = new HRBaseServiceHelper("oatr_reviewgroup");
    private static final HRBaseServiceHelper COL_REVIEW_ACTIVITY_REPOSITORY = new HRBaseServiceHelper("oatr_colreviewactivity");

    public void validate() {
        super.validate();
        Arrays.stream(this.getDataEntities()).forEach(extendedDataEntity -> {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            QFilter userQFilter = new QFilter("entryentity.collaborator", "=", (Object)RequestContext.get().getCurrUserId());
            QFilter statusQFilter = new QFilter("entryentity.colstatus", "=", (Object)"1");
            DynamicObject[] collaborators = REVIEWGROUP_REPOSITORY.query("entryentity,reviewactivity.id", new QFilter[]{userQFilter, statusQFilter});
            if (collaborators.length == 0) {
                return;
            }
            QFilter reviewActivityIdQFilter = new QFilter("id", "in", Arrays.stream(collaborators).map(d -> d.getLong("reviewactivity.id")).collect(Collectors.toSet()));
            QFilter tplQFilter = new QFilter("activitytemplate", "=", (Object)dataEntity.getLong("id"));
            if (COL_REVIEW_ACTIVITY_REPOSITORY.isExists(new QFilter[]{reviewActivityIdQFilter, tplQFilter})) {
                String errorMsg = ResManager.loadKDString((String)"\u201c\u6211\u534f\u4f5c\u7684\u76d8\u70b9\u6d3b\u52a8\u201d\u7684\u5b57\u6bb5\u201c\u76d8\u70b9\u6d3b\u52a8\u6a21\u677f\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"ReviewActivityTplDeleteValidator_0", (String)"tdc-oatr-opplugin", (Object[])new Object[0]);
                this.addMessage((ExtendedDataEntity)extendedDataEntity, errorMsg, ErrorLevel.Error);
            }
        });
    }
}

